/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.remoting.support;

import com.bea.core.repackaged.aopalliance.intercept.MethodInterceptor;
import com.bea.core.repackaged.aopalliance.intercept.MethodInvocation;
import com.bea.core.repackaged.apache.commons.logging.Log;
import com.bea.core.repackaged.apache.commons.logging.LogFactory;
import com.bea.core.repackaged.springframework.util.ClassUtils;
import java.lang.reflect.Method;

public class RemoteInvocationTraceInterceptor
implements MethodInterceptor {
    protected static final Log logger = LogFactory.getLog((Class)RemoteInvocationTraceInterceptor.class);
    private final String exporterName;

    public RemoteInvocationTraceInterceptor(String protocolName) {
        this.exporterName = protocolName;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Method method = invocation.getMethod();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Incoming " + this.exporterName + " remote call: " + ClassUtils.getQualifiedMethodName(method)));
        }
        try {
            Object retVal = invocation.proceed();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Finished processing of " + this.exporterName + " remote call: " + ClassUtils.getQualifiedMethodName(method)));
            }
            return retVal;
        }
        catch (Throwable ex) {
            if (ex instanceof RuntimeException || ex instanceof Error) {
                if (logger.isWarnEnabled()) {
                    logger.warn((Object)("Processing of " + this.exporterName + " remote call resulted in fatal exception: " + ClassUtils.getQualifiedMethodName(method)), ex);
                }
            } else if (logger.isInfoEnabled()) {
                logger.info((Object)("Processing of " + this.exporterName + " remote call resulted in exception: " + ClassUtils.getQualifiedMethodName(method)), ex);
            }
            throw ex;
        }
    }
}

