/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.scheduling.backportconcurrent;

import com.bea.core.repackaged.springframework.core.task.TaskRejectedException;
import com.bea.core.repackaged.springframework.scheduling.SchedulingTaskExecutor;
import edu.emory.mathcs.backport.java.util.concurrent.Executor;
import edu.emory.mathcs.backport.java.util.concurrent.Executors;
import edu.emory.mathcs.backport.java.util.concurrent.RejectedExecutionException;

public class ConcurrentTaskExecutor
implements SchedulingTaskExecutor,
Executor {
    private Executor concurrentExecutor;

    public ConcurrentTaskExecutor() {
        this.setConcurrentExecutor(null);
    }

    public ConcurrentTaskExecutor(Executor concurrentExecutor) {
        this.setConcurrentExecutor(concurrentExecutor);
    }

    public void setConcurrentExecutor(Executor concurrentExecutor) {
        this.concurrentExecutor = concurrentExecutor != null ? concurrentExecutor : Executors.newSingleThreadExecutor();
    }

    public Executor getConcurrentExecutor() {
        return this.concurrentExecutor;
    }

    public void execute(Runnable task) {
        try {
            this.concurrentExecutor.execute(task);
        }
        catch (RejectedExecutionException ex) {
            throw new TaskRejectedException("Executor [" + this.concurrentExecutor + "] did not accept task: " + task, ex);
        }
    }

    public boolean prefersShortLivedTasks() {
        return true;
    }
}

