/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.scheduling.timer;

import com.bea.core.repackaged.apache.commons.logging.Log;
import com.bea.core.repackaged.apache.commons.logging.LogFactory;
import com.bea.core.repackaged.springframework.beans.factory.BeanNameAware;
import com.bea.core.repackaged.springframework.beans.factory.DisposableBean;
import com.bea.core.repackaged.springframework.beans.factory.FactoryBean;
import com.bea.core.repackaged.springframework.beans.factory.InitializingBean;
import com.bea.core.repackaged.springframework.core.JdkVersion;
import com.bea.core.repackaged.springframework.scheduling.timer.ScheduledTimerTask;
import com.bea.core.repackaged.springframework.util.ObjectUtils;
import com.bea.core.repackaged.springframework.util.StringUtils;
import java.util.Timer;

public class TimerFactoryBean
implements FactoryBean,
BeanNameAware,
InitializingBean,
DisposableBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private ScheduledTimerTask[] scheduledTimerTasks;
    private boolean daemon = false;
    private String beanName;
    private Timer timer;

    public void setScheduledTimerTasks(ScheduledTimerTask[] scheduledTimerTasks) {
        this.scheduledTimerTasks = scheduledTimerTasks;
    }

    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public void afterPropertiesSet() {
        this.logger.info((Object)"Initializing Timer");
        this.timer = this.createTimer(this.beanName, this.daemon);
        if (!ObjectUtils.isEmpty(this.scheduledTimerTasks)) {
            this.registerTasks(this.scheduledTimerTasks, this.timer);
        }
    }

    protected Timer createTimer(String name, boolean daemon) {
        Timer timer = this.createTimer(daemon);
        if (timer != null) {
            return timer;
        }
        if (StringUtils.hasText(name) && JdkVersion.isAtLeastJava15()) {
            return new Timer(name, daemon);
        }
        return new Timer(daemon);
    }

    protected Timer createTimer(boolean daemon) {
        return null;
    }

    protected void registerTasks(ScheduledTimerTask[] tasks, Timer timer) {
        for (int i = 0; i < tasks.length; ++i) {
            ScheduledTimerTask task = tasks[i];
            if (task.isOneTimeTask()) {
                timer.schedule(task.getTimerTask(), task.getDelay());
                continue;
            }
            if (task.isFixedRate()) {
                timer.scheduleAtFixedRate(task.getTimerTask(), task.getDelay(), task.getPeriod());
                continue;
            }
            timer.schedule(task.getTimerTask(), task.getDelay(), task.getPeriod());
        }
    }

    public Object getObject() {
        return this.timer;
    }

    public Class getObjectType() {
        return Timer.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void destroy() {
        this.logger.info((Object)"Cancelling Timer");
        this.timer.cancel();
    }
}

