/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.transaction.interceptor;

import com.bea.core.repackaged.springframework.beans.factory.InitializingBean;
import com.bea.core.repackaged.springframework.metadata.Attributes;
import com.bea.core.repackaged.springframework.transaction.interceptor.AbstractFallbackTransactionAttributeSource;
import com.bea.core.repackaged.springframework.transaction.interceptor.RollbackRuleAttribute;
import com.bea.core.repackaged.springframework.transaction.interceptor.RuleBasedTransactionAttribute;
import com.bea.core.repackaged.springframework.transaction.interceptor.TransactionAttribute;
import com.bea.core.repackaged.springframework.util.Assert;
import com.bea.core.repackaged.springframework.util.ObjectUtils;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public class AttributesTransactionAttributeSource
extends AbstractFallbackTransactionAttributeSource
implements InitializingBean {
    private Attributes attributes;

    public AttributesTransactionAttributeSource() {
    }

    public AttributesTransactionAttributeSource(Attributes attributes) {
        Assert.notNull(attributes, "Attributes must not be null");
        this.attributes = attributes;
    }

    public void setAttributes(Attributes attributes) {
        this.attributes = attributes;
    }

    public void afterPropertiesSet() {
        Assert.notNull(this.attributes, "Property 'attributes' is required");
    }

    protected TransactionAttribute findTransactionAttribute(Method method) {
        Assert.notNull(this.attributes, "Property 'attributes' is required");
        return this.findTransactionAttribute(this.attributes.getAttributes(method));
    }

    protected TransactionAttribute findTransactionAttribute(Class clazz) {
        Assert.notNull(this.attributes, "Property 'attributes' is required");
        return this.findTransactionAttribute(this.attributes.getAttributes(clazz));
    }

    protected TransactionAttribute findTransactionAttribute(Collection atts) {
        if (atts == null) {
            return null;
        }
        TransactionAttribute txAttribute = null;
        Iterator it = atts.iterator();
        while (it.hasNext() && txAttribute == null) {
            Object att = it.next();
            if (!(att instanceof TransactionAttribute)) continue;
            txAttribute = (TransactionAttribute)att;
        }
        if (txAttribute instanceof RuleBasedTransactionAttribute) {
            RuleBasedTransactionAttribute rbta = (RuleBasedTransactionAttribute)txAttribute;
            LinkedList rollbackRules = new LinkedList();
            Iterator it2 = atts.iterator();
            while (it2.hasNext()) {
                Object att = it2.next();
                if (!(att instanceof RollbackRuleAttribute)) continue;
                rollbackRules.add(att);
            }
            rbta.setRollbackRules(rollbackRules);
        }
        return txAttribute;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AttributesTransactionAttributeSource)) {
            return false;
        }
        AttributesTransactionAttributeSource otherTas = (AttributesTransactionAttributeSource)other;
        return ObjectUtils.nullSafeEquals(this.attributes, otherTas.attributes);
    }

    public int hashCode() {
        return AttributesTransactionAttributeSource.class.hashCode();
    }
}

