/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.transaction.interceptor;

import com.bea.core.repackaged.springframework.transaction.interceptor.TransactionAttribute;
import com.bea.core.repackaged.springframework.transaction.interceptor.TransactionAttributeSource;
import com.bea.core.repackaged.springframework.util.Assert;
import java.io.Serializable;
import java.lang.reflect.Method;

public class CompositeTransactionAttributeSource
implements TransactionAttributeSource,
Serializable {
    private final TransactionAttributeSource[] transactionAttributeSources;

    public CompositeTransactionAttributeSource(TransactionAttributeSource[] transactionAttributeSources) {
        Assert.notNull(transactionAttributeSources, "TransactionAttributeSource array must not be null");
        this.transactionAttributeSources = transactionAttributeSources;
    }

    public final TransactionAttributeSource[] getTransactionAttributeSources() {
        return this.transactionAttributeSources;
    }

    public TransactionAttribute getTransactionAttribute(Method method, Class targetClass) {
        for (int i = 0; i < this.transactionAttributeSources.length; ++i) {
            TransactionAttributeSource tas = this.transactionAttributeSources[i];
            TransactionAttribute ta = tas.getTransactionAttribute(method, targetClass);
            if (ta == null) continue;
            return ta;
        }
        return null;
    }
}

