/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.transaction.interceptor;

import com.bea.core.repackaged.apache.commons.logging.Log;
import com.bea.core.repackaged.apache.commons.logging.LogFactory;
import com.bea.core.repackaged.springframework.transaction.interceptor.DefaultTransactionAttribute;
import com.bea.core.repackaged.springframework.transaction.interceptor.NoRollbackRuleAttribute;
import com.bea.core.repackaged.springframework.transaction.interceptor.RollbackRuleAttribute;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class RuleBasedTransactionAttribute
extends DefaultTransactionAttribute
implements Serializable {
    public static final String PREFIX_ROLLBACK_RULE = "-";
    public static final String PREFIX_COMMIT_RULE = "+";
    private static final Log logger = LogFactory.getLog((Class)RuleBasedTransactionAttribute.class);
    private List rollbackRules;

    public RuleBasedTransactionAttribute() {
    }

    public RuleBasedTransactionAttribute(RuleBasedTransactionAttribute other) {
        super(other);
        this.rollbackRules = new ArrayList(other.rollbackRules);
    }

    public RuleBasedTransactionAttribute(int propagationBehavior, List rollbackRules) {
        super(propagationBehavior);
        this.rollbackRules = rollbackRules;
    }

    public void setRollbackRules(List rollbackRules) {
        this.rollbackRules = rollbackRules;
    }

    public List getRollbackRules() {
        if (this.rollbackRules == null) {
            this.rollbackRules = new LinkedList();
        }
        return this.rollbackRules;
    }

    public boolean rollbackOn(Throwable ex) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Applying rules to determine whether transaction should rollback on " + ex));
        }
        RollbackRuleAttribute winner = null;
        int deepest = Integer.MAX_VALUE;
        if (this.rollbackRules != null) {
            Iterator it = this.rollbackRules.iterator();
            while (it.hasNext()) {
                RollbackRuleAttribute rule = (RollbackRuleAttribute)it.next();
                int depth = rule.getDepth(ex);
                if (depth < 0 || depth >= deepest) continue;
                deepest = depth;
                winner = rule;
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Winning rollback rule is: " + winner));
        }
        if (winner == null) {
            logger.trace((Object)"No relevant rollback rule found: applying default rules");
            return super.rollbackOn(ex);
        }
        return !(winner instanceof NoRollbackRuleAttribute);
    }

    public String toString() {
        StringBuffer result = this.getDefinitionDescription();
        if (this.rollbackRules != null) {
            Iterator it = this.rollbackRules.iterator();
            while (it.hasNext()) {
                RollbackRuleAttribute rule = (RollbackRuleAttribute)it.next();
                String sign = rule instanceof NoRollbackRuleAttribute ? PREFIX_COMMIT_RULE : PREFIX_ROLLBACK_RULE;
                result.append(',').append(sign).append(rule.getExceptionName());
            }
        }
        return result.toString();
    }
}

