/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.transaction.jta;

import com.bea.core.repackaged.springframework.transaction.TransactionSystemException;
import com.bea.core.repackaged.springframework.transaction.support.SmartTransactionObject;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;

public class JtaTransactionObject
implements SmartTransactionObject {
    private final UserTransaction userTransaction;

    public JtaTransactionObject(UserTransaction userTransaction) {
        this.userTransaction = userTransaction;
    }

    public final UserTransaction getUserTransaction() {
        return this.userTransaction;
    }

    public boolean isRollbackOnly() {
        if (this.userTransaction == null) {
            return false;
        }
        try {
            int jtaStatus = this.userTransaction.getStatus();
            return jtaStatus == 1 || jtaStatus == 4;
        }
        catch (SystemException ex) {
            throw new TransactionSystemException("JTA failure on getStatus", ex);
        }
    }
}

