/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.transaction.jta;

import com.bea.core.repackaged.apache.commons.logging.Log;
import com.bea.core.repackaged.apache.commons.logging.LogFactory;
import com.bea.core.repackaged.springframework.beans.factory.FactoryBean;
import com.bea.core.repackaged.springframework.transaction.TransactionSystemException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.transaction.TransactionManager;

public class WebSphereTransactionManagerFactoryBean
implements FactoryBean {
    private static final String FACTORY_CLASS_5_1 = "com.ibm.ws.Transaction.TransactionManagerFactory";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final TransactionManager transactionManager;

    public WebSphereTransactionManagerFactoryBean() throws TransactionSystemException {
        try {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(FACTORY_CLASS_5_1);
            Method method = clazz.getMethod("getTransactionManager", null);
            this.transactionManager = (TransactionManager)method.invoke(null, (Object[])null);
        }
        catch (ClassNotFoundException ex) {
            throw new TransactionSystemException("Could not find WebSphere 5.1/6.0/6.1 TransactionManager factory class", ex);
        }
        catch (InvocationTargetException ex) {
            throw new TransactionSystemException("WebSphere's TransactionManagerFactory.getTransactionManager method failed", ex.getTargetException());
        }
        catch (Exception ex) {
            throw new TransactionSystemException("Could not access WebSphere's TransactionManagerFactory.getTransactionManager method", ex);
        }
    }

    public Object getObject() {
        return this.transactionManager;
    }

    public Class getObjectType() {
        return this.transactionManager.getClass();
    }

    public boolean isSingleton() {
        return true;
    }
}

