/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.transaction.support;

import com.bea.core.repackaged.apache.commons.logging.Log;
import com.bea.core.repackaged.apache.commons.logging.LogFactory;
import com.bea.core.repackaged.springframework.beans.factory.InitializingBean;
import com.bea.core.repackaged.springframework.transaction.PlatformTransactionManager;
import com.bea.core.repackaged.springframework.transaction.TransactionDefinition;
import com.bea.core.repackaged.springframework.transaction.TransactionException;
import com.bea.core.repackaged.springframework.transaction.TransactionStatus;
import com.bea.core.repackaged.springframework.transaction.TransactionSystemException;
import com.bea.core.repackaged.springframework.transaction.support.CallbackPreferringPlatformTransactionManager;
import com.bea.core.repackaged.springframework.transaction.support.DefaultTransactionDefinition;
import com.bea.core.repackaged.springframework.transaction.support.TransactionCallback;
import com.bea.core.repackaged.springframework.transaction.support.TransactionOperations;

public class TransactionTemplate
extends DefaultTransactionDefinition
implements TransactionOperations,
InitializingBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private PlatformTransactionManager transactionManager;

    public TransactionTemplate() {
    }

    public TransactionTemplate(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public TransactionTemplate(PlatformTransactionManager transactionManager, TransactionDefinition transactionDefinition) {
        super(transactionDefinition);
        this.transactionManager = transactionManager;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void afterPropertiesSet() {
        if (this.transactionManager == null) {
            throw new IllegalArgumentException("Property 'transactionManager' is required");
        }
    }

    public Object execute(TransactionCallback action) throws TransactionException {
        if (this.transactionManager instanceof CallbackPreferringPlatformTransactionManager) {
            return ((CallbackPreferringPlatformTransactionManager)this.transactionManager).execute(this, action);
        }
        TransactionStatus status = this.transactionManager.getTransaction(this);
        Object result = null;
        try {
            result = action.doInTransaction(status);
        }
        catch (RuntimeException ex) {
            this.rollbackOnException(status, ex);
            throw ex;
        }
        catch (Error err) {
            this.rollbackOnException(status, err);
            throw err;
        }
        this.transactionManager.commit(status);
        return result;
    }

    private void rollbackOnException(TransactionStatus status, Throwable ex) throws TransactionException {
        this.logger.debug((Object)"Initiating transaction rollback on application exception", ex);
        try {
            this.transactionManager.rollback(status);
        }
        catch (TransactionSystemException ex2) {
            this.logger.error((Object)"Application exception overridden by rollback exception", ex);
            ex2.initApplicationException(ex);
            throw ex2;
        }
        catch (RuntimeException ex2) {
            this.logger.error((Object)"Application exception overridden by rollback exception", ex);
            throw ex2;
        }
        catch (Error err) {
            this.logger.error((Object)"Application exception overridden by rollback error", ex);
            throw err;
        }
    }
}

