/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.ui;

import com.bea.core.repackaged.springframework.core.Conventions;
import com.bea.core.repackaged.springframework.util.Assert;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class ModelMap
extends LinkedHashMap {
    public ModelMap() {
    }

    public ModelMap(String attributeName, Object attributeValue) {
        this.addAttribute(attributeName, attributeValue);
    }

    public ModelMap(Object attributeValue) {
        this.addAttribute(attributeValue);
    }

    public ModelMap addAttribute(String attributeName, Object attributeValue) {
        Assert.notNull(attributeName, "Model attribute name must not be null");
        this.put(attributeName, attributeValue);
        return this;
    }

    public ModelMap addAttribute(Object attributeValue) {
        Assert.notNull(attributeValue, "Model object must not be null");
        if (attributeValue instanceof Collection && ((Collection)attributeValue).isEmpty()) {
            return this;
        }
        return this.addAttribute(Conventions.getVariableName(attributeValue), attributeValue);
    }

    public ModelMap addAllAttributes(Collection attributeValues) {
        if (attributeValues != null) {
            Iterator it = attributeValues.iterator();
            while (it.hasNext()) {
                this.addAttribute(it.next());
            }
        }
        return this;
    }

    public ModelMap addAllAttributes(Map attributes) {
        if (attributes != null) {
            this.putAll(attributes);
        }
        return this;
    }

    public ModelMap mergeAttributes(Map attributes) {
        if (attributes != null) {
            Iterator it = attributes.keySet().iterator();
            while (it.hasNext()) {
                Object key = it.next();
                if (this.containsKey(key)) continue;
                this.put(key, attributes.get(key));
            }
        }
        return this;
    }

    public boolean containsAttribute(String attributeName) {
        return this.containsKey(attributeName);
    }

    public ModelMap addObject(String modelName, Object modelObject) {
        return this.addAttribute(modelName, modelObject);
    }

    public ModelMap addObject(Object modelObject) {
        return this.addAttribute(modelObject);
    }

    public ModelMap addAllObjects(Collection objects) {
        return this.addAllAttributes(objects);
    }

    public ModelMap addAllObjects(Map objects) {
        return this.addAllAttributes(objects);
    }
}

