/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.util;

import com.bea.core.repackaged.springframework.util.Assert;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class AutoPopulatingList
implements List,
Serializable {
    private final List backingList;
    private final ElementFactory elementFactory;

    public AutoPopulatingList(Class elementClass) {
        this(new ArrayList(), elementClass);
    }

    public AutoPopulatingList(List backingList, Class elementClass) {
        this(backingList, new ReflectiveElementFactory(elementClass));
    }

    public AutoPopulatingList(ElementFactory elementFactory) {
        this(new ArrayList(), elementFactory);
    }

    public AutoPopulatingList(List backingList, ElementFactory elementFactory) {
        Assert.notNull(backingList, "Backing List must not be null");
        Assert.notNull(elementFactory, "Element factory must not be null");
        this.backingList = backingList;
        this.elementFactory = elementFactory;
    }

    public void add(int index, Object element) {
        this.backingList.add(index, element);
    }

    public boolean add(Object o) {
        return this.backingList.add(o);
    }

    public boolean addAll(Collection c) {
        return this.backingList.addAll(c);
    }

    public boolean addAll(int index, Collection c) {
        return this.backingList.addAll(index, c);
    }

    public void clear() {
        this.backingList.clear();
    }

    public boolean contains(Object o) {
        return this.backingList.contains(o);
    }

    public boolean containsAll(Collection c) {
        return this.backingList.containsAll(c);
    }

    public boolean equals(Object o) {
        return ((Object)this.backingList).equals(o);
    }

    public Object get(int index) {
        int backingListSize = this.backingList.size();
        Object element = null;
        if (index < backingListSize) {
            element = this.backingList.get(index);
            if (element == null) {
                element = this.elementFactory.createElement(index);
                this.backingList.set(index, element);
            }
        } else {
            for (int x = backingListSize; x < index; ++x) {
                this.backingList.add(null);
            }
            element = this.elementFactory.createElement(index);
            this.backingList.add(element);
        }
        return element;
    }

    public int hashCode() {
        return ((Object)this.backingList).hashCode();
    }

    public int indexOf(Object o) {
        return this.backingList.indexOf(o);
    }

    public boolean isEmpty() {
        return this.backingList.isEmpty();
    }

    public Iterator iterator() {
        return this.backingList.iterator();
    }

    public int lastIndexOf(Object o) {
        return this.backingList.lastIndexOf(o);
    }

    public ListIterator listIterator() {
        return this.backingList.listIterator();
    }

    public ListIterator listIterator(int index) {
        return this.backingList.listIterator(index);
    }

    public Object remove(int index) {
        return this.backingList.remove(index);
    }

    public boolean remove(Object o) {
        return this.backingList.remove(o);
    }

    public boolean removeAll(Collection c) {
        return this.backingList.removeAll(c);
    }

    public boolean retainAll(Collection c) {
        return this.backingList.retainAll(c);
    }

    public Object set(int index, Object element) {
        return this.backingList.set(index, element);
    }

    public int size() {
        return this.backingList.size();
    }

    public List subList(int fromIndex, int toIndex) {
        return this.backingList.subList(fromIndex, toIndex);
    }

    public Object[] toArray() {
        return this.backingList.toArray();
    }

    public Object[] toArray(Object[] a) {
        return this.backingList.toArray(a);
    }

    private static class ReflectiveElementFactory
    implements ElementFactory,
    Serializable {
        private final Class elementClass;

        public ReflectiveElementFactory(Class elementClass) {
            Assert.notNull(elementClass, "Element clas must not be null");
            Assert.isTrue(!elementClass.isInterface(), "Element class must not be an interface type");
            Assert.isTrue(!Modifier.isAbstract(elementClass.getModifiers()), "Element class cannot be an abstract class");
            this.elementClass = elementClass;
        }

        public Object createElement(int index) {
            try {
                return this.elementClass.newInstance();
            }
            catch (InstantiationException ex) {
                throw new ElementInstantiationException("Unable to instantiate element class [" + this.elementClass.getName() + "]. Root cause is " + ex);
            }
            catch (IllegalAccessException ex) {
                throw new ElementInstantiationException("Cannot access element class [" + this.elementClass.getName() + "]. Root cause is " + ex);
            }
        }
    }

    public static class ElementInstantiationException
    extends RuntimeException {
        public ElementInstantiationException(String msg) {
            super(msg);
        }
    }

    public static interface ElementFactory {
        public Object createElement(int var1) throws ElementInstantiationException;
    }
}

