/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.util;

import java.text.NumberFormat;
import java.util.LinkedList;
import java.util.List;

public class StopWatch {
    private final String id;
    private boolean keepTaskList = true;
    private final List taskList = new LinkedList();
    private long startTimeMillis;
    private boolean running;
    private String currentTaskName;
    private TaskInfo lastTaskInfo;
    private int taskCount;
    private long totalTimeMillis;

    public StopWatch() {
        this.id = "";
    }

    public StopWatch(String id) {
        this.id = id;
    }

    public void setKeepTaskList(boolean keepTaskList) {
        this.keepTaskList = keepTaskList;
    }

    public void start() throws IllegalStateException {
        this.start("");
    }

    public void start(String taskName) throws IllegalStateException {
        if (this.running) {
            throw new IllegalStateException("Can't start StopWatch: it's already running");
        }
        this.startTimeMillis = System.currentTimeMillis();
        this.running = true;
        this.currentTaskName = taskName;
    }

    public void stop() throws IllegalStateException {
        if (!this.running) {
            throw new IllegalStateException("Can't stop StopWatch: it's not running");
        }
        long lastTime = System.currentTimeMillis() - this.startTimeMillis;
        this.totalTimeMillis += lastTime;
        this.lastTaskInfo = new TaskInfo(this.currentTaskName, lastTime);
        if (this.keepTaskList) {
            this.taskList.add(this.lastTaskInfo);
        }
        ++this.taskCount;
        this.running = false;
        this.currentTaskName = null;
    }

    public boolean isRunning() {
        return this.running;
    }

    public long getLastTaskTimeMillis() throws IllegalStateException {
        if (this.lastTaskInfo == null) {
            throw new IllegalStateException("No tests run: can't get last interval");
        }
        return this.lastTaskInfo.getTimeMillis();
    }

    public long getTotalTimeMillis() {
        return this.totalTimeMillis;
    }

    public double getTotalTimeSeconds() {
        return (double)this.totalTimeMillis / 1000.0;
    }

    public int getTaskCount() {
        return this.taskCount;
    }

    public TaskInfo[] getTaskInfo() {
        if (!this.keepTaskList) {
            throw new UnsupportedOperationException("Task info is not being kept!");
        }
        return this.taskList.toArray(new TaskInfo[this.taskList.size()]);
    }

    public String shortSummary() {
        return "StopWatch '" + this.id + "': running time (millis) = " + this.getTotalTimeMillis();
    }

    public String prettyPrint() {
        StringBuffer sb = new StringBuffer(this.shortSummary());
        sb.append('\n');
        if (!this.keepTaskList) {
            sb.append("No task info kept");
        } else {
            TaskInfo[] tasks = this.getTaskInfo();
            sb.append("-----------------------------------------\n");
            sb.append("ms     %     Task name\n");
            sb.append("-----------------------------------------\n");
            NumberFormat nf = NumberFormat.getNumberInstance();
            nf.setMinimumIntegerDigits(5);
            nf.setGroupingUsed(false);
            NumberFormat pf = NumberFormat.getPercentInstance();
            pf.setMinimumIntegerDigits(3);
            pf.setGroupingUsed(false);
            for (int i = 0; i < tasks.length; ++i) {
                sb.append(nf.format(tasks[i].getTimeMillis()) + "  ");
                sb.append(pf.format(tasks[i].getTimeSeconds() / this.getTotalTimeSeconds()) + "  ");
                sb.append(tasks[i].getTaskName() + "\n");
            }
        }
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.shortSummary());
        if (this.keepTaskList) {
            TaskInfo[] tasks = this.getTaskInfo();
            for (int i = 0; i < tasks.length; ++i) {
                sb.append("; [" + tasks[i].getTaskName() + "] took " + tasks[i].getTimeMillis());
                long percent = Math.round(100.0 * tasks[i].getTimeSeconds() / this.getTotalTimeSeconds());
                sb.append(" = " + percent + "%");
            }
        } else {
            sb.append("; no task info kept");
        }
        return sb.toString();
    }

    public static class TaskInfo {
        private final String taskName;
        private final long timeMillis;

        private TaskInfo(String taskName, long timeMillis) {
            this.taskName = taskName;
            this.timeMillis = timeMillis;
        }

        public String getTaskName() {
            return this.taskName;
        }

        public long getTimeMillis() {
            return this.timeMillis;
        }

        public double getTimeSeconds() {
            return (double)this.timeMillis / 1000.0;
        }
    }
}

