/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.validation;

import com.bea.core.repackaged.springframework.beans.ConfigurablePropertyAccessor;
import com.bea.core.repackaged.springframework.beans.PropertyAccessorFactory;
import com.bea.core.repackaged.springframework.util.Assert;
import com.bea.core.repackaged.springframework.validation.AbstractPropertyBindingResult;

public class DirectFieldBindingResult
extends AbstractPropertyBindingResult {
    private final Object target;
    private transient ConfigurablePropertyAccessor directFieldAccessor;

    public DirectFieldBindingResult(Object target, String objectName) {
        super(objectName);
        Assert.notNull(target, "Target bean must not be null");
        this.target = target;
    }

    public final Object getTarget() {
        return this.target;
    }

    public final ConfigurablePropertyAccessor getPropertyAccessor() {
        if (this.directFieldAccessor == null) {
            this.directFieldAccessor = this.createDirectFieldAccessor();
            this.directFieldAccessor.setExtractOldValueForEditor(true);
        }
        return this.directFieldAccessor;
    }

    protected ConfigurablePropertyAccessor createDirectFieldAccessor() {
        return PropertyAccessorFactory.forDirectFieldAccess(this.getTarget());
    }
}

