/*
 * Decompiled with CFR 0.152.
 */
package common.secmgr;

import java.security.Permission;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;

public class ExecCheckingSecurityManager
extends SecurityManager {
    private final boolean throwException;
    private final List<String> cmds = new LinkedList<String>();

    public ExecCheckingSecurityManager() {
        this(true);
    }

    public ExecCheckingSecurityManager(boolean throwException) {
        this.throwException = throwException;
    }

    public List<String> getCmds() {
        return Collections.unmodifiableList(this.cmds);
    }

    @Override
    public void checkPermission(Permission perm) {
    }

    @Override
    public void checkPermission(Permission perm, Object context) {
    }

    @Override
    public void checkExec(String cmd) {
        super.checkExec(cmd);
        this.cmds.add(cmd);
        if (this.throwException) {
            throw new ExecException(cmd);
        }
    }

    public void callWrapped(final Runnable runnable) throws Exception {
        this.callWrapped(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                runnable.run();
                return null;
            }
        });
    }

    public <T> T callWrapped(Callable<T> callable) throws Exception {
        SecurityManager sm = System.getSecurityManager();
        System.setSecurityManager(this);
        try {
            T result = callable.call();
            if (this.throwException && !this.getCmds().isEmpty()) {
                throw new ExecException(this.getCmds().get(0));
            }
            T t = result;
            return t;
        }
        catch (Exception e) {
            if (!(e instanceof ExecException) && this.throwException && !this.getCmds().isEmpty()) {
                throw new ExecException(this.getCmds().get(0));
            }
            throw e;
        }
        finally {
            System.setSecurityManager(sm);
        }
    }

    public static class ExecException
    extends RuntimeException {
        private final String threadName = Thread.currentThread().getName();
        private final String cmd;

        public ExecException(String cmd) {
            this.cmd = cmd;
        }

        public String getCmd() {
            return this.cmd;
        }

        public String getThreadName() {
            return this.threadName;
        }

        @Override
        public String getMessage() {
            return "executed `" + this.getCmd() + "` in [" + this.getThreadName() + "]";
        }
    }
}

