/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.rest;

import com.tangosol.coherence.rest.CacheResource;
import com.tangosol.coherence.rest.KeyConverter;
import com.tangosol.coherence.rest.config.QueryConfig;
import com.tangosol.coherence.rest.config.ResourceConfig;
import com.tangosol.coherence.rest.config.RestConfig;
import com.tangosol.coherence.rest.server.InjectionBinder;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.NamedCache;
import com.tangosol.net.Session;
import com.tangosol.net.cache.TypeAssertion;
import javax.inject.Inject;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.glassfish.hk2.api.ServiceLocator;

@Path(value="/")
public class DefaultRootResource {
    @Inject
    protected Session m_session;
    @Inject
    protected RestConfig m_config;
    @Inject
    protected ServiceLocator m_serviceLocator;

    @Path(value="{name}")
    public CacheResource getCacheResource(@PathParam(value="name") String sName) {
        ResourceConfig configResource = this.m_config.getResources().get(sName);
        if (configResource == null) {
            throw new NotFoundException("There is no resource configured by that name.");
        }
        return this.instantiateCacheResourceInternal(configResource);
    }

    protected CacheResource instantiateCacheResourceInternal(ResourceConfig configResource) {
        try {
            NamedCache cache = this.m_session.getCache(configResource.getCacheName(), new NamedCache.Option[]{TypeAssertion.withoutTypeChecking()});
            return InjectionBinder.inject(this.instantiateCacheResource(cache, configResource.getKeyClass(), configResource.getValueClass(), configResource.getKeyConverter(), configResource.getQueryConfig(), configResource.getMaxResults()), this.m_serviceLocator);
        }
        catch (Exception e) {
            CacheFactory.log(e.getMessage(), 1);
            throw new NotFoundException(e.getMessage());
        }
    }

    protected CacheResource instantiateCacheResource(NamedCache cache, Class clzKey, Class clzValue, KeyConverter keyConverter, QueryConfig queryConfig, int cMaxResults) {
        return new CacheResource(cache, clzKey, clzValue, keyConverter, queryConfig, cMaxResults);
    }
}

