/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.rest.query;

import com.tangosol.coherence.rest.query.QueryEngine;
import com.tangosol.config.expression.Value;
import com.tangosol.util.Base;
import com.tangosol.util.UID;
import com.tangosol.util.UUID;
import com.tangosol.util.WrapperException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractQueryEngine
implements QueryEngine {
    protected final Map m_mapParsedQuery = new ConcurrentHashMap();
    private static final Pattern QUERY_PARAMS_PATTERN = Pattern.compile(":([a-zA-Z][a-zA-Z_0-9]*)(;([a-zA-Z][a-zA-Z_0-9\\.\\$]*))?");
    private static final Map<String, Class> s_mapTypeNames;

    protected ParsedQuery parseQueryString(String sQuery) {
        Map map = this.m_mapParsedQuery;
        Matcher matcher = QUERY_PARAMS_PATTERN.matcher(sQuery);
        String sFinal = matcher.replaceAll(":$1");
        ParsedQuery query = (ParsedQuery)map.get(sFinal);
        if (query == null) {
            matcher.reset();
            HashMap<String, Class> mapParamTypes = new HashMap<String, Class>();
            while (matcher.find()) {
                String sName = matcher.group(1);
                String sType = matcher.group(3);
                Class clzType = this.resolveParameterType(sType);
                mapParamTypes.put(sName, clzType);
            }
            query = new ParsedQuery(sFinal, mapParamTypes);
            map.put(sFinal, query);
        }
        return query;
    }

    protected Class resolveParameterType(String sType) {
        if (sType == null) {
            return String.class;
        }
        Class<?> clz = s_mapTypeNames.get(sType);
        if (clz == null) {
            try {
                clz = Base.getContextClassLoader(this).loadClass(sType);
            }
            catch (ClassNotFoundException e) {
                throw new WrapperException(e);
            }
        }
        return clz;
    }

    protected Map<String, Object> createBindings(Map<String, Object> mapParams, Map<String, Class> mapParamTypes) {
        HashMap<String, Object> mapBindings = new HashMap<String, Object>(mapParamTypes.size());
        for (Map.Entry<String, Class> entry : mapParamTypes.entrySet()) {
            String sParamName = entry.getKey();
            Class clzParamType = entry.getValue();
            Object oValue = mapParams.get(sParamName);
            oValue = oValue instanceof List ? this.convertList((List)oValue, clzParamType) : new Value((String)oValue).as(clzParamType);
            mapBindings.put(sParamName, oValue);
        }
        return mapBindings;
    }

    protected List convertList(List<String> listSource, Class clzElementType) {
        ArrayList listConverted = new ArrayList(listSource.size());
        for (String sValue : listSource) {
            listConverted.add(new Value(sValue).as(clzElementType));
        }
        return listConverted;
    }

    static {
        HashMap<String, Class> mapTypeNames = new HashMap<String, Class>();
        mapTypeNames.put("i", Integer.class);
        mapTypeNames.put("int", Integer.class);
        mapTypeNames.put("s", Short.class);
        mapTypeNames.put("short", Short.class);
        mapTypeNames.put("l", Long.class);
        mapTypeNames.put("long", Long.class);
        mapTypeNames.put("f", Float.class);
        mapTypeNames.put("float", Float.class);
        mapTypeNames.put("d", Double.class);
        mapTypeNames.put("double", Double.class);
        mapTypeNames.put("I", BigInteger.class);
        mapTypeNames.put("BigInteger", BigInteger.class);
        mapTypeNames.put("D", BigDecimal.class);
        mapTypeNames.put("BigDecimal", BigDecimal.class);
        mapTypeNames.put("date", Date.class);
        mapTypeNames.put("uuid", UUID.class);
        mapTypeNames.put("uid", UID.class);
        s_mapTypeNames = mapTypeNames;
    }

    protected static class ParsedQuery {
        private final String m_sQuery;
        private final Map<String, Class> m_mapParameterTypes;

        public ParsedQuery(String sQuery, Map<String, Class> mapParameterTypes) {
            this.m_sQuery = sQuery;
            this.m_mapParameterTypes = Collections.unmodifiableMap(mapParameterTypes);
        }

        public String getQuery() {
            return this.m_sQuery;
        }

        public Map<String, Class> getParameterTypes() {
            return this.m_mapParameterTypes;
        }
    }
}

