/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.rest.util;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofSerializer;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.util.LiteMap;
import com.tangosol.util.Versionable;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public class JsonMap
extends LiteMap<String, Object>
implements Versionable<Integer> {
    private static final long serialVersionUID = 336675295275632710L;

    public JsonMap() {
    }

    public JsonMap(Map<String, ?> map) {
        super(map);
    }

    @Override
    protected Map<String, Object> instantiateMap() {
        return new LinkedHashMap<String, Object>();
    }

    @Override
    @JsonAnySetter
    public Object put(String key, Object value) {
        return super.put(key, value);
    }

    @Override
    public Integer getVersionIndicator() {
        return (Integer)this.get("@version");
    }

    @Override
    public void incrementVersion() {
        this.computeIfPresent("@version", (k, v) -> (Integer)v + 1);
    }

    public static class Serializer
    implements PofSerializer<JsonMap> {
        @Override
        public void serialize(PofWriter out, JsonMap value) throws IOException {
            out.writeMap(0, value);
            out.writeRemainder(null);
        }

        @Override
        public JsonMap deserialize(PofReader in) throws IOException {
            try {
                JsonMap map = (JsonMap)in.getPofContext().getClass(in.getUserTypeId()).newInstance();
                in.readMap(0, map);
                in.readRemainder();
                return map;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    }
}

