/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.rest.util.processor;

import com.tangosol.coherence.rest.config.ProcessorConfig;
import com.tangosol.coherence.rest.util.processor.DefaultProcessorFactory;
import com.tangosol.coherence.rest.util.processor.NumberIncrementorFactory;
import com.tangosol.coherence.rest.util.processor.NumberMultiplierFactory;
import com.tangosol.coherence.rest.util.processor.ProcessorFactory;
import com.tangosol.util.Base;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.SafeHashMap;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ProcessorRegistry {
    public static final String PROCESSOR_REQUEST_REGEX = "\\s*(\\w(?:\\w|-)*)\\((.*)\\)";
    private static final Pattern PROCESSOR_REQUEST_PATTERN = Pattern.compile("^\\s*(\\w(?:\\w|-)*)\\((.*)\\)");
    private Map<String, ProcessorFactory> m_mapRegistry = new SafeHashMap<String, ProcessorFactory>();

    public ProcessorRegistry() {
        this.register("increment", new NumberIncrementorFactory(false));
        this.register("multiply", new NumberMultiplierFactory(false));
        this.register("post-increment", new NumberIncrementorFactory(true));
        this.register("post-multiply", new NumberMultiplierFactory(true));
    }

    public ProcessorRegistry(Collection<ProcessorConfig> colConfig) {
        this();
        this.register(colConfig);
    }

    public InvocableMap.EntryProcessor getProcessor(String sRequest) {
        Matcher m = PROCESSOR_REQUEST_PATTERN.matcher(sRequest);
        if (!m.matches()) {
            throw new IllegalArgumentException("bad processor request syntax: " + sRequest);
        }
        String sName = m.group(1);
        String sArgs = m.group(2);
        ProcessorFactory factory = this.m_mapRegistry.get(sName);
        if (factory == null) {
            throw new IllegalArgumentException("missing factory or processor: " + sName);
        }
        String[] asArgs = new String[]{};
        if (sArgs != null && sArgs.length() > 0) {
            asArgs = sArgs.split(",");
            int c = asArgs.length;
            for (int i = 0; i < c; ++i) {
                asArgs[i] = asArgs[i].trim();
            }
        }
        return factory.getProcessor(asArgs);
    }

    public void register(String sName, ProcessorFactory factory) {
        this.m_mapRegistry.put(sName, factory);
    }

    public void register(String sName, Class clz) {
        try {
            ProcessorFactory factory;
            if (ProcessorFactory.class.isAssignableFrom(clz)) {
                factory = (ProcessorFactory)clz.newInstance();
            } else if (InvocableMap.EntryProcessor.class.isAssignableFrom(clz)) {
                factory = new DefaultProcessorFactory(clz);
            } else {
                throw new IllegalArgumentException(clz.getName() + " is not an EntryProcessor or ProcessorFactory");
            }
            this.register(sName, factory);
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    public void register(Collection<ProcessorConfig> colConfig) {
        for (ProcessorConfig config : colConfig) {
            this.register(config.getProcessorName(), config.getProcessorClass());
        }
    }
}

