/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.servlet;

import com.oracle.common.base.Blocking;
import com.tangosol.coherence.servlet.AbstractHttpSessionModel;
import com.tangosol.coherence.servlet.AttributeHolder;
import com.tangosol.coherence.servlet.CacheDelegator;
import com.tangosol.coherence.servlet.CoherenceHttpSessionCollection;
import com.tangosol.coherence.servlet.ConfigurationImpl;
import com.tangosol.coherence.servlet.ExitAgent;
import com.tangosol.coherence.servlet.ExitObserver;
import com.tangosol.coherence.servlet.ExitTask;
import com.tangosol.coherence.servlet.HttpSessionCollection;
import com.tangosol.coherence.servlet.HttpSessionCollectionConfiguration;
import com.tangosol.coherence.servlet.HttpSessionIdGenerator;
import com.tangosol.coherence.servlet.HttpSessionModel;
import com.tangosol.coherence.servlet.LogThreadsHoldingLockAgent;
import com.tangosol.coherence.servlet.SessionExpiryFilterFactory;
import com.tangosol.coherence.servlet.SessionHelper;
import com.tangosol.coherence.servlet.SplitHttpSessionModel;
import com.tangosol.io.DefaultSerializer;
import com.tangosol.io.Serializer;
import com.tangosol.net.CacheService;
import com.tangosol.net.Cluster;
import com.tangosol.net.DistributedCacheService;
import com.tangosol.net.Invocable;
import com.tangosol.net.InvocationObserver;
import com.tangosol.net.InvocationService;
import com.tangosol.net.Member;
import com.tangosol.net.NamedCache;
import com.tangosol.net.RequestTimeoutException;
import com.tangosol.net.cache.WrapperNamedCache;
import com.tangosol.net.internal.LockHolderLookup;
import com.tangosol.net.internal.SessionExpiryExtractor;
import com.tangosol.run.component.EventDeathException;
import com.tangosol.run.xml.XmlConfigurable;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.ImmutableArrayList;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.IteratorEnumerator;
import com.tangosol.util.Listeners;
import com.tangosol.util.LiteMap;
import com.tangosol.util.SegmentedConcurrentMap;
import com.tangosol.util.SegmentedHashMap;
import com.tangosol.util.SegmentedHashSet;
import com.tangosol.util.SimpleEnumerator;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.WrapperException;
import com.tangosol.util.filter.LessFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;

public abstract class AbstractHttpSessionCollection
extends Base
implements CoherenceHttpSessionCollection {
    public static final String CTX_INIT_ENABLE_SESSION_ACCESS_DEBUG_LOGGING = "coherence-session-enable-debug-logging";
    public static final String CTX_INIT_SESSION_ACCESS_DEBUG_LOGGING_FILTER = "coherence-session-debug-logging-filter";
    public static final String CACHENAME_SESSIONS = "session-storage";
    public static final String CACHENAME_LOCAL_SESSIONS = "local-session-storage";
    public static final String CACHENAME_LOCAL_ATTRIBUTES = "local-attribute-storage";
    public static final String SERVICENAME_OWNERSHIP = "SessionOwnership";
    private static final Logger LOGGER = Logger.getLogger(AbstractHttpSessionCollection.class.getName());
    private XmlElement m_xmlConfig;
    private Listeners m_listenersLifecycle = new Listeners();
    private Listeners m_listenersAttributes = new Listeners();
    private Cluster m_cluster;
    private boolean m_fLocalTime;
    private NamedCache m_cacheStuckHere;
    private NamedCache m_cacheStickyExitTask;
    private NamedCache m_cacheAppControl;
    private InvocationService m_serviceOwnershipManagement;
    private NamedCache m_cacheActive = new WrapperNamedCache((Map)new SegmentedConcurrentMap(), "active-sessions");
    private NamedCache m_cacheOwned = new WrapperNamedCache((Map)new SegmentedConcurrentMap(), "owned-session-models");
    private NamedCache m_cacheCluster;
    private HttpSessionCollection.SessionDistributionController m_distcontroller;
    private HttpSessionCollection.AttributeScopeController m_scopecontroller;
    private NamedCache m_cacheLocal;
    private NamedCache m_cacheLocalAttributes;
    private HttpSessionIdGenerator m_sessionIdGenerator;
    private int m_cModelDeaths;
    private int m_cModelUpdates;
    private int m_cModelSeconds;
    private int m_cbModelMaxSize;
    private int m_cbModelMinSize = Integer.MAX_VALUE;
    private long m_cbModelTotalSize;
    private HttpSessionCollectionConfiguration m_configuration;
    private AbstractHttpSessionCollection m_collection;
    private List<SessionExpiryFilterFactory> m_expiryFilterFactories = new ArrayList<SessionExpiryFilterFactory>();
    private CacheDelegator m_cacheDelegator;
    private SessionHelper m_sessionHelper;
    private Serializer m_serializer;
    protected final ConcurrentHashMap<String, String> f_mapLocks = new ConcurrentHashMap();

    public AbstractHttpSessionCollection() {
        if (this.m_collection != null && LOGGER.isLoggable(Level.INFO)) {
            LOGGER.log(Level.INFO, "HttpSessionCollection instance of " + AbstractHttpSessionCollection.toString(this.m_collection.getClass()) + " is replaced by:" + AbstractHttpSessionCollection.toString(this.getClass()));
        }
        this.m_collection = this;
        this.m_serializer = new DefaultSerializer(this.getClass().getClassLoader());
    }

    protected AbstractHttpSessionCollection getCollection() {
        return this.m_collection;
    }

    public XmlElement getConfig() {
        return this.m_xmlConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configure(XmlElement xml, SessionHelper sessionHelper) {
        Object controller;
        Class<?> clz;
        Class<?> clz2;
        CacheService service;
        AbstractHttpSessionCollection.azzert((this.m_xmlConfig == null ? 1 : 0) != 0);
        AbstractHttpSessionCollection.azzert((xml != null ? 1 : 0) != 0);
        this.m_xmlConfig = xml;
        this.m_sessionHelper = sessionHelper;
        this.setConfiguration(new ConfigurationImpl.XmlElementBuilder(sessionHelper.getConfigurableCacheFactory()).setXmlElement(xml).build());
        this.m_cacheCluster = sessionHelper.getCache(this.m_configuration.getSessionCacheName());
        if (this.m_configuration.isAppLockingEnforced()) {
            CacheService cacheService = service = this.m_cacheCluster.getCacheService();
            synchronized (cacheService) {
                NamedCache cache = (NamedCache)service.getUserContext();
                if (cache == null) {
                    cache = new WrapperNamedCache((Map)new SegmentedConcurrentMap(), "application-control");
                    service.setUserContext((Object)cache);
                }
                this.m_cacheAppControl = cache;
            }
        }
        if (this.m_configuration.isOwnershipSticky()) {
            if (SessionHelper.s_collections == null) {
                SessionHelper.s_collections = new ArrayList();
            }
            SessionHelper.s_collections.add(this);
        }
        try {
            clz2 = Class.forName(this.m_configuration.getSessionIdGeneratorClassName());
            this.m_sessionIdGenerator = (HttpSessionIdGenerator)clz2.newInstance();
        }
        catch (Throwable e) {
            throw AbstractHttpSessionCollection.ensureRuntimeException((Throwable)e, (String)("Unable to instantiate the specified HttpSessionIdGenerator implementation: \"" + this.m_configuration.getSessionIdGeneratorClassName() + "\""));
        }
        try {
            clz2 = Class.forName(this.m_configuration.getCacheDelegatorClassName());
            this.m_cacheDelegator = (CacheDelegator)clz2.newInstance();
        }
        catch (Throwable e) {
            throw AbstractHttpSessionCollection.ensureRuntimeException((Throwable)e, (String)("Unable to instantiate the specified CacheDelegator implementation: \"" + this.m_configuration.getCacheDelegatorClassName() + "\""));
        }
        if (this.m_sessionIdGenerator instanceof XmlConfigurable) {
            ((XmlConfigurable)this.m_sessionIdGenerator).setConfig(xml);
        }
        if (this.m_configuration.isOwnershipSticky()) {
            try {
                service = sessionHelper.getInvocationService(this.m_configuration.getOwnershipServiceName());
                this.m_serviceOwnershipManagement = service;
            }
            catch (Throwable e) {
                throw AbstractHttpSessionCollection.ensureRuntimeException((Throwable)e, (String)("Error configuring InvocationService \"" + this.m_configuration.getOwnershipServiceName() + "\" for sticky session optimization"));
            }
            if (!this.m_configuration.isMemberLockingEnforced()) {
                AbstractHttpSessionCollection.azzertFailed((String)"Configurator should not allow this state");
            }
            CacheService e = service;
            synchronized (e) {
                NamedCache[] acache = (NamedCache[])service.getUserContext();
                if (acache == null) {
                    this.m_cacheStuckHere = new WrapperNamedCache((Map)new SegmentedConcurrentMap(), "stuck-session-models");
                    this.m_cacheStickyExitTask = new WrapperNamedCache((Map)new SegmentedConcurrentMap(), "stuck-session-exit-tasks");
                    service.setUserContext((Object)new NamedCache[]{this.m_cacheStuckHere, this.m_cacheStickyExitTask});
                } else {
                    this.m_cacheStuckHere = acache[0];
                    this.m_cacheStickyExitTask = acache[1];
                }
            }
        }
        if (this.m_configuration.getDistControllerClassName().length() > 0) {
            this.m_cacheLocal = sessionHelper.getCache(this.getLocalCacheName());
            try {
                clz = Class.forName(this.m_configuration.getDistControllerClassName());
                controller = (HttpSessionCollection.SessionDistributionController)clz.newInstance();
                controller.init(this);
            }
            catch (Throwable e) {
                throw AbstractHttpSessionCollection.ensureRuntimeException((Throwable)e, (String)("Unable to instantiate and configure the specified SessionDistributionController implementation: \"" + this.m_configuration.getDistControllerClassName() + "\""));
            }
            this.m_distcontroller = controller;
        }
        if (this.m_configuration.getScopeControllerClassName().length() > 0) {
            try {
                clz = Class.forName(this.m_configuration.getScopeControllerClassName());
                controller = (HttpSessionCollection.AttributeScopeController)clz.newInstance();
                controller.init(this.m_configuration.getApplicationName());
            }
            catch (Throwable e) {
                throw AbstractHttpSessionCollection.ensureRuntimeException((Throwable)e, (String)("Unable to instantiate and configure the specified AttributeScopeController implementation: \"" + this.m_configuration.getScopeControllerClassName() + "\""));
            }
            this.m_scopecontroller = controller;
        }
        if (this.m_configuration.isAllowLocalAttributes()) {
            this.m_cacheLocalAttributes = sessionHelper.getCache(this.m_configuration.getLocalAttributesCacheName());
        }
        if (LOGGER.isLoggable(Level.INFO)) {
            StringBuilder sb = new StringBuilder();
            sb.append("Configured session model \"").append(ClassHelper.getSimpleName(this.getClass())).append("\":").append(this.m_configuration.toString());
            LOGGER.log(Level.INFO, sb.toString());
        }
        this.m_expiryFilterFactories.add(new BaseSessionExpiryFilterFactory());
        if (this.m_configuration.getSessionExpiryFilterFactoryClassName().trim().length() > 0) {
            try {
                clz2 = Class.forName(this.m_configuration.getSessionExpiryFilterFactoryClassName());
                this.m_expiryFilterFactories.add((SessionExpiryFilterFactory)clz2.newInstance());
            }
            catch (Throwable e) {
                throw AbstractHttpSessionCollection.ensureRuntimeException((Throwable)e, (String)("Unable to instantiate the specified SessionExpiryFilterFactory implementation: \"" + this.m_configuration.getSessionExpiryFilterFactoryClassName() + "\""));
            }
        }
    }

    @Override
    public HttpSessionModel create(HttpSession session) {
        AbstractHttpSessionModel model = null;
        while ((model = this.create(session, this.generateSessionId())) == null) {
        }
        return model;
    }

    @Override
    public void postCreate(HttpSession session) {
        Listeners listeners = this.getHttpSessionListeners();
        if (!listeners.isEmpty()) {
            EventListener[] ael = listeners.listeners();
            HttpSessionEvent evt = new HttpSessionEvent(session);
            int c = ael.length;
            for (int i = 0; i < c; ++i) {
                try {
                    ((HttpSessionListener)ael[i]).sessionCreated(evt);
                    continue;
                }
                catch (EventDeathException e) {
                    break;
                }
                catch (RuntimeException e) {
                    boolean fStrict = this.isStrict();
                    SessionHelper.logEventException(e, "sessionCreated(" + session.getId() + ')', !fStrict);
                    if (!fStrict) continue;
                    throw e;
                }
            }
        }
    }

    @Override
    public boolean isExistent(String sId) {
        if (sId == null) {
            return false;
        }
        if (this.getOwnedCache().containsKey((Object)sId)) {
            return true;
        }
        NamedCache cache = this.getLocalCache();
        if (cache != null && cache.containsKey((Object)sId)) {
            return true;
        }
        return this.getCacheDelegator().containsKey(sId, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy(String sId) {
        block19: {
            NamedCache cacheOwned = this.getOwnedCache();
            NamedCache cacheLocal = this.getLocalCache();
            boolean fSuccess = false;
            boolean fLocked = this.obtainThreadOwnership(sId);
            if (fLocked) {
                this.recordMapLocksState("destroy()->obtainThreadOwnership():" + sId, "locked");
            }
            try {
                AbstractHttpSessionModel model = (AbstractHttpSessionModel)cacheOwned.get((Object)sId);
                if (model != null && model.isOwnedByThisThread()) {
                    if (model.isActive()) {
                        this.getCacheDelegator().deleteModel(this, model);
                        fSuccess = true;
                        if (LOGGER.isLoggable(Level.FINEST)) {
                            LOGGER.log(Level.FINEST, "Destroying HttpSession \"" + sId + '\"');
                        }
                        try {
                            this.fireSessionDestroyedListeners(sId, model);
                            break block19;
                        }
                        finally {
                            try {
                                model.unbind();
                            }
                            finally {
                                this.deleteModelFromLocalCaches(sId);
                                this.updateSessionStatitics(sId, model);
                                model.discard();
                            }
                        }
                    }
                    throw new IllegalStateException("attempt to destroy session " + sId + " when it was not active");
                }
                if (model != null || cacheLocal != null && cacheLocal.containsKey((Object)sId) || this.getCacheDelegator().containsKey(sId, this)) {
                    throw new IllegalStateException("attempt to destroy session " + sId + " when it was not owned");
                }
            }
            finally {
                if (fSuccess) {
                    this.releaseClusterOwnership(sId);
                    this.releaseAppOwnership(sId);
                    this.releaseThreadOwnership(sId);
                    this.removeMapLocksState("destroy()->obtainThreadOwnership():" + sId);
                } else if (fLocked) {
                    this.releaseThreadOwnership(sId);
                    this.removeMapLocksState("destroy()->obtainThreadOwnership():" + sId);
                }
            }
        }
    }

    protected void fireSessionDestroyedListeners(String sId, AbstractHttpSessionModel model) {
        Listeners listeners = this.getHttpSessionListeners();
        if (!listeners.isEmpty()) {
            EventListener[] ael = listeners.listeners();
            HttpSessionEvent evt = new HttpSessionEvent(model.getHttpSession());
            for (int i = ael.length - 1; i >= 0; --i) {
                try {
                    ((HttpSessionListener)ael[i]).sessionDestroyed(evt);
                    continue;
                }
                catch (EventDeathException e) {
                    SessionHelper.logEventException((RuntimeException)((Object)e), "sessionDestroyed(" + sId + ')', !this.isStrict());
                    break;
                }
                catch (RuntimeException e) {
                    if (this.logInvalidationExceptions()) {
                        SessionHelper.logEventException(e, "sessionDestroyed(" + sId + ')', !this.isStrict());
                    }
                    SessionHelper.logEventException(e, "sessionDestroyed(" + sId + ')', !this.isStrict());
                    if (!this.isStrict()) continue;
                    throw e;
                }
            }
        }
    }

    protected void deleteModelFromLocalCaches(String sId) {
        NamedCache cacheOwned = this.getOwnedCache();
        NamedCache cacheLocal = this.getLocalCache();
        NamedCache cacheActive = this.getActiveCache();
        AbstractHttpSessionCollection.removeBlind((Map)cacheOwned, sId);
        AbstractHttpSessionCollection.removeBlind((Map)cacheLocal, sId);
        AbstractHttpSessionCollection.removeBlind((Map)cacheActive, sId);
        this.destroyLocalAttributesCache(sId);
    }

    protected void updateSessionStatitics(String sId, AbstractHttpSessionModel model) {
        long cCreationMillis = model.getCreationTime();
        long cDeathMillis = this.getCurrentTime();
        this.m_cModelSeconds += (int)((cDeathMillis - cCreationMillis) / 1000L);
        ++this.m_cModelDeaths;
    }

    @Override
    public boolean enter(String sId, boolean fWait) {
        return this.enter(sId, fWait, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean enter(String sId, boolean fWait, boolean fExclusive) {
        boolean fSuccess = false;
        NamedCache cacheOwned = this.getOwnedCache();
        boolean fAlreadyOwned = false;
        if (!cacheOwned.lock((Object)sId, fWait ? -1L : 0L)) return fSuccess;
        this.recordMapLocksState("enter():" + sId, "Locked");
        try {
            AbstractHttpSessionModel model;
            block17: {
                model = (AbstractHttpSessionModel)cacheOwned.get((Object)sId);
                if (model == null) {
                    if (this.obtainAppOwnership(sId, fWait)) {
                        try {
                            if (!this.obtainClusterOwnership(sId, fWait)) break block17;
                            try {
                                model = this.getModel(sId);
                                if (model != null) {
                                    model.setCollection(this);
                                    model.enter();
                                    cacheOwned.put((Object)sId, (Object)model);
                                    if (this.m_configuration.logThreadsHoldingLock() && !this.isThreadLockingEnforced()) {
                                        model.addEnteredThread();
                                    }
                                    fSuccess = true;
                                }
                            }
                            finally {
                                if (!fSuccess) {
                                    this.releaseClusterOwnership(sId);
                                }
                            }
                        }
                        finally {
                            if (!fSuccess) {
                                this.releaseAppOwnership(sId);
                            }
                        }
                    }
                } else {
                    fAlreadyOwned = model.isOwnedByThisThread() || !this.isThreadLockingEnforced();
                    model.enter();
                    fSuccess = true;
                }
            }
            if (model == null) return fSuccess;
            this.recordMapLocksState("Collection->model.entered(): " + sId, "refCount: " + model.getReferenceCount());
            return fSuccess;
        }
        finally {
            if (!fSuccess || fSuccess && !fExclusive && (fAlreadyOwned || !this.isThreadLockingEnforced())) {
                cacheOwned.unlock((Object)sId);
                this.removeMapLocksState("enter():" + sId);
            }
        }
    }

    @Override
    public boolean isOwned(String sId) {
        AbstractHttpSessionModel model = (AbstractHttpSessionModel)this.getOwnedCache().get((Object)sId);
        return model != null && model.isOwnedByThisThread();
    }

    @Override
    public void exit(String sId, boolean fFlush) {
        this.exit(sId, fFlush, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exit(String sId, boolean fFlush, boolean fExclusive) {
        NamedCache cacheOwned = this.getOwnedCache();
        NamedCache cacheLocal = this.getLocalCache();
        boolean fSuccess = false;
        boolean fLocked = fExclusive || this.obtainThreadOwnership(sId);
        Throwable eFlush = null;
        try {
            AbstractHttpSessionModel model = (AbstractHttpSessionModel)cacheOwned.get((Object)sId);
            if (!fExclusive && fLocked) {
                this.recordMapLocksState("exit()->obtainThreadOwnership():" + sId, "locked, refCount=" + (model == null ? "null" : String.valueOf(model.getReferenceCount())));
            }
            int cRefsPrev = model == null ? Integer.MIN_VALUE : model.getReferenceCount();
            int cRefs = Integer.MIN_VALUE;
            if (model != null && cRefsPrev > 0) {
                if (fFlush) {
                    try {
                        this.getCacheDelegator().flush(this, model);
                    }
                    catch (Throwable e) {
                        eFlush = e;
                    }
                }
                model.exit();
                cRefs = model.getReferenceCount();
                if (cRefs == 0) {
                    if (!model.isLocal()) {
                        cacheOwned.remove((Object)sId);
                        this.removeMapLocksState("Collection->model.entered(): " + sId);
                        if (model.isModified() && LOGGER.isLoggable(Level.FINEST)) {
                            LOGGER.log(Level.FINEST, "HttpSession " + sId + " was exited (released by this JVM) but it had uncommitted changes");
                        }
                        model.setCollection(null);
                        if (this.m_configuration.logThreadsHoldingLock() && !this.isThreadLockingEnforced()) {
                            model.removeEnteredThread();
                        }
                        if (!this.isStuck(sId)) {
                            this.releaseClusterOwnership(sId);
                        }
                        this.releaseAppOwnership(sId);
                    }
                    this.releaseThreadOwnership(sId);
                    this.removeMapLocksState("exit()->obtainThreadOwnership():" + sId);
                    fSuccess = true;
                }
            } else if (model != null || cacheLocal != null && cacheLocal.containsKey((Object)sId) || this.getCacheDelegator().containsKey(sId, this)) {
                throw new IllegalStateException("attempt to exit session " + sId + " when it was not owned");
            }
            if (model != null && cRefs > 0) {
                this.removeMapLocksState("Collection->model.entered(): " + sId);
            }
        }
        finally {
            if (!fSuccess && fLocked) {
                this.releaseThreadOwnership(sId);
                this.removeMapLocksState("exit()->obtainThreadOwnership():" + sId);
            }
        }
        if (eFlush != null) {
            throw AbstractHttpSessionCollection.ensureRuntimeException((Throwable)eFlush);
        }
    }

    protected void remapSessionId(AbstractHttpSessionModel model) {
        String sOldId = model.getId();
        String sNewId = model.getNewId();
        if (model instanceof SplitHttpSessionModel) {
            ((SplitHttpSessionModel)model).remapExternalAttributes(sNewId);
        }
        this.getCacheDelegator().deleteModel(this, model);
        this.deleteModelFromLocalCaches(sOldId);
        model.setId(sNewId);
        this.getCacheDelegator().putModel(model);
        this.m_sessionHelper.ensureHttpSession(sNewId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void activate(String sId, HttpSession session) {
        boolean fLocked = this.obtainThreadOwnership(sId);
        if (fLocked) {
            this.recordMapLocksState("activate()->obtainThreadOwnership():" + sId, "locked");
        }
        try {
            this.getOwnedModel(sId).activate(session);
        }
        finally {
            if (fLocked) {
                this.releaseThreadOwnership(sId);
                this.removeMapLocksState("activate()->obtainThreadOwnership():" + sId);
            }
        }
    }

    public boolean logInvalidationExceptions() {
        return this.m_configuration.isLogInvalidationExceptions();
    }

    @Override
    public boolean isActive(String sId) {
        return this.getOwnedModel(sId).isActive();
    }

    @Override
    public void passivate(String sId) {
        boolean fLocked = this.obtainThreadOwnership(sId);
        if (fLocked) {
            this.recordMapLocksState("passivate()->obtainThreadOwnership():" + sId, "locked");
        }
        try {
            this.getOwnedModel(sId).passivate();
        }
        finally {
            if (fLocked) {
                this.releaseThreadOwnership(sId);
                this.removeMapLocksState("passivate()->obtainThreadOwnership():" + sId);
            }
        }
    }

    @Override
    public Set<String> deleteExpiredSessions() {
        Set<String> setDeletedIds = this.getCacheDelegator().deleteExpiredSessions(this);
        this.cleanUpDeletedSessions(setDeletedIds);
        return setDeletedIds;
    }

    @Override
    public Set<String> deleteExpiredLocalSessions() {
        Set<String> setDeletedIds = this.getCacheDelegator().deleteExpiredLocalSessions(this);
        this.cleanUpDeletedSessions(setDeletedIds);
        return setDeletedIds;
    }

    protected void cleanUpDeletedSessions(Set<String> setDeletedIds) {
        if (setDeletedIds == null) {
            return;
        }
        for (String sessionId : setDeletedIds) {
            this.m_sessionHelper.cleanUpSession(sessionId);
        }
    }

    @Override
    public Iterator iterateIds() {
        NamedCache cacheLocal = this.getLocalCache();
        NamedCache cacheCluster = this.getClusterCache();
        if (cacheLocal == null || cacheLocal.isEmpty()) {
            return new SimpleEnumerator(cacheCluster.keySet().toArray());
        }
        HashSet setIds = new HashSet();
        setIds.addAll(cacheLocal.keySet());
        setIds.addAll(cacheCluster.keySet());
        return new IteratorEnumerator(setIds.iterator());
    }

    @Override
    public Iterator iteratePotentiallyExpiredIds() {
        return this.getCacheDelegator().getIteratorForPotentiallyExpiredIds(this);
    }

    @Override
    public Iterator iteratePotentiallyExpiredLocalIds() {
        return this.getCacheDelegator().getIteratorForPotentiallyExpiredLocalIds(this);
    }

    protected Filter getSessionExpiryFilter() {
        Filter filter = null;
        for (SessionExpiryFilterFactory f : this.m_expiryFilterFactories) {
            filter = f.createSessionExpiryFilter(filter);
        }
        return filter;
    }

    List<SessionExpiryFilterFactory> getExpiryFilterFactories() {
        return this.m_expiryFilterFactories;
    }

    @Override
    public HttpSessionModel get(String sId) {
        AbstractHttpSessionModel model = (AbstractHttpSessionModel)this.getOwnedCache().get((Object)sId);
        if (model != null && !model.isOwnedByThisThread()) {
            throw new IllegalStateException("attempt to get session " + sId + " when it was not owned");
        }
        return model;
    }

    public Set<String> getLocalSessionIds() {
        return this.m_sessionHelper.getHttpSessionMap().keySet();
    }

    public Set<String> getLocalSessonIdsSnapshot() {
        return new ImmutableArrayList(this.m_sessionHelper.getHttpSessionMap().keySet()).getSet();
    }

    @Override
    public void addHttpSessionListener(HttpSessionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("HttpSessionListener cannot be null");
        }
        if (!this.getHttpSessionListeners().contains((EventListener)listener)) {
            this.getHttpSessionListeners().add((EventListener)listener);
        }
    }

    @Override
    public void removeHttpSessionListener(HttpSessionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("HttpSessionListener cannot be null");
        }
        this.getHttpSessionListeners().remove((EventListener)listener);
    }

    @Override
    public void addHttpSessionAttributeListener(HttpSessionAttributeListener listener) {
        this.getHttpSessionAttributeListeners().add((EventListener)listener);
    }

    @Override
    public void removeHttpSessionAttributeListener(HttpSessionAttributeListener listener) {
        this.getHttpSessionAttributeListeners().remove((EventListener)listener);
    }

    @Override
    public void shutdown() {
        NamedCache cacheSticky = this.getStickyCache();
        if (cacheSticky != null && !cacheSticky.isEmpty()) {
            SimpleEnumerator iter = new SimpleEnumerator(cacheSticky.keySet().toArray());
            while (iter.hasNext()) {
                String sId = (String)iter.next();
                try {
                    this.releaseStuckSession(sId, true);
                }
                catch (Exception exception) {}
            }
        }
        this.releaseCache(this.getClusterCache());
        this.releaseCache(this.getLocalCache());
        this.releaseCache(this.getLocalAttributesCache());
        this.releaseCache(this.getOwnedCache());
        this.releaseCache(this.getActiveCache());
        if (this.m_configuration.isOwnershipSticky() && SessionHelper.s_collections != null) {
            SessionHelper.s_collections.remove(this);
        }
    }

    public String toString() {
        return "AbstractHttpSessionCollection\n" + AbstractHttpSessionCollection.indentString((String)this.getDescription(), (String)"  ");
    }

    protected Listeners getHttpSessionListeners() {
        return this.m_listenersLifecycle;
    }

    protected Listeners getHttpSessionAttributeListeners() {
        return this.m_listenersAttributes;
    }

    protected HttpSessionCollectionConfiguration getHttpSessionCollectionConfiguration() {
        return this.m_configuration;
    }

    public boolean isStrict() {
        return this.m_configuration.isStrict();
    }

    public int getDefaultMaxInactiveInterval() {
        return this.m_configuration.getMaxInactiveSeconds();
    }

    protected boolean isSessionLockingEnforced() {
        return this.m_configuration.isSessionLockingEnforced();
    }

    protected boolean isMemberLockingEnforced() {
        return this.m_configuration.isMemberLockingEnforced();
    }

    protected boolean isAppLockingEnforced() {
        return this.m_configuration.isAppLockingEnforced();
    }

    protected boolean isThreadLockingEnforced() {
        return this.m_configuration.isThreadLockingEnforced();
    }

    protected long getCurrentTime() {
        if (this.m_fLocalTime) {
            return System.currentTimeMillis();
        }
        Cluster cluster = this.m_cluster;
        if (cluster == null) {
            CacheService service = this.getClusterCache().getCacheService();
            if ("RemoteCache".equals(service.getInfo().getServiceType())) {
                this.m_fLocalTime = true;
                return System.currentTimeMillis();
            }
            this.m_cluster = cluster = service.getCluster();
        }
        return cluster.getTimeMillis();
    }

    protected boolean isEnabledSessionAccessDebugLogging() {
        return this.m_configuration.isEnableSessionAccessDebugLogging();
    }

    protected String getSessionAccessDebugLoggingFilter() {
        return this.m_configuration.getSessionAccessDebugLoggingFilter();
    }

    @Override
    public Serializer getSerializer() {
        return this.m_serializer;
    }

    @Override
    public void setSerializer(Serializer serializer) {
        if (serializer == null) {
            throw new IllegalArgumentException();
        }
        this.m_serializer = serializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbstractHttpSessionModel create(HttpSession session, String sId) {
        NamedCache cacheOwned = this.getOwnedCache();
        AbstractHttpSessionModel model = null;
        boolean fLockedOwned = false;
        boolean fLockedApp = false;
        boolean fLockedCluster = false;
        try {
            try {
                fLockedOwned = cacheOwned.lock((Object)sId);
                if (fLockedOwned) {
                    this.recordMapLocksState("create():" + sId, "locked");
                    fLockedApp = this.obtainAppOwnership(sId, false);
                    if (fLockedApp && (fLockedCluster = this.obtainClusterOwnership(sId, false))) {
                        model = this.instantiateModel(session, sId);
                        model.enter();
                        cacheOwned.put((Object)sId, (Object)model);
                        if (this.m_configuration.logThreadsHoldingLock() && !this.isThreadLockingEnforced()) {
                            model.addEnteredThread();
                        }
                        if (LOGGER.isLoggable(Level.FINEST)) {
                            LOGGER.log(Level.FINEST, "Created session model \"" + model + '\"');
                        }
                        if (!this.isThreadLockingEnforced()) {
                            cacheOwned.unlock((Object)sId);
                            this.removeMapLocksState("create():" + sId);
                            fLockedOwned = false;
                        }
                    }
                }
            }
            finally {
                if (model == null) {
                    if (fLockedCluster) {
                        this.releaseClusterOwnership(sId);
                        fLockedCluster = false;
                    }
                    if (fLockedApp) {
                        this.releaseAppOwnership(sId);
                        fLockedApp = false;
                    }
                    if (fLockedOwned) {
                        cacheOwned.unlock((Object)sId);
                        this.removeMapLocksState("create():" + sId);
                        fLockedOwned = false;
                    }
                }
            }
        }
        catch (Throwable e) {
            if (fLockedCluster) {
                this.releaseClusterOwnership(sId);
            }
            if (fLockedApp) {
                this.releaseAppOwnership(sId);
            }
            if (fLockedOwned) {
                cacheOwned.unlock((Object)sId);
                this.removeMapLocksState("create():" + sId);
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            throw AbstractHttpSessionCollection.ensureRuntimeException((Throwable)e);
        }
        return model;
    }

    protected String getDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("Config=").append(AbstractHttpSessionCollection.indentString((String)String.valueOf(this.getConfig()), (String)"  ", (boolean)false)).append("\nHttpSessionListeners[]=").append(AbstractHttpSessionCollection.indentString((String)SessionHelper.formatListeners(this.getHttpSessionListeners()), (String)"  ", (boolean)false)).append("\nHttpSessionAttributeListeners[]=").append(AbstractHttpSessionCollection.indentString((String)SessionHelper.formatListeners(this.getHttpSessionAttributeListeners()), (String)"  ", (boolean)false)).append("\nCluster=").append(AbstractHttpSessionCollection.indentString((String)String.valueOf(this.m_cluster), (String)"  ", (boolean)false)).append("\nOwnedCache(").append(SessionHelper.formatCacheName(this.getOwnedCache())).append(").keySet=").append(AbstractHttpSessionCollection.indentString((String)SessionHelper.formatMapKeys(this.getOwnedCache()), (String)"  ", (boolean)false)).append("\nClusterCache(").append(SessionHelper.formatCacheName(this.getClusterCache())).append(").keySet=").append(AbstractHttpSessionCollection.indentString((String)SessionHelper.formatMapKeys(this.getClusterCache()), (String)"  ", (boolean)false)).append("\nDistributionController=").append(AbstractHttpSessionCollection.indentString((String)String.valueOf(this.getDistributionController()), (String)"  ", (boolean)false)).append("\nLocalCache(").append(SessionHelper.formatCacheName(this.getLocalCache())).append(").keySet=").append(AbstractHttpSessionCollection.indentString((String)SessionHelper.formatMapKeys(this.getLocalCache()), (String)"  ", (boolean)false)).append("\nLocalAttributesCache(").append(SessionHelper.formatCacheName(this.getLocalAttributesCache())).append(").keySet=").append(AbstractHttpSessionCollection.indentString((String)SessionHelper.formatMapKeys(this.getLocalAttributesCache()), (String)"  ", (boolean)false)).append("\nDefaultMaxInactiveInterval=").append(this.getDefaultMaxInactiveInterval()).append("\nSessionIdLength=").append(this.getSessionIdLength()).append("\nMemberLockingEnforced=").append(this.isMemberLockingEnforced()).append("\nAppLockingEnforced=").append(this.isAppLockingEnforced()).append("\nThreadLockingEnforced=").append(this.isThreadLockingEnforced()).append("\nStrict=").append(this.isStrict());
        return sb.toString();
    }

    public NamedCache getStickyCache() {
        return this.m_cacheStuckHere;
    }

    public NamedCache getStickyExitTaskCache() {
        return this.m_cacheStickyExitTask;
    }

    protected InvocationService getStickyService() {
        return this.m_serviceOwnershipManagement;
    }

    protected NamedCache getAppControlCache() {
        return this.m_cacheAppControl;
    }

    protected NamedCache getActiveCache() {
        return this.m_cacheActive;
    }

    protected NamedCache getOwnedCache() {
        return this.m_cacheOwned;
    }

    public NamedCache getClusterCache() {
        return this.m_cacheCluster;
    }

    void setClusterCache(NamedCache cache) {
        this.m_cacheCluster = cache;
    }

    protected CacheDelegator getCacheDelegator() {
        return this.m_cacheDelegator;
    }

    protected void setCacheDelegator(CacheDelegator cacheDelegator) {
        this.m_cacheDelegator = cacheDelegator;
    }

    protected void setConfiguration(HttpSessionCollectionConfiguration config) {
        this.m_configuration = config;
    }

    protected HttpSessionCollection.SessionDistributionController getDistributionController() {
        return this.m_distcontroller;
    }

    protected HttpSessionCollection.AttributeScopeController getScopeController() {
        return this.m_scopecontroller;
    }

    public String getLocalCacheName() {
        return this.m_configuration.getLocalSessionCacheName();
    }

    public NamedCache getLocalCache() {
        return this.m_cacheLocal;
    }

    public NamedCache getLocalAttributesCache() {
        return this.m_cacheLocalAttributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map ensureLocalAttributesCache(String sId) {
        NamedCache cacheBySession = this.getLocalAttributesCache();
        if (cacheBySession == null) {
            throw new IllegalStateException("request made for a local attributes cache when local attributes caches are not available");
        }
        Map cacheAttributes = (Map)cacheBySession.get((Object)sId);
        if (cacheAttributes == null) {
            NamedCache namedCache = cacheBySession;
            synchronized (namedCache) {
                cacheAttributes = (Map)cacheBySession.get((Object)sId);
                if (cacheAttributes == null) {
                    cacheAttributes = new SegmentedHashMap();
                    cacheBySession.put((Object)sId, (Object)cacheAttributes);
                }
            }
        }
        return cacheAttributes;
    }

    protected void destroyLocalAttributesCache(String sId) {
        NamedCache cacheBySession = this.getLocalAttributesCache();
        if (cacheBySession != null) {
            cacheBySession.remove((Object)sId);
        }
    }

    public boolean isOwnershipSticky() {
        return this.m_configuration.isOwnershipSticky();
    }

    protected boolean isStuck(String sId) {
        Boolean booleanStuck;
        boolean fStuck = false;
        if (this.isOwnershipSticky() && (booleanStuck = (Boolean)this.getStickyCache().get((Object)sId)) != null && booleanStuck.booleanValue()) {
            fStuck = true;
        }
        return fStuck;
    }

    protected Member getSessionOwnershipInfo(String sId) {
        try {
            Integer IOwnerId = (Integer)this.getClusterCache().aggregate(Collections.singleton(sId), (InvocableMap.EntryAggregator)new LockHolderLookup());
            Member member = IOwnerId == null ? null : this.getClusterCache().getCacheService().getInfo().getServiceMember(IOwnerId.intValue());
            return member;
        }
        catch (Exception e) {
            StringBuilder sb = new StringBuilder("Failed to obtain cluster ownership for the session with id=").append(sId).append(". ");
            if (e instanceof RequestTimeoutException) {
                sb.append("Timed out requesting lock holder from ").append(((DistributedCacheService)this.getClusterCache().getCacheService()).getKeyOwner((Object)sId));
            } else {
                sb.append("Could not identify lock holder due to ").append(e);
            }
            throw new RequestTimeoutException(sb.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean obtainClusterOwnership(String sId, boolean fWait) {
        boolean fLocked;
        boolean fSticky = this.isOwnershipSticky();
        if (!this.isMemberLockingEnforced()) {
            fLocked = true;
        } else if (fSticky && this.getStickyCache().containsKey((Object)sId)) {
            fLocked = true;
        } else if (fSticky) {
            int cTries = 0;
            while (true) {
                ++cTries;
                fLocked = this.getClusterCache().lock((Object)sId, 0L);
                if (fLocked || !fWait) break;
                InvocationService service = this.getStickyService();
                ExitAgent task = new ExitAgent(sId);
                ExitObserver observer = new ExitObserver();
                Set setMembers = service.getInfo().getServiceMembers();
                setMembers.remove(service.getCluster().getLocalMember());
                ExitObserver exitObserver = observer;
                synchronized (exitObserver) {
                    service.execute((Invocable)task, setMembers, (InvocationObserver)observer);
                    try {
                        while (!observer.isDone()) {
                            Blocking.wait((Object)observer);
                        }
                        if (cTries > 1) {
                            if (cTries > this.m_configuration.getLockTimeout()) {
                                Member lockHolder = this.getSessionOwnershipInfo(sId);
                                this.failObtainClusterLock(sId, lockHolder);
                            }
                            Blocking.sleep((long)Math.min(1000, cTries * 100));
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new WrapperException((Throwable)e);
                    }
                }
            }
            if (fLocked) {
                InvocationService invocationService = this.getStickyService();
                synchronized (invocationService) {
                    this.getStickyCache().put((Object)sId, (Object)Boolean.TRUE);
                    this.getStickyExitTaskCache().put((Object)sId, (Object)new ExitTask(sId, this));
                }
            }
        } else {
            fLocked = this.getClusterCache().lock((Object)sId, fWait ? (long)this.m_configuration.getLockTimeout() * 1000L : 0L);
            if (fWait && !fLocked) {
                Member lockHolder = this.getSessionOwnershipInfo(sId);
                this.failObtainClusterLock(sId, lockHolder);
            }
        }
        return fLocked;
    }

    private void failObtainClusterLock(String sId, Member lockHolder) {
        InvocationService service = this.getStickyService();
        if (service != null && this.m_configuration.logThreadsHoldingLock()) {
            LogThreadsHoldingLockAgent task = new LogThreadsHoldingLockAgent(sId);
            HashSet<Member> setMembers = new HashSet<Member>(1);
            setMembers.add(lockHolder);
            service.execute((Invocable)task, setMembers, null);
        }
        String sLockHolder = lockHolder == null ? "Unknown" : lockHolder.toString();
        throw new RequestTimeoutException("Failed to obtain cluster ownership  for the session with id=" + sId + " from: " + sLockHolder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseClusterOwnership(String sId) {
        if (this.isMemberLockingEnforced()) {
            if (this.isOwnershipSticky()) {
                InvocationService invocationService = this.getStickyService();
                synchronized (invocationService) {
                    this.getStickyCache().remove((Object)sId);
                    this.getStickyExitTaskCache().remove((Object)sId);
                }
                this.destroyLocalAttributesCache(sId);
            }
            this.getClusterCache().unlock((Object)sId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean releaseStuckSession(String sId, boolean fWait) {
        boolean fStuckHere = false;
        NamedCache cacheOwned = this.getOwnedCache();
        if (!cacheOwned.lock((Object)sId, fWait ? -1L : 0L)) return true;
        try {
            this.recordMapLocksState("releaseStuckSession():" + sId, "locked");
            InvocationService invocationService = this.getStickyService();
            synchronized (invocationService) {
                NamedCache cache = this.getStickyCache();
                Boolean booleanStuck = (Boolean)cache.get((Object)sId);
                if (booleanStuck != null) {
                    fStuckHere = true;
                    if (booleanStuck.booleanValue()) {
                        cache.put((Object)sId, (Object)Boolean.FALSE);
                    }
                }
            }
            if (!fStuckHere) return fStuckHere;
            if (this.isOwned(sId)) return fStuckHere;
            if (!this.enter(sId, false)) return fStuckHere;
            try {
                if (!this.getModel(sId).isLocal()) return fStuckHere;
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.log(Level.FINEST, "Session stickiness has failed; local session " + sId + " will be destroyed because it is being requested by another server");
                } else if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.log(Level.INFO, "Session stickiness has failed; a local session will be destroyed because it is being requested by another server");
                }
                this.destroy(sId);
                return fStuckHere;
            }
            finally {
                this.exit(sId, true);
            }
        }
        finally {
            cacheOwned.unlock((Object)sId);
            this.removeMapLocksState("releaseStuckSession():" + sId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean obtainAppOwnership(String sId, boolean fWait) {
        boolean fLocked;
        block11: {
            if (this.isAppLockingEnforced()) {
                int cTries = 0;
                while (true) {
                    block12: {
                        ++cTries;
                        NamedCache cache = this.getAppControlCache();
                        cache.lock((Object)sId, -1L);
                        try {
                            Object[] aoInfo = (Object[])cache.get((Object)sId);
                            if (aoInfo == null) {
                                cache.put((Object)sId, (Object)new Object[]{this, 1});
                                fLocked = true;
                                break block11;
                            }
                            if (aoInfo[0] != this) break block12;
                            Integer IRefs = (Integer)aoInfo[1];
                            aoInfo[1] = IRefs + 1;
                            fLocked = true;
                            break block11;
                        }
                        finally {
                            cache.unlock((Object)sId);
                        }
                    }
                    if (!fWait) break;
                    if (cTries <= 1) continue;
                    if (cTries > this.m_configuration.getLockTimeout()) {
                        throw new RequestTimeoutException("Failed to obtain application ownership for the session with id=" + sId);
                    }
                    try {
                        Blocking.sleep((long)Math.min(1000, cTries * 100));
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new WrapperException((Throwable)e);
                    }
                }
                fLocked = false;
            } else {
                fLocked = true;
            }
        }
        return fLocked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseAppOwnership(String sId) {
        if (this.isAppLockingEnforced()) {
            NamedCache cache = this.getAppControlCache();
            cache.lock((Object)sId, -1L);
            try {
                Object[] aoInfo = (Object[])cache.get((Object)sId);
                if (aoInfo == null || aoInfo[0] != this) {
                    throw new IllegalStateException("Attempt to release application ownership for the unowned session with id=" + sId);
                }
                Integer IRefs = (Integer)aoInfo[1];
                int cRefs = IRefs;
                if (cRefs == 1) {
                    cache.remove((Object)sId);
                } else {
                    aoInfo[1] = cRefs - 1;
                }
            }
            finally {
                cache.unlock((Object)sId);
            }
        }
    }

    protected boolean obtainThreadOwnership(String sId) {
        boolean fLocked = false;
        if (!this.isThreadLockingEnforced()) {
            fLocked = this.getOwnedCache().lock((Object)sId, -1L);
        }
        return fLocked;
    }

    protected void releaseThreadOwnership(String sId) {
        this.getOwnedCache().unlock((Object)sId);
    }

    protected boolean isAllowLocalAttributes() {
        return this.m_configuration.isAllowLocalAttributes();
    }

    protected boolean isEnableSuspectAttributes() {
        return this.m_configuration.isEnableSuspectAttributes();
    }

    protected boolean isEnableAttributeListenerOptimization() {
        return this.m_configuration.isEnableAttributeListenerOptimization();
    }

    protected boolean isAssumeLocality() {
        return this.m_configuration.isReaperAssumeLocality();
    }

    public int getSessionIdLength() {
        return this.m_configuration.getSessionIdLength();
    }

    public HttpSessionIdGenerator getSessionIdGenerator() {
        return this.m_sessionIdGenerator;
    }

    protected String generateSessionId() {
        return this.getSessionIdGenerator().generateSessionId(this.getSessionIdLength());
    }

    protected abstract AbstractHttpSessionModel instantiateModel(HttpSession var1, String var2);

    protected AbstractHttpSessionModel getOwnedModel(String sId) {
        AbstractHttpSessionModel model = (AbstractHttpSessionModel)this.getOwnedCache().get((Object)sId);
        if (model == null || !model.isOwnedByThisThread()) {
            throw new IllegalStateException("attempt to get session " + sId + " when it was not owned");
        }
        return model;
    }

    protected AbstractHttpSessionModel getModel(String sId) {
        NamedCache cache;
        AbstractHttpSessionModel model = (AbstractHttpSessionModel)this.getOwnedCache().get((Object)sId);
        if (model == null && (cache = this.getLocalCache()) != null) {
            model = (AbstractHttpSessionModel)cache.get((Object)sId);
        }
        if (model == null && (model = this.getCacheDelegator().getModel(sId, this)) != null && this.isAllowLocalAttributes()) {
            try {
                for (AttributeHolder holder : model.getLocalAttributeMap().values()) {
                    holder.setModel(model);
                    if (!holder.isActivationListener()) continue;
                    model.setActivatableAttributes(true);
                    break;
                }
            }
            catch (ConcurrentModificationException e) {
                model.setActivatableAttributes(true);
            }
        }
        return model;
    }

    protected static void putBlind(Map map, Object oKey, Object oValue) {
        LiteMap mapPut = new LiteMap();
        mapPut.put(oKey, oValue);
        map.putAll(mapPut);
    }

    protected static void removeBlind(Map map, Object oKey) {
        if (map != null) {
            map.keySet().remove(oKey);
        }
    }

    protected static void removeAllBlind(Map map, Set<String> colKeys) {
        if (map != null) {
            map.keySet().removeAll(colKeys);
        }
    }

    public void releaseCache(NamedCache cache) {
        if (cache != null) {
            try {
                cache.release();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public int getAverageModelLifetime() {
        int cDeaths = this.m_cModelDeaths;
        return cDeaths == 0 ? 0 : this.m_cModelSeconds / cDeaths;
    }

    public int getAverageModelSize() {
        int cUpdates = this.m_cModelUpdates;
        return cUpdates == 0 ? 0 : (int)(this.m_cbModelTotalSize / (long)cUpdates);
    }

    public int getMaxModelSize() {
        int cUpdates = this.m_cModelUpdates;
        return cUpdates == 0 ? 0 : this.m_cbModelMaxSize;
    }

    public int getMinModelSize() {
        int cUpdates = this.m_cModelUpdates;
        return cUpdates == 0 ? 0 : this.m_cbModelMinSize;
    }

    public int getModelDeaths() {
        return this.m_cModelDeaths;
    }

    public int getModelUpdates() {
        return this.m_cModelUpdates;
    }

    public void resetStatistics() {
        this.m_cModelDeaths = 0;
        this.m_cModelUpdates = 0;
        this.m_cModelSeconds = 0;
        this.m_cbModelMaxSize = 0;
        this.m_cbModelMinSize = Integer.MAX_VALUE;
        this.m_cbModelTotalSize = 0L;
    }

    protected void onModelUpdate(int cb) {
        if (cb > this.m_cbModelMaxSize) {
            this.m_cbModelMaxSize = cb;
        }
        if (cb < this.m_cbModelMinSize) {
            this.m_cbModelMinSize = cb;
        }
        this.m_cbModelTotalSize += (long)cb;
        ++this.m_cModelUpdates;
    }

    protected void recordMapLocksState(String sKey, String sValue) {
        if (this.f_mapLocks != null) {
            String sActualValue = null;
            while ((sActualValue = this.f_mapLocks.put(sKey, sValue = sActualValue == null ? sValue : sActualValue + "..." + sValue)) == null || !sValue.contains(sActualValue)) {
            }
        }
    }

    protected void removeMapLocksState(String sKey) {
        if (this.f_mapLocks != null) {
            this.f_mapLocks.remove(sKey);
        }
    }

    public static class GlobalScopeController
    implements HttpSessionCollection.AttributeScopeController {
        @Override
        public void init(String sApplication) {
        }

        @Override
        public String qualifyAttributeName(String sAttribute) {
            return sAttribute;
        }

        @Override
        public String extractAttributeName(String sAttribute) {
            return sAttribute;
        }
    }

    public static class ApplicationScopeController
    implements HttpSessionCollection.AttributeScopeController {
        private String m_sApplication;

        @Override
        public void init(String sApplication) {
            this.m_sApplication = sApplication;
        }

        @Override
        public String qualifyAttributeName(String sAttribute) {
            String sApplication = this.m_sApplication;
            if (sApplication == null || sApplication.length() == 0 || sAttribute == null || sAttribute.length() == 0) {
                return sAttribute;
            }
            return sApplication + ':' + sAttribute;
        }

        @Override
        public String extractAttributeName(String sAttribute) {
            int ich;
            String sApplication = this.m_sApplication;
            if (sApplication == null || sApplication.length() == 0 || sAttribute == null || (ich = sAttribute.indexOf(58)) == -1) {
                return sAttribute;
            }
            if (sApplication.equals(sAttribute.substring(0, ich))) {
                return sAttribute.substring(ich + 1);
            }
            return null;
        }
    }

    public static class HybridController
    implements HttpSessionCollection.SessionDistributionController {
        private static Set s_setLocalClassNames = new SegmentedHashSet();

        @Override
        public void init(HttpSessionCollection collection) {
        }

        @Override
        public boolean isSessionDistributed(HttpSessionModel model) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isSessionAttributeDistributed(HttpSessionModel model, String sName) {
            AttributeHolder holder = (AttributeHolder)((AbstractHttpSessionModel)model).getAttributeMap().get(sName);
            if (holder == null) {
                return true;
            }
            Object oValue = holder.getInternalValue();
            if (oValue == null || oValue instanceof Serializable) {
                return true;
            }
            Set setLocalClassNames = s_setLocalClassNames;
            String sClass = oValue.getClass().getName();
            if (!setLocalClassNames.contains(sClass)) {
                Set set = setLocalClassNames;
                synchronized (set) {
                    if (setLocalClassNames.add(sClass) && LOGGER.isLoggable(Level.INFO)) {
                        LOGGER.log(Level.INFO, "The session attribute with name \"" + sName + "\" of type \"" + sClass + "\" does not implement Serializable; this attribute will be kept local and future messages for this class will not be reported");
                    }
                }
            }
            return false;
        }

        public void addLocalClass(Class c) {
            s_setLocalClassNames.add(c.getName());
        }
    }

    public static class DistributedController
    implements HttpSessionCollection.SessionDistributionController {
        @Override
        public void init(HttpSessionCollection collection) {
        }

        @Override
        public boolean isSessionDistributed(HttpSessionModel model) {
            return true;
        }

        @Override
        public boolean isSessionAttributeDistributed(HttpSessionModel model, String sName) {
            return true;
        }
    }

    public static class LocalController
    implements HttpSessionCollection.SessionDistributionController {
        @Override
        public void init(HttpSessionCollection collection) {
        }

        @Override
        public boolean isSessionDistributed(HttpSessionModel model) {
            return false;
        }

        @Override
        public boolean isSessionAttributeDistributed(HttpSessionModel model, String sName) {
            return false;
        }
    }

    class BaseSessionExpiryFilterFactory
    implements SessionExpiryFilterFactory {
        BaseSessionExpiryFilterFactory() {
        }

        @Override
        public Filter createSessionExpiryFilter(Filter baseFilter) {
            return new LessFilter((ValueExtractor)new SessionExpiryExtractor(), (Comparable)Long.valueOf(AbstractHttpSessionCollection.this.getCurrentTime()));
        }
    }
}

