/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.servlet;

import com.tangosol.coherence.servlet.AbstractHttpSessionCollection;
import com.tangosol.coherence.servlet.AbstractHttpSessionModel;
import com.tangosol.coherence.servlet.SessionHelper;
import com.tangosol.coherence.servlet.SessionReaperStatistics;
import com.tangosol.util.Base;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpSession;

public abstract class AbstractReapTask
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(AbstractReapTask.class.getName());
    private final Iterator mIterIds;
    private final SessionHelper mHelper;
    private final SessionHelper.SessionReaperDaemon mDaemon;
    protected long mStartTime;
    private int mNrOfInvalidatedSessions;
    private boolean mDone;
    private SessionReaperStatistics mStatistics;

    public AbstractReapTask(SessionHelper sessionHelper, SessionReaperStatistics statistics, Iterator iterIds) {
        this.mHelper = sessionHelper;
        this.mDaemon = this.mHelper.getSessionReaperDaemon();
        this.mIterIds = iterIds;
        this.mStartTime = SessionHelper.SessionReaperDaemon.getSafeTimeMillis();
        this.mStatistics = statistics;
    }

    @Override
    public void run() {
        try {
            this.mStatistics.setLastReapTime(this.mStartTime);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Checking for expired sessions.");
            }
            this.reap();
        }
        finally {
            this.scheduleNextCycle();
        }
    }

    protected void scheduleNextCycle() {
        SessionHelper.SessionReaperDaemon.StartReapingTask task = this.mDaemon.instantiateStartReapingTask();
        long cMillisCycle = this.mHelper.getDaemonCycleMillis();
        long ldtCur = Base.getSafeTimeMillis();
        long ldtNext = Math.max(this.mStartTime + cMillisCycle, ldtCur + 1000L);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Next reap cycle will start in " + (ldtNext - ldtCur) + "ms.");
        }
        this.mStatistics.setNextReapTime(ldtNext);
        this.mDaemon.scheduleTask(task, ldtNext);
    }

    protected void done() {
        this.mDone = true;
        long time = Base.getSafeTimeMillis() - this.mStartTime;
        this.mStatistics.setLastReapDuration(time);
        this.mStatistics.setReapedSessions(this.mNrOfInvalidatedSessions);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Session Reaping done in " + time + "ms. Invalidated " + this.mNrOfInvalidatedSessions + " sessions.");
        }
    }

    protected abstract void reap();

    protected Iterator getSessionIdIterator() {
        return this.mIterIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkAndInvalidate(String id) {
        block21: {
            boolean exists = true;
            try {
                AbstractHttpSessionCollection collection = (AbstractHttpSessionCollection)this.mHelper.getHttpSessionCollection();
                AbstractHttpSessionModel model = collection.getModel(id);
                if (model == null) {
                    exists = false;
                    break block21;
                }
                if (!model.isExpiredInternal(collection.getCurrentTime())) break block21;
                if (model.getReferenceCount() == 0) {
                    exists = false;
                    try {
                        SessionHelper.setIsReaperThread(true);
                        if (collection.enter(id, false, true)) {
                            model = (AbstractHttpSessionModel)collection.get(id);
                            HttpSession session = this.mHelper.ensureHttpSession(id);
                            session.invalidate();
                        } else {
                            exists = collection.isExistent(id);
                        }
                        break block21;
                    }
                    catch (ConcurrentModificationException e) {
                        exists = true;
                        break block21;
                    }
                    finally {
                        block22: {
                            try {
                                SessionHelper.unsetIsReaperThread();
                                collection.exit(id, false, true);
                            }
                            catch (IllegalStateException e) {
                                if (!LOGGER.isLoggable(Level.FINEST)) break block22;
                                LOGGER.log(Level.FINEST, "Concurrent exit of session: " + id, e);
                            }
                        }
                        if (!exists) {
                            this.mHelper.killSession(id);
                        }
                    }
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Model reference count for expired session: " + model.getId() + " is: " + model.getReferenceCount() + "; reset it back to 0");
                }
                model.resetReferenceCount();
            }
            finally {
                if (!exists) {
                    ++this.mNrOfInvalidatedSessions;
                }
            }
        }
    }

    protected SessionHelper getSessionHelper() {
        return this.mHelper;
    }

    protected SessionHelper.SessionReaperDaemon getDaemon() {
        return this.mDaemon;
    }

    protected boolean isDone() {
        return this.mDone;
    }

    protected int getNrOfInvalidatedSessions() {
        return this.mNrOfInvalidatedSessions;
    }
}

