/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.servlet;

import com.tangosol.coherence.servlet.AbstractHttpSessionModel;
import com.tangosol.coherence.servlet.HttpSessionCollection;
import com.tangosol.util.Base;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionBindingListener;

public class AttributeHolder
extends Base
implements Externalizable {
    private AbstractHttpSessionModel m_model;
    private String m_sName;
    private transient Object m_oValue;
    private boolean m_fActivationListener;
    private boolean m_fBindingListener;
    private transient boolean m_fSuspect;
    private boolean m_fLocal;

    public AttributeHolder() {
    }

    public AttributeHolder(AbstractHttpSessionModel model) {
        this.m_model = model;
    }

    public AttributeHolder(String sName, Object oValue, AbstractHttpSessionModel model) {
        this.m_sName = sName;
        this.m_oValue = oValue;
        this.m_model = model;
        this.m_fSuspect = this.isSuspect(oValue);
        this.m_fActivationListener = oValue instanceof HttpSessionActivationListener;
        this.m_fBindingListener = oValue instanceof HttpSessionBindingListener;
        this.m_fLocal = this.getModel().getCollection().getDistributionController() != null;
    }

    public AbstractHttpSessionModel getModel() {
        return this.m_model;
    }

    protected void setModel(AbstractHttpSessionModel model) {
        this.m_model = model;
    }

    public String getName() {
        return this.m_sName;
    }

    public Object getValue() {
        Object oValue = this.getInternalValue();
        this.setSuspect(this.isSuspect(oValue));
        return oValue;
    }

    public boolean isActivationListener() {
        return this.m_fActivationListener;
    }

    public boolean isBindingListener() {
        return this.m_fBindingListener;
    }

    public void onBound(AttributeHolder holderOrig) {
        if (holderOrig != null) {
            this.setLocal(holderOrig.isLocal());
        }
    }

    public void onUnbound(boolean fReplaced, boolean fAll) {
    }

    public boolean isLocal() {
        return this.m_fLocal;
    }

    protected void setLocal(boolean fLocal) {
        this.m_fLocal = fLocal;
    }

    protected void flush() throws IOException {
        String sName;
        HttpSessionCollection.SessionDistributionController controller;
        AbstractHttpSessionModel model = this.getModel();
        boolean fLocalModel = model.isLocal();
        boolean fLocalAttribute = this.isLocal();
        if (fLocalModel) {
            AttributeHolder.azzert((boolean)fLocalAttribute, (String)"distributed attributes are not allowed for local model");
        } else if (fLocalAttribute && (controller = model.getCollection().getDistributionController()) != null && controller.isSessionAttributeDistributed(model, sName = this.getModel().extractAttributeName(this.getName()))) {
            fLocalAttribute = false;
            this.setLocal(false);
            model.getAttributeMap().put(this.getName(), this);
        }
        if (fLocalAttribute) {
            if (this.isSuspect()) {
                model.getAttributeMap().put(this.getName(), this);
                this.setSuspect(false);
            }
        } else {
            try {
                this.prepareWrite();
            }
            catch (Exception e) {
                model.logAttributeSerializationFailure(this, e);
                if (model.getCollection().isAllowLocalAttributes()) {
                    this.setLocal(true);
                    model.getAttributeMap().put(this.getName(), this);
                }
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw AttributeHolder.ensureRuntimeException((Throwable)e);
            }
        }
    }

    protected Object getInternalValue() {
        return this.m_oValue;
    }

    protected void setInternalValue(Object oValue) {
        this.m_oValue = oValue;
    }

    protected boolean isSuspect() {
        return this.m_fSuspect;
    }

    protected boolean isSuspect(Object oValue) {
        return this.isEnableSuspectAttributes() && !AbstractHttpSessionModel.isImmutable(oValue);
    }

    protected void setSuspect(boolean fSuspect) {
        this.m_fSuspect = fSuspect;
    }

    protected void prepareWrite() throws IOException {
    }

    protected boolean isEnableSuspectAttributes() {
        return this.getModel().getCollection().isEnableSuspectAttributes();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.readExternal((DataInput)in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.writeExternal((DataOutput)out);
    }

    public void readExternal(DataInput in) throws IOException {
        this.m_sName = ExternalizableHelper.readUTF((DataInput)in);
        this.m_oValue = ExternalizableHelper.readObject((DataInput)in);
        this.m_fActivationListener = in.readBoolean();
        this.m_fBindingListener = in.readBoolean();
        this.m_fLocal = in.readBoolean();
    }

    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeUTF((DataOutput)out, (String)this.m_sName);
        ExternalizableHelper.writeObject((DataOutput)out, (Object)this.m_oValue);
        out.writeBoolean(this.m_fActivationListener);
        out.writeBoolean(this.m_fBindingListener);
        out.writeBoolean(this.m_fLocal);
        this.setSuspect(false);
    }
}

