/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.servlet;

import com.tangosol.coherence.servlet.AbstractHttpSessionCollection;
import com.tangosol.coherence.servlet.AbstractHttpSessionModel;
import com.tangosol.coherence.servlet.CacheDelegator;
import com.tangosol.coherence.servlet.SessionHelper;
import com.tangosol.io.Serializer;
import com.tangosol.net.CacheService;
import com.tangosol.net.DistributedCacheService;
import com.tangosol.net.NamedCache;
import com.tangosol.net.internal.RemoveEntryProcessor;
import com.tangosol.net.internal.SessionOptimisticPut;
import com.tangosol.net.internal.SessionOptimisticRemove;
import com.tangosol.net.internal.SessionUpdateTimestamp;
import com.tangosol.net.partition.PartitionSet;
import com.tangosol.net.partition.PartitionedIterator;
import com.tangosol.util.Binary;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.processor.ConditionalProcessor;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultCacheDelegator
implements CacheDelegator {
    private static boolean s_fWarnNotDistService;
    protected static final Logger LOGGER;

    @Override
    public void deleteModel(AbstractHttpSessionCollection collection, AbstractHttpSessionModel model) {
        String sId = model.getId();
        NamedCache cacheCluster = collection.getClusterCache();
        if (collection.isAppLockingEnforced()) {
            AbstractHttpSessionCollection.removeBlind((Map)cacheCluster, sId);
        } else {
            Integer NVersionCur = (Integer)cacheCluster.invoke((Object)sId, (InvocableMap.EntryProcessor)new SessionOptimisticRemove(model.getVersion(), SessionHelper.isSyntheticSessionRemoveRequired()));
            if (NVersionCur < 0 && LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "Delete request failed for session: " + sId, new ConcurrentModificationException("expected version=" + model.getVersion() + "; current version=" + -NVersionCur.intValue()));
            }
        }
    }

    @Override
    public boolean containsKey(String sId, AbstractHttpSessionCollection collection) {
        return collection.getClusterCache().containsKey((Object)sId);
    }

    @Override
    public Iterator getIteratorForPotentiallyExpiredIds(AbstractHttpSessionCollection collection) {
        NamedCache cacheCluster = collection.getClusterCache();
        CacheService service = cacheCluster.getCacheService();
        if (service instanceof DistributedCacheService) {
            DistributedCacheService serviceDist = (DistributedCacheService)service;
            PartitionSet setPids = null;
            if (collection.isAssumeLocality()) {
                if (serviceDist.isLocalStorageEnabled()) {
                    setPids = serviceDist.getOwnedPartitions(serviceDist.getCluster().getLocalMember());
                } else {
                    AbstractHttpSessionCollection.azzertFailed((String)"Configurator should not allow this state");
                }
            }
            if (setPids == null) {
                setPids = new PartitionSet(serviceDist.getPartitionCount());
                setPids.fill();
            }
            Filter filter = collection.getSessionExpiryFilter();
            int nOptions = 6;
            return new PartitionedIterator(cacheCluster, filter, setPids, nOptions);
        }
        if (service.getInfo().getServiceType().equals("RemoteCache")) {
            Filter filter = collection.getSessionExpiryFilter();
            return cacheCluster.keySet(filter).iterator();
        }
        if (!s_fWarnNotDistService) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "Session management was configured to use a non-partitioned cache service;  this is sub-optimal and unsupported.");
            }
            s_fWarnNotDistService = true;
        }
        return collection.iterateIds();
    }

    @Override
    public Iterator getIteratorForPotentiallyExpiredLocalIds(AbstractHttpSessionCollection collection) {
        Filter filter;
        Set<String> setLocalIds = collection.getLocalSessonIdsSnapshot();
        NamedCache cacheCluster = collection.getClusterCache();
        Map result = cacheCluster.invokeAll(setLocalIds, (InvocableMap.EntryProcessor)new ConditionalProcessor(filter = collection.getSessionExpiryFilter(), (InvocableMap.EntryProcessor)new NullImplementation.NullEntryProcessor()));
        if (result == null) {
            return setLocalIds.iterator();
        }
        return result.keySet().iterator();
    }

    @Override
    public Set<String> deleteExpiredSessions(AbstractHttpSessionCollection collection) {
        NamedCache cacheCluster = collection.getClusterCache();
        Filter filter = collection.getSessionExpiryFilter();
        return cacheCluster.invokeAll(filter, (InvocableMap.EntryProcessor)new RemoveEntryProcessor(SessionHelper.isSyntheticSessionRemoveRequired())).keySet();
    }

    @Override
    public Set<String> deleteExpiredLocalSessions(AbstractHttpSessionCollection collection) {
        Set<String> localSessionIds = collection.getLocalSessonIdsSnapshot();
        NamedCache cacheCluster = collection.getClusterCache();
        Filter filter = collection.getSessionExpiryFilter();
        return cacheCluster.invokeAll(localSessionIds, (InvocableMap.EntryProcessor)new ConditionalProcessor(filter, (InvocableMap.EntryProcessor)new RemoveEntryProcessor(SessionHelper.isSyntheticSessionRemoveRequired()))).keySet();
    }

    @Override
    public AbstractHttpSessionModel getModel(String sId, AbstractHttpSessionCollection collection) {
        AbstractHttpSessionModel model = (AbstractHttpSessionModel)collection.getClusterCache().get((Object)sId);
        if (model != null) {
            model.setCollection(collection);
            return model;
        }
        return null;
    }

    @Override
    public void optimisticModelUpdate(AbstractHttpSessionModel model) {
        String sId = model.getId();
        AbstractHttpSessionCollection collection = model.getCollection();
        NamedCache cache = model.isLocal() ? collection.getLocalCache() : collection.getClusterCache();
        int nVersionOld = model.getVersion();
        int nVersionNew = nVersionOld + 1;
        model.setVersion(nVersionNew);
        Binary binModel = ExternalizableHelper.toBinary((Object)model, (Serializer)cache.getCacheService().getSerializer());
        Integer NVersionRet = (Integer)cache.invoke((Object)sId, (InvocableMap.EntryProcessor)new SessionOptimisticPut(binModel, nVersionOld, !collection.isSessionLockingEnforced()));
        int nVersionRet = NVersionRet;
        if (nVersionRet <= 0) {
            model.setVersion(nVersionOld);
            throw new ConcurrentModificationException("expected version=" + nVersionOld + "; current version=" + (nVersionRet == 0 ? "N/A" : String.valueOf(-nVersionRet)));
        }
        if (nVersionRet > nVersionNew) {
            model.setVersion(nVersionRet);
        }
    }

    @Override
    public void putModel(AbstractHttpSessionModel model) {
        String sId = model.getId();
        AbstractHttpSessionCollection.putBlind((Map)this.retrieveCorrectCache(model), sId, model);
    }

    @Override
    public void updateModelTimestamp(AbstractHttpSessionModel model) {
        String sId = model.getId();
        this.retrieveCorrectCache(model).invoke((Object)sId, (InvocableMap.EntryProcessor)new SessionUpdateTimestamp(model.getLastAccessedTime(), model.getLastFlushedTime()));
    }

    private NamedCache retrieveCorrectCache(AbstractHttpSessionModel model) {
        AbstractHttpSessionCollection collection = model.getCollection();
        return model.isLocal() ? collection.getLocalCache() : collection.getClusterCache();
    }

    @Override
    public void flush(AbstractHttpSessionCollection collection, AbstractHttpSessionModel model) {
        String sId = model.getId();
        if (model.getReferenceCount() == 1) {
            if (model.getNewId() != null) {
                collection.remapSessionId(model);
            }
            model.flush();
        }
    }

    static {
        LOGGER = Logger.getLogger(AbstractHttpSessionCollection.class.getName());
    }
}

