/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.servlet;

import com.tangosol.coherence.servlet.AbstractReapTask;
import com.tangosol.coherence.servlet.SessionHelper;
import com.tangosol.coherence.servlet.SessionReaperStatistics;
import com.tangosol.util.Base;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IncrementalReapTask
extends AbstractReapTask {
    private static final Logger LOGGER = Logger.getLogger(IncrementalReapTask.class.getName());
    private int m_cChunkSessions;
    private int m_cChunkMillis;

    public IncrementalReapTask(SessionHelper sessionHelper, SessionReaperStatistics statistics, Iterator iterIds, int cEstimatedSessions) {
        super(sessionHelper, statistics, iterIds);
        int cMillisWindow = (int)this.getSessionHelper().getDaemonCycleMillis();
        int cMillisPer = 10;
        int cMillisPause = 1000;
        int cMinChunk = 10;
        int cMaxChunk = 250;
        cEstimatedSessions = Math.max(cEstimatedSessions, cMaxChunk);
        int cMinPeriodMillis = cMaxChunk * cMillisPer + cMillisPause;
        int cMaxTotalMillis = (int)((double)cEstimatedSessions / (double)cMaxChunk * (double)cMinPeriodMillis);
        if (cMaxTotalMillis > cMillisWindow) {
            this.m_cChunkSessions = cMaxChunk;
            this.m_cChunkMillis = cMinPeriodMillis;
        } else {
            double dflUtilization = (double)cMaxTotalMillis / (double)cMillisWindow;
            this.m_cChunkSessions = (int)(dflUtilization * (double)cMaxChunk);
            if (this.m_cChunkSessions < cMinChunk) {
                this.m_cChunkSessions = cMinChunk;
                int cPeriods = cEstimatedSessions / cMinChunk;
                this.m_cChunkMillis = cMillisWindow / cPeriods;
            } else {
                this.m_cChunkMillis = cMinPeriodMillis;
            }
        }
    }

    @Override
    protected void reap() {
        try {
            Iterator iter = this.getSessionIdIterator();
            int cRemaining = this.getSessionChunkCount();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Start reaping (" + cRemaining + " in this chunk).");
            }
            do {
                if (iter.hasNext()) {
                    String sId = (String)iter.next();
                    try {
                        this.checkAndInvalidate(sId);
                    }
                    catch (RuntimeException e) {
                        SessionHelper.logEventException(e, "reap()", true);
                    }
                    continue;
                }
                this.getDaemon().setEstimatedReaperSessionCount(this.getNrOfInvalidatedSessions());
                this.done();
                break;
            } while (--cRemaining > 0);
        }
        catch (ConcurrentModificationException e) {
            this.done();
        }
        catch (NoSuchElementException e) {
            this.done();
        }
        catch (RuntimeException e) {
            this.done();
            throw e;
        }
        catch (Error e) {
            this.done();
            throw e;
        }
    }

    @Override
    protected void scheduleNextCycle() {
        if (this.isDone()) {
            super.scheduleNextCycle();
        } else {
            long ldtStop = Base.getSafeTimeMillis();
            long cMillisChunk = this.getSessionChunkMillis();
            long ldtNext = Math.max(this.mStartTime + cMillisChunk, ldtStop + 1000L);
            this.getDaemon().scheduleTask(this, ldtNext);
        }
    }

    public int getSessionChunkCount() {
        return this.m_cChunkSessions;
    }

    public int getSessionChunkMillis() {
        return this.m_cChunkMillis;
    }
}

