/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.servlet;

import com.tangosol.coherence.servlet.AbstractHttpSessionCollection;
import com.tangosol.coherence.servlet.AbstractHttpSessionModel;
import com.tangosol.coherence.servlet.DefaultCacheDelegator;
import com.tangosol.coherence.servlet.SessionHelper;
import com.tangosol.net.NamedCache;
import com.tangosol.net.internal.RemoveEntryProcessor;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.processor.ConditionalProcessor;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class LocalSessionCacheDelegator
extends DefaultCacheDelegator {
    @Override
    public void deleteModel(AbstractHttpSessionCollection collection, AbstractHttpSessionModel model) {
        String sId = model.getId();
        AbstractHttpSessionCollection.removeBlind((Map)collection.getLocalCache(), sId);
        AbstractHttpSessionCollection.removeBlind((Map)collection.getClusterCache(), sId);
    }

    @Override
    public void optimisticModelUpdate(AbstractHttpSessionModel model) {
        this.putModel(model);
    }

    @Override
    public void putModel(AbstractHttpSessionModel model) {
        String sId = model.getId();
        AbstractHttpSessionCollection collection = model.getCollection();
        AbstractHttpSessionCollection.putBlind((Map)collection.getLocalCache(), sId, model);
        if (!model.isLocal()) {
            AbstractHttpSessionCollection.putBlind((Map)collection.getClusterCache(), sId, model);
        }
    }

    @Override
    public Iterator getIteratorForPotentiallyExpiredLocalIds(AbstractHttpSessionCollection collection) {
        Set<String> setLocalIds = collection.getLocalSessionIds();
        return setLocalIds.iterator();
    }

    @Override
    public Set<String> deleteExpiredSessions(AbstractHttpSessionCollection collection) {
        Filter filter;
        NamedCache cacheCluster = collection.getClusterCache();
        Map result = cacheCluster.invokeAll(filter = collection.getSessionExpiryFilter(), (InvocableMap.EntryProcessor)new RemoveEntryProcessor(SessionHelper.isSyntheticSessionRemoveRequired()));
        if (result == null) {
            return null;
        }
        AbstractHttpSessionCollection.removeAllBlind((Map)collection.getLocalCache(), result.keySet());
        return result.keySet();
    }

    @Override
    public Set<String> deleteExpiredLocalSessions(AbstractHttpSessionCollection collection) {
        Filter filter;
        Set<String> localSessionIds = collection.getLocalSessonIdsSnapshot();
        NamedCache cacheCluster = collection.getClusterCache();
        Map result = cacheCluster.invokeAll(localSessionIds, (InvocableMap.EntryProcessor)new ConditionalProcessor(filter = collection.getSessionExpiryFilter(), (InvocableMap.EntryProcessor)new RemoveEntryProcessor(SessionHelper.isSyntheticSessionRemoveRequired())));
        if (result == null) {
            return null;
        }
        AbstractHttpSessionCollection.removeAllBlind((Map)collection.getLocalCache(), result.keySet());
        return result.keySet();
    }

    @Override
    public void flush(AbstractHttpSessionCollection collection, AbstractHttpSessionModel model) {
        String sId = model.getId();
        if (model.getNewId() != null) {
            collection.remapSessionId(model);
        }
        model.flush();
    }
}

