/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.servlet;

import com.tangosol.coherence.servlet.AbstractHttpSessionModel;
import com.tangosol.coherence.servlet.AttributeHolder;
import com.tangosol.coherence.servlet.MonolithicHttpSessionCollection;
import com.tangosol.io.ByteArrayWriteBuffer;
import com.tangosol.io.ClassLoaderAware;
import com.tangosol.io.Serializer;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.SimpleEnumerator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpSession;

public class MonolithicHttpSessionModel
extends AbstractHttpSessionModel {
    private transient boolean m_fWritingAttr;
    private transient Map m_mapFailedAttr;
    private transient Binary m_binAttributes;

    public MonolithicHttpSessionModel() {
    }

    public MonolithicHttpSessionModel(MonolithicHttpSessionCollection collection, HttpSession session, String sId) {
        super(collection, session, sId);
    }

    @Override
    protected void readAttributes(DataInput in) throws IOException {
        this.m_binAttributes = new Binary(ExternalizableHelper.read((DataInput)in));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void writeAttributes(DataOutput out) throws IOException {
        this.enterWriteAttributes();
        try {
            byte[] abAttributes = null;
            int cbAttributes = 0;
            boolean fSuccess = false;
            boolean fFirstTime = true;
            do {
                ObjectOutput streamObj;
                try {
                    ByteArrayWriteBuffer buffer = new ByteArrayWriteBuffer(1024);
                    streamObj = ExternalizableHelper.getObjectOutput((DataOutput)buffer.getBufferOutput());
                    super.writeAttributes(streamObj);
                    streamObj.close();
                    abAttributes = buffer.getRawByteArray();
                    cbAttributes = buffer.length();
                    fSuccess = true;
                }
                catch (IOException e) {
                    if (fFirstTime) {
                        fFirstTime = false;
                        streamObj = null;
                        SimpleEnumerator iter = new SimpleEnumerator(this.getActualAttributeMap().values());
                        while (iter.hasNext()) {
                            if (streamObj == null) {
                                streamObj = ExternalizableHelper.getObjectOutput((DataOutput)NullImplementation.getDataOutput());
                            }
                            AttributeHolder holder = (AttributeHolder)iter.next();
                            try {
                                holder.writeExternal(streamObj);
                            }
                            catch (IOException eTest) {
                                this.logAttributeSerializationFailure(holder, eTest);
                                streamObj = null;
                            }
                        }
                        continue;
                    }
                    throw e;
                }
            } while (!fSuccess);
            out.write(abAttributes, 0, cbAttributes);
        }
        finally {
            this.leaveWriteAttributes();
        }
    }

    protected void enterWriteAttributes() {
        MonolithicHttpSessionModel.azzert((!this.m_fWritingAttr ? 1 : 0) != 0);
        this.m_fWritingAttr = true;
    }

    protected void leaveWriteAttributes() {
        MonolithicHttpSessionModel.azzert((boolean)this.m_fWritingAttr);
        Map mapFailures = this.getAttributeSerializationFailureMap();
        if (mapFailures != null) {
            if (!mapFailures.isEmpty()) {
                this.getAttributeMap().putAll(mapFailures);
            }
            this.setAttributeSerializationFailureMap(null);
        }
        this.m_fWritingAttr = false;
    }

    protected boolean isWritingAttributes() {
        return this.m_fWritingAttr;
    }

    protected Map getAttributeSerializationFailureMap() {
        return this.m_mapFailedAttr;
    }

    protected void setAttributeSerializationFailureMap(Map mapFailures) {
        MonolithicHttpSessionModel.azzert((boolean)this.isWritingAttributes());
        this.m_mapFailedAttr = mapFailures;
    }

    protected Map ensureAttributeSerializationFailureMap() {
        MonolithicHttpSessionModel.azzert((boolean)this.isWritingAttributes());
        HashMap mapFailures = this.getAttributeSerializationFailureMap();
        if (mapFailures == null) {
            mapFailures = new HashMap();
            this.setAttributeSerializationFailureMap(mapFailures);
        }
        return mapFailures;
    }

    @Override
    protected void logAttributeSerializationFailure(AttributeHolder holder, Throwable e) {
        super.logAttributeSerializationFailure(holder, e);
        if (this.isWritingAttributes()) {
            if (!holder.isLocal() && this.getCollection().isAllowLocalAttributes()) {
                holder.setLocal(true);
                this.getAttributeMap().put(holder.getName(), holder);
            } else {
                this.getAttributeMap().remove(holder.getName());
                this.ensureAttributeSerializationFailureMap().put(holder.getName(), holder);
            }
        }
    }

    @Override
    protected void enter() {
        super.enter();
        Binary binAttributes = this.m_binAttributes;
        if (binAttributes == null) {
            return;
        }
        Serializer serializer = this.getCollection().getSerializer();
        ClassLoader loader = serializer instanceof ClassLoaderAware ? ((ClassLoaderAware)serializer).getContextClassLoader() : null;
        try (ObjectInput inAttributes = ExternalizableHelper.getNewObjectInput((DataInput)binAttributes.getBufferInput(), (ClassLoader)loader);){
            super.readAttributes(inAttributes);
            this.m_binAttributes = null;
        }
        catch (IOException e) {
            throw Base.ensureRuntimeException((Throwable)e);
        }
    }

    @Override
    public String toString() {
        return "MonolithicHttpSessionModel\n" + MonolithicHttpSessionModel.indentString((String)this.getDescription(), (String)"  ");
    }
}

