/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.servlet;

import com.tangosol.coherence.servlet.AbstractReapTask;
import com.tangosol.coherence.servlet.SessionHelper;
import com.tangosol.coherence.servlet.SessionReaperStatistics;
import com.tangosol.coherence.servlet.commonj.Work;
import com.tangosol.coherence.servlet.commonj.WorkEvent;
import com.tangosol.coherence.servlet.commonj.WorkException;
import com.tangosol.coherence.servlet.commonj.WorkListener;
import com.tangosol.coherence.servlet.commonj.WorkManager;
import com.tangosol.util.Base;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ParallelReapTask
extends AbstractReapTask {
    private static final Logger LOGGER = Logger.getLogger(ParallelReapTask.class.getName());
    private WorkManager mWorkManager;
    private int mWorkScheduled = 0;

    public ParallelReapTask(SessionHelper sessionHelper, SessionReaperStatistics statistics, Iterator iterIds, WorkManager workManager) {
        super(sessionHelper, statistics, iterIds);
        this.mWorkManager = workManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void reap() {
        if (this.getSessionIdIterator().hasNext()) {
            LOGGER.log(Level.FINE, "Start parallel reaping...");
            ReapWorkListener listener = new ReapWorkListener();
            do {
                ReapWorkListener reapWorkListener = listener;
                synchronized (reapWorkListener) {
                    String sessionId = (String)this.getSessionIdIterator().next();
                    try {
                        this.mWorkManager.schedule(new ReapWork(sessionId), listener);
                        ++this.mWorkScheduled;
                    }
                    catch (Exception e) {
                        if (LOGGER.isLoggable(Level.FINEST)) {
                            LOGGER.log(Level.SEVERE, "Failed to schedule reap job for session " + sessionId + ".", e);
                        }
                        LOGGER.log(Level.SEVERE, "Failed to schedule reap job for a Coherence*Web session. ", e);
                    }
                }
            } while (this.getSessionIdIterator().hasNext());
            LOGGER.log(Level.FINE, "All work scheduled.");
        } else {
            LOGGER.log(Level.FINE, "Nothing to reap.");
        }
    }

    private class ReapWorkListener
    implements WorkListener {
        private int mWorkRejected = 0;
        private int mWorkCompleted = 0;

        private ReapWorkListener() {
        }

        @Override
        public void workAccepted(WorkEvent event) {
        }

        @Override
        public synchronized void workCompleted(WorkEvent event) {
            ++this.mWorkCompleted;
            WorkException we = event.getException();
            if (we != null && LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, "An exception was thrown while reaping a session.\n" + we + '\n' + Base.getStackTrace((Throwable)we));
            }
            this.checkAllWorkDone();
        }

        @Override
        public synchronized void workRejected(WorkEvent event) {
            ++this.mWorkRejected;
            this.checkAllWorkDone();
        }

        @Override
        public void workStarted(WorkEvent arg0) {
        }

        private void checkAllWorkDone() {
            if (ParallelReapTask.this.mWorkScheduled <= this.mWorkCompleted + this.mWorkRejected && !ParallelReapTask.this.getSessionIdIterator().hasNext()) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "All work completed. Rejected:" + this.mWorkRejected + " Succeeded:" + this.mWorkCompleted);
                }
                ParallelReapTask.this.done();
            }
        }
    }

    private class ReapWork
    implements Work {
        private String mId;

        public ReapWork(String id) {
            this.mId = id;
        }

        @Override
        public void run() {
            ParallelReapTask.this.checkAndInvalidate(this.mId);
        }

        @Override
        public boolean isDaemon() {
            return false;
        }
    }
}

