/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.servlet;

import com.tangosol.coherence.servlet.ServiceHelper;
import com.tangosol.coherence.servlet.ServiceHelperDefault;
import com.tangosol.coherence.servlet.SessionHelper;
import com.tangosol.util.SafeHashSet;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.http.HttpServletRequest;

class ServiceHelperLazy
implements ServiceHelper {
    protected final ServiceHelper wrapped;
    protected final Set deferredEnterSet = new SafeHashSet();
    protected final Set exitSet = new SafeHashSet();

    ServiceHelperLazy(SessionHelper sessionHelper) {
        this(new ServiceHelperDefault(sessionHelper));
    }

    ServiceHelperLazy(ServiceHelper wrapped) {
        assert (wrapped != null);
        this.wrapped = wrapped;
    }

    @Override
    public void enterSession(HttpServletRequest req) {
        ServletRequest rootReq = this.getRootServletRequest((ServletRequest)req);
        this.deferredEnterSet.add(rootReq);
    }

    @Override
    public void exitSession(HttpServletRequest req) {
        ServletRequest rootReq = this.getRootServletRequest((ServletRequest)req);
        boolean exitSession = this.exitSet.remove(rootReq);
        this.deferredEnterSet.remove(rootReq);
        if (exitSession) {
            this.wrapped.exitSession(req);
        }
    }

    @Override
    public void onGetSession(HttpServletRequest req) {
        ServletRequest rootReq = this.getRootServletRequest((ServletRequest)req);
        boolean enterSession = this.deferredEnterSet.remove(rootReq);
        if (enterSession) {
            this.wrapped.enterSession(req);
            this.exitSet.add(rootReq);
        }
        this.wrapped.onGetSession(req);
    }

    private ServletRequest getRootServletRequest(ServletRequest req) {
        while (req instanceof ServletRequestWrapper) {
            req = ((ServletRequestWrapper)req).getRequest();
        }
        return req;
    }
}

