/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.servlet;

import com.tangosol.coherence.servlet.SessionHelper;
import com.tangosol.coherence.servlet.SessionHelperFactory;
import com.tangosol.util.ClassHelper;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;

public class SessionHelperManager {
    private static final Logger LOGGER = Logger.getLogger(SessionHelperManager.class.getName());
    public static final String DEFAULT_FACTORY = "DefaultFactory";
    public static final String CTX_ATTR_HELPER = "coherence-sessionhelper";

    protected static SessionHelper createSessionHelper(ServletContext ctx) {
        SessionHelperFactory factory;
        String sClass = ctx.getInitParameter("coherence-factory-class");
        if (sClass != null && (sClass = sClass.trim()).length() == 0) {
            sClass = null;
        }
        if (sClass == null) {
            int[] anVer = SessionHelperManager.getSupportedVersion(ctx);
            int nVersionMajor = anVer[0];
            int nVersionMinor = anVer[1];
            String sBasePkg = ClassHelper.getPackageName(SessionHelper.class);
            String sImplPkg = ClassHelper.getCompositePackage((String)sBasePkg, (String)(".api" + nVersionMajor + nVersionMinor + "."));
            sClass = ClassHelper.getQualifiedName((String)sImplPkg, (String)DEFAULT_FACTORY);
        }
        try {
            Class<?> clzFactory = Class.forName(sClass);
            factory = (SessionHelperFactory)clzFactory.newInstance();
        }
        catch (Exception e) {
            throw SessionHelper.ensureRuntimeException((Throwable)e, (String)("exception instantiating the factory class: " + sClass));
        }
        return factory.instantiateSessionHelper(ctx);
    }

    public static SessionHelper ensureSessionHelper(ServletContext ctx) {
        return SessionHelperManager.ensureSessionHelper(ctx, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SessionHelper ensureSessionHelper(ServletContext ctx, boolean configureSessionHelper) {
        try {
            SessionHelper helper = (SessionHelper)((Object)ctx.getAttribute(CTX_ATTR_HELPER));
            if (helper != null) {
                return helper;
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        ServletContext servletContext = ctx;
        synchronized (servletContext) {
            SessionHelper helper2;
            try {
                helper2 = (SessionHelper)((Object)ctx.getAttribute(CTX_ATTR_HELPER));
                if (helper2 != null) {
                    return helper2;
                }
            }
            catch (RuntimeException helper2) {
                // empty catch block
            }
            if (ctx.getInitParameter("coherence-sessioncollection-class") == null) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, "A required context parameter is missing in the ServletContext. This may be caused by a corrupt web.xml or by a Servlet container generating an invalid ServletContextEvent object for a ServletContext that is not fully initialized.");
                }
                throw new IllegalStateException("Missing the required context parameter 'coherence-sessioncollection-class', perhaps due to an invalid context initialization");
            }
            helper2 = SessionHelperManager.createSessionHelper(ctx);
            if (configureSessionHelper) {
                helper2.configure();
            }
            ctx.setAttribute(CTX_ATTR_HELPER, (Object)helper2);
            return helper2;
        }
    }

    public static int[] getSupportedVersion(ServletContext ctx) {
        int nVerMajor = ctx.getMajorVersion();
        int nVerMinor = ctx.getMinorVersion();
        if (nVerMajor < 2) {
            throw new IllegalArgumentException("cannot support ServletContext version " + nVerMajor + ".x");
        }
        if (nVerMajor > 2) {
            nVerMajor = 2;
            nVerMinor = 5;
        } else {
            nVerMajor = 2;
        }
        if (nVerMajor == 2) {
            if (nVerMinor < 3) {
                throw new IllegalArgumentException("cannot support ServletContext version 2." + nVerMinor);
            }
            if (nVerMinor > 5) {
                nVerMinor = 5;
            }
        } else {
            nVerMinor = 5;
        }
        return new int[]{nVerMajor, nVerMinor};
    }

    public static ServletContext getWrappedServletContext(ServletContext ctx) {
        if (ctx == null) {
            return null;
        }
        ServletContext ctxWrapper = (ServletContext)ctx.getAttribute("coherence-context");
        if (ctxWrapper != null) {
            return ctxWrapper;
        }
        if (ctx.getClass().getName().startsWith(ClassHelper.getPackageName(SessionHelper.class))) {
            return ctx;
        }
        return null;
    }

    public static ServletContext ensureWrappedServletContext(ServletContext ctx) {
        ServletContext ctxWrapper = SessionHelperManager.getWrappedServletContext(ctx);
        if (ctxWrapper == null) {
            ctxWrapper = SessionHelperManager.ensureSessionHelper(ctx).getServletContext();
        }
        return ctxWrapper;
    }
}

