/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.servlet.api23;

import com.tangosol.coherence.servlet.HttpSessionCollection;
import com.tangosol.coherence.servlet.HttpSessionModel;
import com.tangosol.coherence.servlet.SessionHelper;
import com.tangosol.util.Base;
import com.tangosol.util.FilterEnumerator;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class HttpServletRequestWrapper
extends javax.servlet.http.HttpServletRequestWrapper {
    private SessionHelper m_helper;
    private HttpServletResponse m_res;
    private String m_sSessionId;
    private boolean m_fCookie;
    private boolean m_fUrl;

    public HttpServletRequestWrapper(SessionHelper helper, HttpServletRequest req, HttpServletResponse res, String sSessionId, boolean fCookie, boolean fUrl) {
        super(req);
        this.m_helper = helper;
        this.m_res = res;
        this.m_sSessionId = sSessionId;
        this.m_fCookie = fCookie;
        this.m_fUrl = fUrl;
    }

    public Object getAttribute(String sName) {
        if (sName.equals("coherence-test")) {
            return sName;
        }
        return this.getRequest().getAttribute(sName);
    }

    public Enumeration getAttributeNames() {
        return new FilterEnumerator(this.getHttpServletRequest().getAttributeNames(), SessionHelper.NAME_FILTER);
    }

    public String getRequestedSessionId() {
        return this.m_sSessionId;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public HttpSession getSession(boolean fCreate) {
        return this.getSession(fCreate, this.getSessionHelper().isSessionIdCookieEnabled());
    }

    public HttpSession getSession(boolean fCreate, boolean fCookie) {
        HttpServletRequest req = this.getHttpServletRequest();
        HttpServletResponse res = this.getHttpServletResponse();
        SessionHelper helper = this.getSessionHelper();
        boolean fNew = false;
        boolean fInvalid = false;
        try {
            this.getHttpServletRequest().getSession(false);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        helper.onGetHttpSession((HttpServletRequest)this);
        HttpSession session = helper.getHttpSession(req);
        if (session != null) {
            String sId;
            HttpSessionCollection collection = helper.getHttpSessionCollection();
            if (collection.isExistent(sId = session.getId())) {
                if (!collection.isOwned(sId)) {
                    collection.enter(sId, true);
                    HttpSessionModel model = collection.get(sId);
                    if (model != null) {
                        model.touch();
                    }
                    session = helper.ensureHttpSession(sId);
                    helper.setHttpSession(req, session);
                }
            } else {
                fInvalid = true;
                session = null;
                helper.setHttpSession(req, session);
                try {
                    HttpSession sessionExt = this.getHttpServletRequest().getSession(false);
                    if (sessionExt != null) {
                        sessionExt.invalidate();
                    }
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
        }
        if (session == null && !fInvalid) {
            String sId = this.getRequestedSessionId();
            if (helper.getHttpSessionCollection().isExistent(sId)) {
                session = helper.ensureHttpSession(sId);
                helper.setHttpSession(req, session);
            }
        }
        if (session == null && fCreate) {
            if (fCookie) {
                if (res == null) {
                    throw new IllegalStateException("Failed to create a new session because the response object is not yet available");
                }
                if (res.isCommitted() && helper.isStrict()) {
                    throw new IllegalStateException("Failed to create a new session because the response was already committed");
                }
            }
            session = helper.createHttpSession();
            helper.setHttpSession(req, session);
            fNew = true;
        }
        if (fCookie && session != null) {
            helper.encodeCookie((HttpServletRequest)this, res, session.getId(), fNew);
        }
        return session;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.m_fCookie;
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.m_fUrl;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdValid() {
        return this.getSessionHelper().getHttpSessionCollection().isExistent(this.getRequestedSessionId());
    }

    public String changeSessionId() {
        HttpSession session = this.getSession(false);
        if (session != null) {
            return this.getSessionHelper().updateSessionId(session.getId(), null);
        }
        return null;
    }

    public String toString() {
        return "HttpServletRequestWrapper (2.3)\n" + Base.indentString((String)this.getDescription(), (String)"  ");
    }

    protected String getDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("HttpServletRequest=").append(Base.indentString((String)String.valueOf(this.getHttpServletRequest()), (String)"  ", (boolean)false));
        return sb.toString();
    }

    public SessionHelper getSessionHelper() {
        return this.m_helper;
    }

    public HttpServletRequest getHttpServletRequest() {
        return (HttpServletRequest)this.getRequest();
    }

    public HttpServletResponse getHttpServletResponse() {
        return this.m_res;
    }
}

