/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.servlet.api23;

import com.tangosol.coherence.servlet.SessionHelper;
import com.tangosol.coherence.servlet.SessionHelperManager;
import com.tangosol.util.Base;
import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;

public class HttpServletWrapper
extends HttpServlet {
    private SessionHelper m_helper;
    private HttpServlet m_servlet;

    public void init(ServletConfig cfg) throws ServletException {
        HttpServlet servlet;
        SessionHelper helper;
        Base.azzert((cfg != null ? 1 : 0) != 0);
        String sClass = cfg.getInitParameter("coherence-servlet-class");
        if (sClass == null || (sClass = sClass.trim()).length() == 0) {
            throw new ServletException(SessionHelper.PRODUCT_BANNER + ": Servlet initialization could not proceed because the wrapped servlet class name was not available");
        }
        this.m_helper = helper = SessionHelperManager.ensureSessionHelper(cfg.getServletContext());
        cfg = helper.wrapServletConfig(cfg);
        super.init(cfg);
        try {
            servlet = (HttpServlet)Class.forName(sClass).newInstance();
        }
        catch (Exception e) {
            throw new ServletException(SessionHelper.PRODUCT_BANNER + ": Servlet initialization encountered an exception while initializing the wrapped servlet class: " + sClass, (Throwable)e);
        }
        this.m_servlet = servlet;
        servlet.init(cfg);
        helper.servletInitialized();
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        this.getSessionHelper().service((Servlet)this.getServlet(), req, res);
    }

    public String getServletInfo() {
        HttpServlet servlet = this.getServlet();
        String sInfo = servlet == null ? "Coherence HttpServletWrapper (uninitialized)" : servlet.getServletInfo();
        return sInfo + " (clustered by " + SessionHelper.PRODUCT_BANNER + ")";
    }

    public void destroy() {
        HttpServlet servlet = this.getServlet();
        if (servlet != null) {
            servlet.destroy();
        }
        super.destroy();
        SessionHelper helper = this.getSessionHelper();
        if (helper != null) {
            helper.servletDestroyed();
        }
    }

    public String toString() {
        return "HttpServletWrapper (2.3)\n" + Base.indentString((String)this.getDescription(), (String)"  ");
    }

    protected String getDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("SessionHelper").append(this.getSessionHelper() == null ? "==null" : "!=null").append("\nServlet=").append(Base.indentString((String)String.valueOf(this.getServlet()), (String)"  ", (boolean)false)).append("\nServletConfig=").append(Base.indentString((String)String.valueOf(this.getServletConfig()), (String)"  ", (boolean)false));
        return sb.toString();
    }

    protected HttpServlet getServlet() {
        return this.m_servlet;
    }

    protected SessionHelper getSessionHelper() {
        return this.m_helper;
    }
}

