/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.servlet.api23;

import com.tangosol.coherence.servlet.SessionHelper;
import com.tangosol.util.Base;
import com.tangosol.util.FilterEnumerator;
import com.tangosol.util.NullImplementation;
import java.util.Enumeration;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;

public class ServletConfigWrapper
extends Base
implements ServletConfig {
    private SessionHelper m_helper;
    private ServletConfig m_cfg;

    public ServletConfigWrapper(SessionHelper helper, ServletConfig cfg) {
        this.m_helper = helper;
        this.m_cfg = cfg;
    }

    public String getServletName() {
        return this.getServletConfig().getServletName();
    }

    public ServletContext getServletContext() {
        return this.getSessionHelper().getServletContext();
    }

    public String getInitParameter(String sName) {
        if (SessionHelper.NAME_FILTER.evaluate((Object)sName)) {
            return this.getServletConfig().getInitParameter(sName);
        }
        return null;
    }

    public Enumeration getInitParameterNames() {
        Enumeration enmr = this.getServletConfig().getInitParameterNames();
        return enmr == null ? NullImplementation.getEnumeration() : new FilterEnumerator(enmr, SessionHelper.NAME_FILTER);
    }

    public String toString() {
        return "ServletConfigWrapper (2.3)\n" + ServletConfigWrapper.indentString((String)this.getDescription(), (String)"  ");
    }

    protected String getDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("SessionHelper").append(this.getSessionHelper() == null ? "==null" : "!=null").append("\nServletConfig=").append(ServletConfigWrapper.indentString((String)String.valueOf(this.getServletConfig()), (String)"  ", (boolean)false));
        return sb.toString();
    }

    protected SessionHelper getSessionHelper() {
        return this.m_helper;
    }

    protected ServletConfig getServletConfig() {
        return this.m_cfg;
    }
}

