/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.servlet.api23;

import com.tangosol.coherence.servlet.SessionHelper;
import com.tangosol.coherence.servlet.SessionHelperManager;
import com.tangosol.run.component.EventDeathException;
import com.tangosol.util.Base;
import com.tangosol.util.Listeners;
import java.util.EventListener;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

public class ServletContextListenerImpl
extends Base
implements ServletContextListener {
    private SessionHelper m_helper;
    private ServletContext m_ctx;
    private Listeners m_listeners;

    public void contextInitialized(ServletContextEvent evt) {
        Exception eFirst = null;
        ServletContext ctx = this.getServletContext();
        if (ctx == null) {
            eFirst = this.init(evt);
            ctx = this.getServletContext();
            ServletContextListenerImpl.azzert((ctx != null ? 1 : 0) != 0);
        }
        this.getSessionHelper().contextInitialized();
        Listeners listeners = this.getListeners();
        if (!listeners.isEmpty()) {
            ServletContextEvent evtWrapped = new ServletContextEvent(ctx);
            EventListener[] alisteners = listeners.listeners();
            int c = alisteners.length;
            for (int i = 0; i < c; ++i) {
                ServletContextListener listener = (ServletContextListener)alisteners[i];
                try {
                    listener.contextInitialized(evtWrapped);
                    continue;
                }
                catch (EventDeathException e) {
                    break;
                }
                catch (RuntimeException e) {
                    ctx.log(SessionHelper.PRODUCT_BANNER + ": ServletContextListener encountered an exception while initializating an application listener: " + listener.getClass().getName(), (Throwable)e);
                    if (eFirst != null) continue;
                    eFirst = e;
                }
            }
        }
        if (eFirst != null) {
            throw ServletContextListenerImpl.ensureRuntimeException((Throwable)eFirst);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextDestroyed(ServletContextEvent evt) {
        try {
            Listeners listeners;
            Exception eFirst = null;
            ServletContext ctx = this.getServletContext();
            if (ctx == null) {
                eFirst = this.init(evt);
                ctx = this.getServletContext();
                ServletContextListenerImpl.azzert((ctx != null ? 1 : 0) != 0);
            }
            if (!(listeners = this.getListeners()).isEmpty()) {
                ServletContextEvent evtWrapped = new ServletContextEvent(ctx);
                EventListener[] alisteners = listeners.listeners();
                for (int i = alisteners.length - 1; i >= 0; --i) {
                    ServletContextListener listener = (ServletContextListener)alisteners[i];
                    try {
                        listener.contextDestroyed(evtWrapped);
                        continue;
                    }
                    catch (EventDeathException e) {
                        break;
                    }
                    catch (RuntimeException e) {
                        ctx.log(SessionHelper.PRODUCT_BANNER + ": ServletContextListener encountered an exception while destroying an application listener: " + listener.getClass().getName(), (Throwable)e);
                        if (eFirst != null) continue;
                        eFirst = e;
                    }
                }
            }
            this.getSessionHelper().contextDestroyed();
            if (eFirst != null) {
                throw ServletContextListenerImpl.ensureRuntimeException((Throwable)eFirst);
            }
        }
        finally {
            this.m_listeners = null;
            this.m_ctx = null;
            this.m_helper = null;
        }
    }

    protected SessionHelper getSessionHelper() {
        return this.m_helper;
    }

    protected ServletContext getServletContext() {
        return this.m_ctx;
    }

    protected Listeners getListeners() {
        return this.m_listeners;
    }

    protected Exception init(ServletContextEvent evt) {
        if (this.m_ctx != null) {
            return null;
        }
        Exception eFirst = null;
        ServletContextListenerImpl.azzert((evt != null ? 1 : 0) != 0);
        ServletContextListenerImpl.azzert((evt.getServletContext() != null ? 1 : 0) != 0);
        ServletContext ctx = evt.getServletContext();
        SessionHelper helper = SessionHelperManager.ensureSessionHelper(ctx);
        ctx = SessionHelperManager.ensureWrappedServletContext(ctx);
        ServletContextListenerImpl.azzert((helper != null ? 1 : 0) != 0);
        ServletContextListenerImpl.azzert((ctx != null ? 1 : 0) != 0);
        Listeners listeners = new Listeners();
        String sListeners = ctx.getInitParameter("coherence-eventlisteners");
        if (sListeners != null) {
            String[] asListener = ServletContextListenerImpl.parseDelimitedString((String)sListeners, (char)',');
            int c = asListener.length;
            for (int i = 0; i < c; ++i) {
                String sListener = asListener[i].trim();
                if (sListener.length() <= 0) continue;
                try {
                    listeners.add((EventListener)Class.forName(sListener).newInstance());
                    continue;
                }
                catch (Exception e) {
                    ctx.log(SessionHelper.PRODUCT_BANNER + ": ServletContextListener encountered an exception while instantiating application listener class: " + sListener, (Throwable)e);
                    if (eFirst != null) continue;
                    eFirst = e;
                }
            }
        }
        helper.setListeners(listeners);
        Listeners listenersCtx = new Listeners();
        for (EventListener listener : listeners.listeners()) {
            if (!(listener instanceof ServletContextListener)) continue;
            listenersCtx.add(listener);
        }
        this.m_ctx = ctx;
        this.m_listeners = listenersCtx;
        this.m_helper = helper;
        return eFirst;
    }
}

