/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.servlet.api23;

import com.tangosol.coherence.servlet.SessionHelper;
import com.tangosol.coherence.servlet.SessionHelperManager;
import com.tangosol.util.Base;
import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class ServletWrapper
extends Base
implements Servlet {
    private SessionHelper m_helper;
    private ServletConfig m_cfg;
    private Servlet m_servlet;

    public void init(ServletConfig cfg) throws ServletException {
        Servlet servlet;
        SessionHelper helper;
        Base.azzert((cfg != null ? 1 : 0) != 0);
        String sClass = cfg.getInitParameter("coherence-servlet-class");
        if (sClass == null || (sClass = sClass.trim()).length() == 0) {
            throw new ServletException(SessionHelper.PRODUCT_BANNER + ": Servlet initialization could not proceed because the wrapped servlet class name was not available");
        }
        this.m_helper = helper = SessionHelperManager.ensureSessionHelper(cfg.getServletContext());
        this.m_cfg = helper.wrapServletConfig(cfg);
        try {
            servlet = (Servlet)Class.forName(sClass).newInstance();
        }
        catch (Throwable e) {
            throw new ServletException(SessionHelper.PRODUCT_BANNER + ": Servlet initialization encountered an exception while initializing the wrapped servlet class: " + sClass, e);
        }
        this.m_servlet = servlet;
        servlet.init(this.m_cfg);
        helper.servletInitialized();
    }

    public ServletConfig getServletConfig() {
        return this.m_cfg;
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        Servlet servlet = this.getServlet();
        if (servlet == null) {
            throw new ServletException(SessionHelper.PRODUCT_BANNER + ": Servlet execution could not proceed because the servlet has not been initialized yet");
        }
        this.getSessionHelper().service(servlet, req, res);
    }

    public String getServletInfo() {
        Servlet servlet = this.getServlet();
        String sInfo = servlet == null ? "Coherence ServletWrapper (uninitialized)" : servlet.getServletInfo();
        return sInfo + " (clustered by " + SessionHelper.PRODUCT_BANNER + ")";
    }

    public void destroy() {
        SessionHelper helper;
        Servlet servlet = this.getServlet();
        if (servlet != null) {
            servlet.destroy();
        }
        if ((helper = this.getSessionHelper()) != null) {
            helper.servletDestroyed();
        }
    }

    public String toString() {
        return "ServletWrapper (2.3)\n" + ServletWrapper.indentString((String)this.getDescription(), (String)"  ");
    }

    protected String getDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("SessionHelper").append(this.getSessionHelper() == null ? "==null" : "!=null").append("\nServlet=").append(ServletWrapper.indentString((String)String.valueOf(this.getServlet()), (String)"  ", (boolean)false)).append("\nServletConfig=").append(ServletWrapper.indentString((String)String.valueOf(this.getServletConfig()), (String)"  ", (boolean)false));
        return sb.toString();
    }

    protected Servlet getServlet() {
        return this.m_servlet;
    }

    protected SessionHelper getSessionHelper() {
        return this.m_helper;
    }
}

