/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.servlet.api24;

import com.tangosol.coherence.servlet.SessionHelper;
import com.tangosol.coherence.servlet.SessionHelperManager;
import com.tangosol.run.component.EventDeathException;
import com.tangosol.util.Base;
import com.tangosol.util.Listeners;
import java.util.EventListener;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestAttributeEvent;
import javax.servlet.ServletRequestAttributeListener;

public class ServletRequestAttributeListenerImpl
extends Base
implements ServletRequestAttributeListener {
    private SessionHelper m_helper;
    private ServletContext m_ctx;
    private Listeners m_listeners;

    public void attributeAdded(ServletRequestAttributeEvent evt) {
        this.dispatch(1, evt);
    }

    public void attributeRemoved(ServletRequestAttributeEvent evt) {
        this.dispatch(2, evt);
    }

    public void attributeReplaced(ServletRequestAttributeEvent evt) {
        this.dispatch(3, evt);
    }

    protected SessionHelper getSessionHelper() {
        return this.m_helper;
    }

    protected ServletContext getServletContext() {
        return this.m_ctx;
    }

    protected Listeners getListeners() {
        return this.m_listeners;
    }

    protected void init(ServletRequestAttributeEvent evt) {
        if (this.m_helper == null) {
            ServletContext ctxOrig = evt.getServletContext();
            SessionHelper helper = SessionHelperManager.ensureSessionHelper(ctxOrig);
            ServletContext ctx = SessionHelperManager.ensureWrappedServletContext(ctxOrig);
            Listeners listenersAll = helper.getListeners();
            EventListener[] alistenersAll = listenersAll.listeners();
            Listeners listeners = new Listeners();
            for (EventListener listener : alistenersAll) {
                if (!(listener instanceof ServletRequestAttributeListener)) continue;
                listeners.add(listener);
            }
            this.m_listeners = listeners;
            this.m_ctx = ctx;
            this.m_helper = helper;
        }
    }

    protected void dispatch(int nEvent, ServletRequestAttributeEvent evt) {
        this.init(evt);
        Listeners listeners = this.getListeners();
        if (!listeners.isEmpty()) {
            SessionHelper helper = this.getSessionHelper();
            ServletRequest req = helper.wrapServletRequest(evt.getServletRequest(), null);
            ServletContext ctx = this.getServletContext();
            evt = new ServletRequestAttributeEvent(ctx, req, evt.getName(), evt.getValue());
            RuntimeException eFirst = null;
            EventListener[] alisteners = listeners.listeners();
            int c = alisteners.length;
            for (int i = 0; i < c; ++i) {
                ServletRequestAttributeListener listener = (ServletRequestAttributeListener)alisteners[i];
                try {
                    switch (nEvent) {
                        case 1: {
                            listener.attributeAdded(evt);
                            break;
                        }
                        case 2: {
                            listener.attributeRemoved(evt);
                            break;
                        }
                        case 3: {
                            listener.attributeReplaced(evt);
                        }
                    }
                    continue;
                }
                catch (EventDeathException e) {
                    break;
                }
                catch (RuntimeException e) {
                    ctx.log(SessionHelper.PRODUCT_BANNER + ": ServletRequestAttributeListener encountered an exception while invoking an application listener: " + listener.getClass().getName(), (Throwable)e);
                    if (eFirst != null) continue;
                    eFirst = e;
                }
            }
            if (eFirst != null) {
                throw eFirst;
            }
        }
    }
}

