/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.servlet.api24;

import com.tangosol.coherence.servlet.SessionHelper;
import com.tangosol.coherence.servlet.SessionHelperManager;
import com.tangosol.coherence.servlet.api23.HttpServletRequestWrapper;
import com.tangosol.run.component.EventDeathException;
import com.tangosol.util.Base;
import com.tangosol.util.Listeners;
import java.util.EventListener;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class ServletRequestListenerImpl
extends Base
implements ServletRequestListener {
    public static final int EVT_INITIALIZED = 1;
    public static final int EVT_DESTROYED = 2;
    private SessionHelper m_helper;
    private ServletContext m_ctx;
    private Listeners m_listeners;

    public void requestInitialized(ServletRequestEvent evt) {
        this.dispatch(1, evt);
    }

    public void requestDestroyed(ServletRequestEvent evt) {
        this.dispatch(2, evt);
    }

    protected SessionHelper getSessionHelper() {
        return this.m_helper;
    }

    protected ServletContext getServletContext() {
        return this.m_ctx;
    }

    protected Listeners getListeners() {
        return this.m_listeners;
    }

    protected void init(ServletRequestEvent evt) {
        if (this.m_helper == null) {
            ServletContext ctxOrig = evt.getServletContext();
            SessionHelper helper = SessionHelperManager.ensureSessionHelper(ctxOrig);
            ServletContext ctx = SessionHelperManager.ensureWrappedServletContext(ctxOrig);
            Listeners listenersAll = helper.getListeners();
            EventListener[] alistenersAll = listenersAll.listeners();
            Listeners listeners = new Listeners();
            for (EventListener listener : alistenersAll) {
                if (!(listener instanceof ServletRequestListener)) continue;
                listeners.add(listener);
            }
            this.m_listeners = listeners;
            this.m_ctx = ctx;
            this.m_helper = helper;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatch(int nEvent, ServletRequestEvent evt) {
        this.init(evt);
        Listeners listeners = this.getListeners();
        if (!listeners.isEmpty()) {
            SessionHelper helper = this.getSessionHelper();
            ServletRequest req = helper.wrapServletRequest(evt.getServletRequest(), null);
            ServletContext ctx = this.getServletContext();
            evt = new ServletRequestEvent(ctx, req);
            if (req instanceof HttpServletRequest) {
                String sId = ((HttpServletRequest)req).getRequestedSessionId();
                helper.enterSession(sId);
            }
            try {
                RuntimeException eFirst = null;
                EventListener[] alisteners = listeners.listeners();
                int c = alisteners.length;
                for (int i = 0; i < c; ++i) {
                    ServletRequestListener listener = (ServletRequestListener)alisteners[i];
                    try {
                        switch (nEvent) {
                            case 1: {
                                listener.requestInitialized(evt);
                                break;
                            }
                            case 2: {
                                listener.requestDestroyed(evt);
                            }
                        }
                        continue;
                    }
                    catch (EventDeathException e) {
                        break;
                    }
                    catch (RuntimeException e) {
                        ctx.log(SessionHelper.PRODUCT_BANNER + ": ServletRequestListener encountered an exception while invoking an application listener: " + listener.getClass().getName(), (Throwable)e);
                        if (eFirst != null) continue;
                        eFirst = e;
                    }
                }
                if (eFirst != null) {
                    throw eFirst;
                }
            }
            finally {
                HttpSession session;
                if (req instanceof HttpServletRequestWrapper && (session = ((HttpServletRequestWrapper)req).getSession(false, false)) != null) {
                    helper.exitSession(session.getId(), session.isNew());
                }
            }
        }
    }
}

