/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.servlet.commonj.impl;

import com.tangosol.coherence.servlet.commonj.Work;
import com.tangosol.coherence.servlet.commonj.WorkException;
import com.tangosol.coherence.servlet.commonj.WorkItem;
import com.tangosol.coherence.servlet.commonj.WorkListener;
import com.tangosol.coherence.servlet.commonj.WorkManager;
import com.tangosol.coherence.servlet.commonj.impl.WorkItemImpl;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class WorkManagerImpl
implements WorkManager {
    private static final int DEFAULT_NR_OF_THREADS = 10;
    private final ExecutorService mExecutor;

    public WorkManagerImpl() {
        this(10, 10);
    }

    public WorkManagerImpl(int minThreads, int maxThreads) {
        this(minThreads, maxThreads, Integer.MAX_VALUE);
    }

    public WorkManagerImpl(int minThreads, int maxThreads, int maxQueueSize) {
        this(new ThreadPoolExecutor(minThreads, maxThreads, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(maxQueueSize), new ThreadPoolExecutor.CallerRunsPolicy()));
    }

    public WorkManagerImpl(ExecutorService executor) {
        this.mExecutor = executor;
    }

    @Override
    public WorkItem schedule(Work work) throws WorkException, IllegalArgumentException {
        return this.schedule(work, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WorkItem schedule(Work work, WorkListener listener) throws WorkException, IllegalArgumentException {
        WorkItemImpl item = new WorkItemImpl(work, listener);
        try {
            WorkItemImpl workItemImpl = item;
            synchronized (workItemImpl) {
                this.mExecutor.execute(item);
                item.setStatus(1);
            }
        }
        catch (Exception t) {
            item.setStatus(3);
            throw new WorkException("Failed to schedule work.", t);
        }
        return item;
    }

    @Override
    public boolean shutdown(long timeout) {
        this.mExecutor.shutdown();
        try {
            return this.mExecutor.awaitTermination(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            return false;
        }
    }
}

