/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.servlet.management;

import com.tangosol.coherence.servlet.AbstractHttpSessionCollection;
import com.tangosol.coherence.servlet.HttpSessionCollection;
import com.tangosol.coherence.servlet.SessionHelper;
import com.tangosol.coherence.servlet.SessionHelperFactory;
import com.tangosol.coherence.servlet.SessionReaperStatistics;
import com.tangosol.coherence.servlet.SplitHttpSessionCollection;
import com.tangosol.coherence.servlet.management.HttpSessionManagerMBean;
import com.tangosol.net.NamedCache;
import com.tangosol.util.Base;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.Map;
import javax.servlet.ServletContext;

public class HttpSessionManager
extends Base
implements HttpSessionManagerMBean {
    private SessionHelper m_helper;
    private SessionReaperStatistics m_reaperStatistics;

    public HttpSessionManager(SessionHelper helper, SessionReaperStatistics reaperStatistics) {
        HttpSessionManager.azzert((helper != null ? 1 : 0) != 0, (String)"SessionHelper cannot be null.");
        this.m_helper = helper;
        this.m_reaperStatistics = reaperStatistics;
    }

    @Override
    public long getAverageReapDuration() {
        return this.m_reaperStatistics.getAverageReapDuration();
    }

    @Override
    public long getAverageReapedSessions() {
        return this.m_reaperStatistics.getAverageReapedSessions();
    }

    @Override
    public String getCollectionClassName() {
        AbstractHttpSessionCollection coll = this.getAbstractHttpSessionCollection();
        return coll == null ? null : coll.getClass().getName();
    }

    @Override
    public String getFactoryClassName() {
        SessionHelperFactory factory = this.getSessionFactory();
        return factory == null ? null : factory.getClass().getName();
    }

    @Override
    public long getLastReapDuration() {
        return this.m_reaperStatistics.getLastReapDuration();
    }

    @Override
    public Date getLastReapCycle() {
        return this.createDateOrNull(this.m_reaperStatistics.getLastReapTime());
    }

    @Override
    public String getLocalAttributeCacheName() {
        NamedCache cache;
        AbstractHttpSessionCollection coll = this.getAbstractHttpSessionCollection();
        if (coll != null && (cache = coll.getLocalAttributesCache()) != null) {
            return cache.getCacheName();
        }
        return null;
    }

    @Override
    public int getLocalAttributeCount() {
        NamedCache cache;
        AbstractHttpSessionCollection coll = this.getAbstractHttpSessionCollection();
        if (coll != null && (cache = coll.getLocalAttributesCache()) != null) {
            int cAttr = 0;
            try {
                for (Map mapAttr : cache.values()) {
                    if (mapAttr == null) continue;
                    cAttr += mapAttr.size();
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                // empty catch block
            }
            return cAttr;
        }
        return -1;
    }

    @Override
    public String getLocalSessionCacheName() {
        NamedCache cache;
        AbstractHttpSessionCollection coll = this.getAbstractHttpSessionCollection();
        if (coll != null && (cache = coll.getLocalCache()) != null) {
            return cache.getCacheName();
        }
        return null;
    }

    @Override
    public int getLocalSessionCount() {
        NamedCache cache;
        AbstractHttpSessionCollection coll = this.getAbstractHttpSessionCollection();
        if (coll != null && (cache = coll.getLocalCache()) != null) {
            return cache.size();
        }
        return -1;
    }

    @Override
    public long getMaxReapDuration() {
        return this.m_reaperStatistics.getMaxReapDuration();
    }

    @Override
    public long getMaxReapedSessions() {
        return this.m_reaperStatistics.getMaxReapedSessions();
    }

    @Override
    public Date getNextReapCycle() {
        return this.createDateOrNull(this.m_reaperStatistics.getNextReapTime());
    }

    @Override
    public int getOverflowAverageSize() {
        SplitHttpSessionCollection coll = this.getSplitHttpSessionCollection();
        return coll == null ? -1 : coll.getAverageExternalAttributeSize();
    }

    @Override
    public String getOverflowCacheName() {
        NamedCache cache;
        SplitHttpSessionCollection coll = this.getSplitHttpSessionCollection();
        if (coll != null && (cache = coll.getExternalAttributeCache()) != null) {
            return cache.getCacheName();
        }
        return null;
    }

    @Override
    public int getOverflowMaxSize() {
        SplitHttpSessionCollection coll = this.getSplitHttpSessionCollection();
        return coll == null ? -1 : coll.getMaxExternalAttributeSize();
    }

    @Override
    public int getOverflowThreshold() {
        SplitHttpSessionCollection coll = this.getSplitHttpSessionCollection();
        return coll == null ? -1 : coll.getMinExternalAttributeSize();
    }

    @Override
    public int getOverflowUpdates() {
        SplitHttpSessionCollection coll = this.getSplitHttpSessionCollection();
        return coll == null ? -1 : coll.getExternalAttributeUpdates();
    }

    @Override
    public long getReapedSessions() {
        return this.m_reaperStatistics.getReapedSessions();
    }

    @Override
    public long getReapedSessionsTotal() {
        return this.m_reaperStatistics.getTotalReapedSessions();
    }

    @Override
    public int getSessionAverageLifetime() {
        AbstractHttpSessionCollection coll = this.getAbstractHttpSessionCollection();
        return coll == null ? -1 : coll.getAverageModelLifetime();
    }

    @Override
    public int getSessionAverageSize() {
        AbstractHttpSessionCollection coll = this.getAbstractHttpSessionCollection();
        return coll == null ? -1 : coll.getAverageModelSize();
    }

    @Override
    public String getSessionCacheName() {
        NamedCache cache;
        AbstractHttpSessionCollection coll = this.getAbstractHttpSessionCollection();
        if (coll != null && (cache = coll.getClusterCache()) != null) {
            return cache.getCacheName();
        }
        return null;
    }

    @Override
    public int getSessionIdLength() {
        AbstractHttpSessionCollection coll = this.getAbstractHttpSessionCollection();
        return coll == null ? -1 : coll.getSessionIdLength();
    }

    @Override
    public int getSessionMaxSize() {
        AbstractHttpSessionCollection coll = this.getAbstractHttpSessionCollection();
        return coll == null ? -1 : coll.getMaxModelSize();
    }

    @Override
    public int getSessionMinSize() {
        AbstractHttpSessionCollection coll = this.getAbstractHttpSessionCollection();
        return coll == null ? -1 : coll.getMinModelSize();
    }

    @Override
    public int getSessionStickyCount() {
        NamedCache cache;
        AbstractHttpSessionCollection coll = this.getAbstractHttpSessionCollection();
        if (coll != null && (cache = coll.getStickyCache()) != null) {
            return cache.size();
        }
        return -1;
    }

    @Override
    public int getSessionTimeout() {
        AbstractHttpSessionCollection coll = this.getAbstractHttpSessionCollection();
        return coll == null ? -1 : coll.getDefaultMaxInactiveInterval();
    }

    @Override
    public int getSessionUpdates() {
        AbstractHttpSessionCollection coll = this.getAbstractHttpSessionCollection();
        return coll == null ? -1 : coll.getModelUpdates();
    }

    @Override
    public String getServletContextCacheName() {
        NamedCache cache = this.getSessionHelper().getServletContextAttributeCache();
        return cache == null ? null : cache.getCacheName();
    }

    @Override
    public String getServletContextName() {
        ServletContext ctx = this.getSessionHelper().getServletContext();
        return ctx == null ? null : ctx.getServletContextName();
    }

    @Override
    public void resetStatistics() {
        AbstractHttpSessionCollection coll = this.getAbstractHttpSessionCollection();
        if (coll != null) {
            coll.resetStatistics();
        }
        this.m_reaperStatistics.resetStatistics();
    }

    @Override
    public void clearStoredConfiguration() {
        this.m_helper.clearStoredConfiguration();
    }

    protected SessionHelper getSessionHelper() {
        return this.m_helper;
    }

    protected SessionHelperFactory getSessionFactory() {
        return this.getSessionHelper().getFactory();
    }

    protected AbstractHttpSessionCollection getAbstractHttpSessionCollection() {
        HttpSessionCollection coll = this.getSessionHelper().getHttpSessionCollection();
        return coll instanceof AbstractHttpSessionCollection ? (AbstractHttpSessionCollection)coll : null;
    }

    protected SplitHttpSessionCollection getSplitHttpSessionCollection() {
        HttpSessionCollection coll = this.getSessionHelper().getHttpSessionCollection();
        return coll instanceof SplitHttpSessionCollection ? (SplitHttpSessionCollection)coll : null;
    }

    public String toString() {
        return "HttpSessionManager(" + "ServetContext=" + this.getSessionHelper().getServletContext() + ")";
    }

    private Date createDateOrNull(long d) {
        return d <= 0L ? null : new Date(d);
    }
}

