/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.servlet.tomcat55;

import com.tangosol.coherence.servlet.SessionHelper;
import com.tangosol.coherence.servlet.SessionHelperFactory;
import com.tangosol.net.cache.LocalCache;
import com.tangosol.util.ClassHelper;
import java.lang.management.ManagementFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CookieHelper
extends SessionHelper {
    protected static final char SUFFIX_SEPARATOR = '.';
    private static final Logger LOGGER = Logger.getLogger(CookieHelper.class.getName());
    private LocalCache m_cacheFailover = new LocalCache(128);
    private String m_sAffinitySuffix;
    private String m_sConfiguredJvmRoute;

    public CookieHelper(SessionHelperFactory factory, ServletContext ctx) {
        this(factory, ctx, null);
    }

    public CookieHelper(SessionHelperFactory factory, ServletContext ctx, String sJvmRoute) {
        super(factory, ctx);
        this.m_sConfiguredJvmRoute = sJvmRoute;
    }

    @Override
    protected void configure() {
        super.configure();
        this.configureAffinitySuffix();
    }

    @Override
    public String decodeCookie(HttpServletRequest req) {
        int ofSeparator;
        String sSessionId = super.decodeCookie(req);
        if (sSessionId != null && (ofSeparator = sSessionId.indexOf(46)) >= 0) {
            String sServerSuffix = this.getAffinitySuffix();
            String sSessionSuffix = sSessionId.substring(ofSeparator);
            sSessionId = sSessionId.substring(0, ofSeparator);
            if (!sSessionSuffix.equals(sServerSuffix)) {
                this.m_cacheFailover.put((Object)sSessionId, (Object)sSessionSuffix);
            }
        }
        return sSessionId;
    }

    @Override
    public void encodeCookie(HttpServletRequest req, HttpServletResponse resp, String sId, boolean fNew) {
        if (this.m_cacheFailover.remove((Object)sId) != null) {
            fNew = true;
        }
        String sSessionId = sId + this.getAffinitySuffix();
        super.encodeCookie(req, resp, sSessionId, fNew);
    }

    @Override
    public String decodeUrl(HttpServletRequest request) {
        int ofSeparator;
        String sSessionId = super.decodeUrl(request);
        if (sSessionId != null && (ofSeparator = sSessionId.indexOf(46)) >= 0) {
            sSessionId = sSessionId.substring(0, ofSeparator);
        }
        return sSessionId;
    }

    @Override
    protected String encodeUrl(String sUrl, String sId) {
        return super.encodeUrl(sUrl, sId + this.getAffinitySuffix());
    }

    protected String getJvmRouteViaJmx() {
        boolean fOnJBoss = false;
        MBeanServer mbs = null;
        try {
            Class<?> clz = Class.forName("org.jboss.mx.util.MBeanServerLocator");
            mbs = (MBeanServer)ClassHelper.invokeStatic(clz, (String)"locateJBoss", (Object[])new Object[0]);
            fOnJBoss = true;
        }
        catch (Exception clz) {
            // empty catch block
        }
        if (mbs == null) {
            mbs = ManagementFactory.getPlatformMBeanServer();
        }
        String sJvmRouteJmxQuery = fOnJBoss ? "jboss.web:type=Engine" : "Catalina:type=Engine";
        Object oJvmRoute = null;
        try {
            oJvmRoute = mbs.getAttribute(new ObjectName(sJvmRouteJmxQuery), "jvmRoute");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return oJvmRoute instanceof String ? (String)oJvmRoute : null;
    }

    protected void configureAffinitySuffix() {
        String sJvmRoute = this.m_sConfiguredJvmRoute;
        if (sJvmRoute == null) {
            sJvmRoute = this.getJvmRouteViaJmx();
        }
        if (sJvmRoute == null) {
            this.m_sAffinitySuffix = "";
            LOGGER.log(Level.INFO, "The jvmRoute setting is not configured");
        } else {
            this.m_sAffinitySuffix = '.' + sJvmRoute;
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, "Configured affinity suffix: " + sJvmRoute);
            }
        }
    }

    public String getAffinitySuffix() {
        return this.m_sAffinitySuffix;
    }
}

