/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.cos.security;

import java.io.ByteArrayInputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;

public class GSSUtil {
    private static final boolean DEBUG = false;
    static final byte[] encodedGSSNTOID = new byte[]{6, 6, 43, 6, 1, 5, 6, 4};
    static final byte[] encodedGSSUPOID = new byte[]{6, 6, 103, -127, 2, 1, 1, 1};
    private static final int HIGH_BIT = 128;

    public static byte[] createGSSUPGSSNTExportedName(String str) {
        byte[] name = str.getBytes();
        int exportedLen = 4 + encodedGSSUPOID.length + 4 + name.length;
        byte[] exportedName = new byte[exportedLen];
        int i = 0;
        exportedName[i++] = 4;
        exportedName[i++] = 1;
        exportedName[i++] = (byte)(encodedGSSUPOID.length >>> 8);
        exportedName[i++] = (byte)(encodedGSSUPOID.length >>> 0);
        System.arraycopy(encodedGSSUPOID, 0, exportedName, i, encodedGSSUPOID.length);
        i += encodedGSSUPOID.length;
        exportedName[i++] = (byte)(name.length >>> 24);
        exportedName[i++] = (byte)(name.length >>> 16);
        exportedName[i++] = (byte)(name.length >>> 8);
        exportedName[i++] = (byte)(name.length >>> 0);
        System.arraycopy(name, 0, exportedName, i, name.length);
        return exportedName;
    }

    public static String extractGSSUPGSSNTExportedName(byte[] exportedName) {
        int exportedNameLength = exportedName.length;
        if (exportedName[0] != 4 || exportedName[1] != 1) {
            return null;
        }
        int mechLength = (exportedName[2] & 0xFF) << 8 | exportedName[3] & 0xFF;
        if (mechLength != encodedGSSUPOID.length) {
            return null;
        }
        byte[] mechOID = new byte[mechLength];
        System.arraycopy(exportedName, 4, mechOID, 0, mechLength);
        if (!Arrays.equals(mechOID, encodedGSSUPOID)) {
            return null;
        }
        int i = 4 + encodedGSSUPOID.length;
        int nameLength = (exportedName[i] & 0xFF) << 24 | (exportedName[i + 1] & 0xFF) << 16 | (exportedName[i + 2] & 0xFF) << 8 | exportedName[i + 3] & 0xFF;
        byte[] extractedName = new byte[nameLength];
        System.arraycopy(exportedName, i += 4, extractedName, 0, nameLength);
        return new String(extractedName);
    }

    public static byte[] getGSSUPMech() {
        return encodedGSSUPOID;
    }

    public static boolean isGSSUPMech(byte[] mech) {
        return Arrays.equals(mech, GSSUtil.getGSSUPMech());
    }

    public static byte[] getGSSUPToken(byte[] innerToken) {
        byte[] mechGSSUP = GSSUtil.getGSSUPMech();
        int tokenLen = mechGSSUP.length + innerToken.length;
        int tokenDERNumOctets = GSSUtil.getDERNumOctets(tokenLen);
        int gssTokenLen = 1 + tokenDERNumOctets + mechGSSUP.length + innerToken.length;
        byte[] gssToken = new byte[gssTokenLen];
        int i = 0;
        gssToken[i++] = 96;
        if (tokenLen < 128) {
            gssToken[i++] = (byte)tokenLen;
        } else {
            gssToken[i++] = (byte)(tokenDERNumOctets + 127);
            switch (tokenDERNumOctets) {
                case 2: {
                    gssToken[i++] = (byte)(tokenLen & 0xFF);
                    break;
                }
                case 3: {
                    gssToken[i++] = (byte)(tokenLen >> 8 & 0xFF);
                    gssToken[i++] = (byte)(tokenLen & 0xFF);
                    break;
                }
                case 4: {
                    gssToken[i++] = (byte)(tokenLen >> 16 & 0xFF);
                    gssToken[i++] = (byte)(tokenLen >> 8 & 0xFF);
                    gssToken[i++] = (byte)(tokenLen & 0xFF);
                    break;
                }
                case 5: {
                    gssToken[i++] = (byte)(tokenLen >> 24);
                    gssToken[i++] = (byte)(tokenLen >> 16 & 0xFF);
                    gssToken[i++] = (byte)(tokenLen >> 8 & 0xFF);
                    gssToken[i++] = (byte)(tokenLen & 0xFF);
                }
            }
        }
        System.arraycopy(mechGSSUP, 0, gssToken, i, mechGSSUP.length);
        System.arraycopy(innerToken, 0, gssToken, i += mechGSSUP.length, innerToken.length);
        return gssToken;
    }

    private static int getDERNumOctets(int length) {
        if (length < 128) {
            return 1;
        }
        if (length < 256) {
            return 2;
        }
        if (length < 65536) {
            return 3;
        }
        if (length < 0x1000000) {
            return 4;
        }
        return 5;
    }

    public static byte[] getGSSUPInnerToken(byte[] gssToken) {
        int i = 0;
        int maxIdx = gssToken.length;
        if (gssToken.length < 6 || gssToken[i++] != 96) {
            return null;
        }
        int tokenLen = 0;
        if (!GSSUtil.isHighBitSet(gssToken[i])) {
            tokenLen = gssToken[i++];
        } else {
            int numOctets = gssToken[i++] & 0x7F;
            switch (numOctets) {
                case 1: {
                    tokenLen = gssToken[i++] & 0xFF;
                    break;
                }
                case 2: {
                    tokenLen = gssToken[i++] << 8 & 0xFF00 | gssToken[i++] & 0xFF;
                    break;
                }
                case 3: {
                    tokenLen = gssToken[i++] << 16 & 0xFF0000 | gssToken[i++] << 8 & 0xFF00 | gssToken[i++] & 0xFF;
                    break;
                }
                case 4: {
                    tokenLen = gssToken[i++] << 24 & 0xFF000000 | gssToken[i++] << 16 & 0xFF0000 | gssToken[i++] << 8 & 0xFF00 | gssToken[i++] & 0xFF;
                }
            }
        }
        for (int j = 0; j < encodedGSSUPOID.length; ++j) {
            if (i >= maxIdx || encodedGSSUPOID[j] != gssToken[i]) {
                return null;
            }
            ++i;
        }
        byte[] innerToken = new byte[maxIdx - i];
        System.arraycopy(gssToken, i, innerToken, 0, maxIdx - i);
        return innerToken;
    }

    public static X509Certificate[] getX509CertChain(byte[] sequence) {
        int i = 0;
        if (sequence == null || sequence.length < 2 || sequence[i++] != 48) {
            return null;
        }
        int tokenLen = 0;
        if (!GSSUtil.isHighBitSet(sequence[i])) {
            tokenLen = sequence[i++];
        } else {
            int numOctets = sequence[i++] & 0x7F;
            switch (numOctets) {
                case 1: {
                    tokenLen = sequence[i++] & 0xFF;
                    break;
                }
                case 2: {
                    tokenLen = sequence[i++] << 8 & 0xFF00 | sequence[i++] & 0xFF;
                    break;
                }
                case 3: {
                    tokenLen = sequence[i++] << 16 & 0xFF0000 | sequence[i++] << 8 & 0xFF00 | sequence[i++] & 0xFF;
                    break;
                }
                case 4: {
                    tokenLen = sequence[i++] << 24 & 0xFF000000 | sequence[i++] << 16 & 0xFF0000 | sequence[i++] << 8 & 0xFF00 | sequence[i++] & 0xFF;
                }
            }
        }
        if (tokenLen != sequence.length - i) {
            return null;
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(sequence, i, tokenLen);
        ArrayList<Certificate> list = new ArrayList<Certificate>();
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            while (bis.available() > 0) {
                list.add(cf.generateCertificate(bis));
            }
        }
        catch (CertificateException e) {
            return null;
        }
        return list.toArray(new X509Certificate[list.size()]);
    }

    private static boolean isHighBitSet(byte b) {
        return (b & 0x80) == 128;
    }

    public static String getQuotedGSSUserName(String userName) {
        String quotedUserName = userName;
        int i = userName.indexOf(64);
        if (i < 0) {
            return quotedUserName;
        }
        StringBuffer strBuf = new StringBuffer();
        if (i > 0) {
            strBuf.append(userName.substring(0, i));
        }
        strBuf.append('\\');
        strBuf.append('@');
        strBuf.append(userName.substring(i + 1));
        quotedUserName = strBuf.toString();
        return quotedUserName;
    }

    public static String getUnquotedGSSUserName(String userName) {
        String unQuotedUserName = userName;
        int idx = userName.indexOf(92);
        if (idx < 0) {
            return unQuotedUserName;
        }
        StringBuffer strBuf = new StringBuffer();
        if (idx > 0) {
            strBuf.append(userName.substring(0, idx));
        }
        strBuf.append(userName.substring(idx + 1));
        unQuotedUserName = strBuf.toString();
        return unQuotedUserName;
    }

    private static void p(String msg) {
        System.out.println("<GSSUtil>: " + msg);
    }
}

