/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.policies;

import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import org.omg.Messaging.RequestEndTimePolicy;
import org.omg.TimeBase.UtcT;
import org.omg.TimeBase.UtcTHelper;
import weblogic.corba.policies.PolicyImpl;
import weblogic.iiop.protocol.CorbaInputStream;
import weblogic.iiop.protocol.CorbaOutputStream;

public class RequestEndTimePolicyImpl
extends PolicyImpl
implements RequestEndTimePolicy {
    private UtcT endTime;
    public static final long UNITS_PER_MILLI = 10000L;
    private static final long UTCT_DELTA_MILLIS = 12219292800000L;

    public static final long java2Utc(long time) {
        return (time + 12219292800000L) * 10000L;
    }

    public static final long utc2Java(long utct) {
        return utct / 10000L - 12219292800000L;
    }

    public RequestEndTimePolicyImpl(long time) {
        super(28, 0);
        this.endTime = new UtcT(RequestEndTimePolicyImpl.java2Utc(time), 0, 0, 0);
    }

    public RequestEndTimePolicyImpl(UtcT time) {
        super(28, 0);
        this.endTime = new UtcT(time.time, time.inacclo, time.inacchi, time.tdf);
    }

    public RequestEndTimePolicyImpl(CorbaInputStream in) {
        super(28, 0);
        this.read(in);
    }

    public UtcT end_time() {
        return this.endTime;
    }

    public long endTime() {
        return RequestEndTimePolicyImpl.utc2Java(this.endTime.time);
    }

    public long relativeTimeoutMillis() {
        long rt = RequestEndTimePolicyImpl.utc2Java(this.endTime.time) - System.currentTimeMillis();
        return rt < 0L ? 0L : rt;
    }

    @Override
    protected void readEncapsulatedPolicy(CorbaInputStream in) {
        this.endTime = UtcTHelper.read((InputStream)in);
    }

    @Override
    protected void writeEncapsulatedPolicy(CorbaOutputStream out) {
        UtcTHelper.write((OutputStream)out, (UtcT)this.endTime);
    }
}

