/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.utils;

import java.io.Externalizable;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.rmi.RemoteException;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.IDLEntity;
import weblogic.corba.utils.CorbaUtilsDelegate;
import weblogic.corba.utils.RepositoryId;
import weblogic.utils.LocatorUtilities;

public class CorbaUtils {
    private static final String WEBLOGIC_OMG_JAVA_PREFIX = "weblogic.corba.idl.";
    private static final String USER_EX = "Ex";
    public static final String USER_EX_SUFFIX = "ception";
    public static final String USER_EXCEPTION = "Exception";
    static final String OMG_JAVA_PREFIX = "org.omg.";
    static final String OMG_IDL_PREFIX = "IDL:omg.org/";
    public static final String IDL_PREFIX = "IDL:";

    static String getAnnotation(ClassLoader loadingContext) {
        return Singleton.instance.getAnnotation(loadingContext);
    }

    static boolean isIDLInterface(Class c) {
        return Object.class.isAssignableFrom(c) && IDLEntity.class.isAssignableFrom(c);
    }

    public static String createIDFromIDLEntity(Class c) {
        String name = c.getName();
        String typeid = name.startsWith(OMG_JAVA_PREFIX) ? OMG_IDL_PREFIX + name.substring(OMG_JAVA_PREFIX.length()).replace('.', '/') + ":1.0" : IDL_PREFIX + c.getName().replace('.', '/') + ":1.0";
        return typeid;
    }

    public static Class getClassFromID(RepositoryId repid) {
        return CorbaUtils.getClassFromID(repid, null);
    }

    public static Class getClassFromID(RepositoryId repid, String codebase) {
        Class ret;
        block12: {
            ret = RepositoryId.PRIMITIVE_MAP.get(repid);
            if (ret != null) {
                return ret;
            }
            String cname = repid.getClassName();
            CorbaUtils.verifyClassPermitted(cname);
            int idx = 0;
            try {
                ret = CorbaUtils.loadClass(cname, codebase, null);
            }
            catch (ClassNotFoundException cnfe) {
                if (cname.endsWith(USER_EX) && (cname = cname + USER_EX_SUFFIX) != null) {
                    try {
                        ret = CorbaUtils.loadClass(cname, codebase, null);
                    }
                    catch (ClassNotFoundException cnfe2) {
                        cname = cname.substring(0, cname.length() - USER_EXCEPTION.length());
                        try {
                            ret = CorbaUtils.loadClass(cname, codebase, null);
                            break block12;
                        }
                        catch (ClassNotFoundException classNotFoundException) {}
                    }
                }
                idx = cname.lastIndexOf(46);
                if (idx < 0) break block12;
                String newcname = cname.substring(0, idx) + "Package" + cname.substring(idx);
                try {
                    ret = CorbaUtils.loadClass(newcname, codebase, null);
                }
                catch (ClassNotFoundException cnfe3) {
                    if (!cname.startsWith(OMG_JAVA_PREFIX) || (cname = WEBLOGIC_OMG_JAVA_PREFIX + cname) == null) break block12;
                    try {
                        ret = CorbaUtils.loadClass(cname);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
            }
        }
        return ret;
    }

    public static void verifyClassPermitted(String className) {
        if (className == null) {
            throw new IllegalArgumentException("No class name found");
        }
        Singleton.instance.verifyClassPermitted(className);
    }

    public static Class loadClass(String className) throws ClassNotFoundException {
        return CorbaUtils.loadClass(className, null, null);
    }

    public static Class loadClass(String className, String remoteCodebase, ClassLoader loadingContext) throws ClassNotFoundException {
        return Singleton.instance.loadClass(className, remoteCodebase, loadingContext);
    }

    public static boolean isAbstractInterface(Class c) {
        boolean result;
        block3: {
            result = false;
            if (CorbaUtils.isValid(c) && !CorbaUtils.isARemote(c) && !CorbaUtils.isRemote(c) && !Serializable.class.equals((java.lang.Object)c)) {
                Method[] m;
                for (Method aM : m = c.getMethods()) {
                    if (CorbaUtils.methodThrowsRemoteException(aM)) {
                        continue;
                    }
                    break block3;
                }
                result = true;
            }
        }
        return result;
    }

    public static boolean isValid(Class c) {
        boolean result = true;
        if (String.class.equals((java.lang.Object)c) || RemoteException.class.equals((java.lang.Object)c) || c.isPrimitive() || IDLEntity.class.equals((java.lang.Object)c) || Void.TYPE.equals(c) || Externalizable.class.equals((java.lang.Object)c)) {
            result = false;
        }
        return result;
    }

    public static boolean isRemote(Class c) {
        return Remote.class.equals((java.lang.Object)c);
    }

    public static boolean isARemote(Class c) {
        return !CorbaUtils.isRemote(c) && Remote.class.isAssignableFrom(c);
    }

    private static boolean methodThrowsRemoteException(Method m) {
        Class<?>[] ex;
        for (Class<RemoteException> clazz : ex = m.getExceptionTypes()) {
            if (!clazz.isAssignableFrom(RemoteException.class)) continue;
            return true;
        }
        return false;
    }

    private static class Singleton {
        private static final CorbaUtilsDelegate instance = (CorbaUtilsDelegate)LocatorUtilities.getService(CorbaUtilsDelegate.class);

        private Singleton() {
        }
    }
}

