/*
 * Decompiled with CFR 0.152.
 */
package weblogic.iiop.ior;

import weblogic.corba.cos.security.GSSUtil;
import weblogic.iiop.ior.CompoundSecMech;
import weblogic.iiop.ior.TaggedComponent;
import weblogic.iiop.protocol.CorbaInputStream;
import weblogic.iiop.protocol.CorbaOutputStream;
import weblogic.protocol.ServerIdentity;

public class CompoundSecMechList
extends TaggedComponent {
    private boolean statefulContext = true;
    private int numSecMechs = 0;
    private CompoundSecMech[] secMechs;

    public CompoundSecMechList(boolean statefulContext, CompoundSecMech ... secMechs) {
        super(33);
        this.secMechs = secMechs;
        this.statefulContext = statefulContext;
        this.numSecMechs = this.secMechs.length;
    }

    public CompoundSecMechList(CorbaInputStream in, ServerIdentity target) {
        super(33);
        this.read(in, target);
    }

    public final CompoundSecMech[] getCompoundSecMechs() {
        return this.secMechs;
    }

    public final boolean useSAS() {
        for (int i = 0; i < this.numSecMechs; ++i) {
            if (!this.secMechs[i].useSAS()) continue;
            return true;
        }
        return false;
    }

    public final boolean hasGSSUP() {
        for (int i = 0; i < this.numSecMechs; ++i) {
            if (!this.secMechs[i].hasGSSUP()) continue;
            return true;
        }
        return false;
    }

    public final boolean hasGSSUPIdentity() {
        for (int i = 0; i < this.numSecMechs; ++i) {
            if (!this.secMechs[i].hasGSSUPIdentity()) continue;
            return true;
        }
        return false;
    }

    public final byte[] getGSSUPTarget() {
        for (int i = 0; i < this.numSecMechs; ++i) {
            byte[] target;
            if (!this.secMechs[i].hasGSSUP() || (target = this.secMechs[i].getGSSUPTarget()) == null) continue;
            return target;
        }
        return null;
    }

    public final boolean isGSSUPTargetStateful() {
        return this.statefulContext;
    }

    public final String getSecureHost() {
        for (int i = 0; i < this.numSecMechs; ++i) {
            String host = this.secMechs[i].getSecureHost();
            if (host == null) continue;
            return host;
        }
        return null;
    }

    public final int getSecurePort() {
        for (int i = 0; i < this.numSecMechs; ++i) {
            int port = this.secMechs[i].getSecurePort();
            if (port == -1) continue;
            return port;
        }
        return -1;
    }

    public final void read(CorbaInputStream in, ServerIdentity target) {
        long handle = in.startEncapsulation();
        this.statefulContext = in.read_boolean();
        this.numSecMechs = in.read_long();
        this.secMechs = new CompoundSecMech[this.numSecMechs];
        for (int i = 0; i < this.numSecMechs; ++i) {
            this.secMechs[i] = new CompoundSecMech(in, target);
        }
        in.endEncapsulation(handle);
    }

    @Override
    public final void write(CorbaOutputStream out) {
        out.write_long(this.tag);
        long handle = out.startEncapsulation();
        out.write_boolean(this.statefulContext);
        out.write_long(this.numSecMechs);
        for (int i = 0; i < this.numSecMechs; ++i) {
            this.secMechs[i].write(out);
        }
        out.endEncapsulation(handle);
    }

    @Override
    public String toString() {
        String str = "CompoundSecMechList (stateful = " + this.statefulContext + ",numSecMechs = " + this.numSecMechs + ", secMechs = ";
        for (int i = 0; i < this.numSecMechs; ++i) {
            str = str + this.secMechs[i];
        }
        return str + ")";
    }

    public String getTargetName() {
        for (CompoundSecMech secMech : this.secMechs) {
            if (secMech.getGSSUPTarget() == null) continue;
            return GSSUtil.extractGSSUPGSSNTExportedName(secMech.getGSSUPTarget());
        }
        return null;
    }
}

