/*
 * Decompiled with CFR 0.152.
 */
package weblogic.iiop.ior;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import weblogic.cluster.replication.ROID;
import weblogic.rmi.cluster.ReplicaID;
import weblogic.rmi.cluster.ejb.ReplicaIDImpl;

public enum ReplicaType {
    none{

        @Override
        void write_value(ObjectOutput out, ReplicaID replicaID) throws IOException {
        }

        @Override
        ReplicaID read_value(ObjectInput in) {
            return null;
        }
    }
    ,
    ejb_roid{

        @Override
        void write_value(ObjectOutput out, ReplicaID replicaID) throws IOException {
            ((ROID)replicaID.getID()).writeExternal(out);
        }

        @Override
        ReplicaID read_value(ObjectInput in) throws IOException, ClassNotFoundException {
            ROID roid = new ROID();
            roid.readExternal(in);
            return new ReplicaIDImpl((Object)roid);
        }
    }
    ,
    byte_array{

        @Override
        void write_value(ObjectOutput out, ReplicaID replicaID) throws IOException {
            this.writeBytes(out, (byte[])replicaID.getID());
        }

        private void writeBytes(ObjectOutput out, byte[] id) throws IOException {
            out.writeInt(id.length);
            out.write(id);
        }

        @Override
        ReplicaID read_value(ObjectInput in) throws IOException, ClassNotFoundException {
            int numBytes = in.readInt();
            byte[] bytes = new byte[numBytes];
            in.read(bytes);
            return new ReplicaIDImpl((Object)bytes);
        }
    };


    abstract void write_value(ObjectOutput var1, ReplicaID var2) throws IOException;

    abstract ReplicaID read_value(ObjectInput var1) throws IOException, ClassNotFoundException;

    public static ReplicaType forId(ReplicaID id) {
        return id == null ? none : ReplicaType.getEnumForValue(id.getID());
    }

    private static ReplicaType getEnumForValue(Object value) {
        if (value instanceof byte[]) {
            return byte_array;
        }
        if (value instanceof ROID) {
            return ejb_roid;
        }
        throw new IllegalArgumentException("Unsupported replica ID implementation: " + value.getClass());
    }
}

