/*
 * Decompiled with CFR 0.152.
 */
package weblogic.iiop.ior;

import weblogic.iiop.ior.TaggedComponent;
import weblogic.iiop.protocol.CorbaInputStream;
import weblogic.iiop.protocol.CorbaOutputStream;

public final class SSLSecTransComponent
extends TaggedComponent {
    private int port;
    private short supports;
    private short requires;
    private static SSLSecTransComponent singleton;
    private static final short IOP_SIGNED_FLAGS = 314;
    private static final short IOP_SEALED_FLAGS = 318;
    private static int listenPort;
    private static String[] ciphersuites;
    private static boolean clientCertificateEnforced;

    public static SSLSecTransComponent getSingleton() {
        return singleton == null ? SSLSecTransComponent.createSingleton() : singleton;
    }

    private static synchronized SSLSecTransComponent createSingleton() {
        if (singleton == null) {
            singleton = new SSLSecTransComponent();
        }
        return singleton;
    }

    private SSLSecTransComponent() {
        super(20);
        this.port = listenPort;
        boolean foundEncrypt = false;
        boolean foundNoEncrypt = false;
        String[] s = ciphersuites;
        if (s != null && s.length > 0) {
            for (String value : s) {
                if (value == null) continue;
                if (value.contains("WITH_NULL")) {
                    foundNoEncrypt = true;
                    continue;
                }
                foundEncrypt = true;
            }
        }
        this.supports = (short)318;
        this.requires = (short)314;
        if (!foundEncrypt && s != null) {
            this.supports = (short)314;
        }
        if (!foundNoEncrypt && foundEncrypt) {
            this.requires = (short)318;
        }
        if (clientCertificateEnforced) {
            this.supports = (short)(this.supports | 0x40);
            this.requires = (short)(this.requires | 0x40);
        }
    }

    public static void initialize(int listenPort, boolean clientCertificateEnforced, String ... ciphersuites) {
        SSLSecTransComponent.listenPort = listenPort;
        SSLSecTransComponent.clientCertificateEnforced = clientCertificateEnforced;
        SSLSecTransComponent.ciphersuites = ciphersuites;
    }

    SSLSecTransComponent(CorbaInputStream in) {
        super(20);
        this.read(in);
    }

    public final int getPort() {
        return this.port;
    }

    public final short getSupports() {
        return this.supports;
    }

    public final short getRequires() {
        return this.requires;
    }

    @Override
    public final void read(CorbaInputStream in) {
        long handle = in.startEncapsulation();
        this.supports = in.read_short();
        this.requires = in.read_short();
        this.port = in.read_unsigned_short();
        in.endEncapsulation(handle);
    }

    @Override
    public final void write(CorbaOutputStream out) {
        out.write_long(this.tag);
        long handle = out.startEncapsulation();
        out.write_short(this.supports);
        out.write_short(this.requires);
        out.write_unsigned_short(this.port);
        out.endEncapsulation(handle);
    }
}

