/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.base;

import com.oracle.coherence.common.base.Classes;
import com.tangosol.util.ByteSequence;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public abstract class Formatting {
    public static final char[] HEX = "0123456789ABCDEF".toCharArray();
    private static final int KB = 1024;
    private static final int KB_MASK = 1023;
    private static final String[] MEM_SUFFIX = new String[]{"", "KB", "MB", "GB", "TB"};
    private static final int CRC32_BASE = -306674912;
    public static final int[] CRC32_TABLE = new int[256];
    public static final int POWER_0 = 0;
    public static final int POWER_K = 10;
    public static final int POWER_M = 20;
    public static final int POWER_G = 30;
    public static final int POWER_T = 40;

    public static String toString(double dfl, int cMinDigits) {
        BigDecimal decVal = new BigDecimal(dfl);
        BigInteger intVal = decVal.toBigInteger();
        String sIntVal = intVal.toString();
        int cIntDigits = sIntVal.length() - (intVal.signum() <= 0 ? 1 : 0);
        int cDecDigits = decVal.scale();
        if (cIntDigits >= cMinDigits || cDecDigits == 0) {
            return sIntVal;
        }
        int cRemDigits = cMinDigits - cIntDigits;
        if (cDecDigits > cRemDigits) {
            decVal = decVal.setScale(cRemDigits, 4);
        }
        String sDecVal = decVal.toString();
        int of = sDecVal.length() - 1;
        if (sDecVal.length() > 1 && sDecVal.charAt(of) == '0') {
            while (sDecVal.charAt(--of) == '0') {
            }
            if (sDecVal.charAt(of) == '.') {
                --of;
            }
            sDecVal = sDecVal.substring(0, of + 1);
        }
        return sDecVal;
    }

    public static String toUnicodeEscape(char ch) {
        char n = ch;
        char[] ach = new char[]{'\\', 'u', HEX[n >> 12], HEX[n >> 8 & 0xF], HEX[n >> 4 & 0xF], HEX[n & 0xF]};
        return new String(ach);
    }

    public static String toCharEscape(char ch) {
        char[] ach = new char[6];
        int cch = Formatting.escape(ch, ach, 0);
        return new String(ach, 0, cch);
    }

    public static String toQuotedCharEscape(char ch) {
        char[] ach = new char[8];
        ach[0] = 39;
        int cch = Formatting.escape(ch, ach, 1);
        ach[cch + 1] = 39;
        return new String(ach, 0, cch + 2);
    }

    public static String toStringEscape(String s) {
        char[] achSrc = s.toCharArray();
        int cchSrc = achSrc.length;
        int ofSrc = 0;
        int cchDest = cchSrc * 6;
        char[] achDest = new char[cchDest];
        int ofDest = 0;
        while (ofSrc < cchSrc) {
            ofDest += Formatting.escape(achSrc[ofSrc++], achDest, ofDest);
        }
        return new String(achDest, 0, ofDest);
    }

    public static String toQuotedStringEscape(String s) {
        char[] achSrc = s.toCharArray();
        int cchSrc = achSrc.length;
        int ofSrc = 0;
        int cchDest = cchSrc * 6 + 2;
        char[] achDest = new char[cchDest];
        int ofDest = 0;
        achDest[ofDest++] = 34;
        while (ofSrc < cchSrc) {
            ofDest += Formatting.escape(achSrc[ofSrc++], achDest, ofDest);
        }
        achDest[ofDest++] = 34;
        return new String(achDest, 0, ofDest);
    }

    public static int escape(char ch, char[] ach, int of) {
        switch (ch) {
            case '\b': {
                ach[of++] = 92;
                ach[of] = 98;
                return 2;
            }
            case '\t': {
                ach[of++] = 92;
                ach[of] = 116;
                return 2;
            }
            case '\n': {
                ach[of++] = 92;
                ach[of] = 110;
                return 2;
            }
            case '\f': {
                ach[of++] = 92;
                ach[of] = 102;
                return 2;
            }
            case '\r': {
                ach[of++] = 92;
                ach[of] = 114;
                return 2;
            }
            case '\"': {
                ach[of++] = 92;
                ach[of] = 34;
                return 2;
            }
            case '\'': {
                ach[of++] = 92;
                ach[of] = 39;
                return 2;
            }
            case '\\': {
                ach[of++] = 92;
                ach[of] = 92;
                return 2;
            }
            case '\u0000': 
            case '\u0001': 
            case '\u0002': 
            case '\u0003': 
            case '\u0004': 
            case '\u0005': 
            case '\u0006': 
            case '\u0007': 
            case '\u000b': 
            case '\u000e': 
            case '\u000f': 
            case '\u0010': 
            case '\u0011': 
            case '\u0012': 
            case '\u0013': 
            case '\u0014': 
            case '\u0015': 
            case '\u0016': 
            case '\u0017': 
            case '\u0018': 
            case '\u0019': 
            case '\u001a': 
            case '\u001b': 
            case '\u001c': 
            case '\u001d': 
            case '\u001e': 
            case '\u001f': {
                ach[of++] = 92;
                ach[of++] = 48;
                ach[of++] = (char)(ch / 8 + 48);
                ach[of] = (char)(ch % 8 + 48);
                return 4;
            }
        }
        switch (Character.getType(ch)) {
            case 0: 
            case 15: 
            case 18: {
                char n = ch;
                ach[of++] = 92;
                ach[of++] = 117;
                ach[of++] = HEX[n >> 12];
                ach[of++] = HEX[n >> 8 & 0xF];
                ach[of++] = HEX[n >> 4 & 0xF];
                ach[of] = HEX[n & 0xF];
                return 6;
            }
        }
        ach[of] = ch;
        return 1;
    }

    public static String toSqlString(String s) {
        if (s == null) {
            return "NULL";
        }
        if (s.length() == 0) {
            return "''";
        }
        if (s.indexOf(39) < 0) {
            return '\'' + s + '\'';
        }
        char[] ach = s.toCharArray();
        int cch = ach.length;
        StringBuilder sb = new StringBuilder(cch + 16);
        sb.append('\'');
        int ofPrev = 0;
        for (int ofCur = 0; ofCur < cch; ++ofCur) {
            char ch = ach[ofCur];
            switch (ch) {
                case '\n': 
                case '\'': {
                    if (ofCur > ofPrev) {
                        sb.append(ach, ofPrev, ofCur - ofPrev);
                    }
                    switch (ch) {
                        case '\n': {
                            sb.append("'\n'");
                            break;
                        }
                        case '\'': {
                            sb.append("''");
                        }
                    }
                    ofPrev = ofCur + 1;
                }
            }
        }
        if (ofPrev < cch) {
            sb.append(ach, ofPrev, cch - ofPrev);
        }
        sb.append('\'');
        return sb.toString();
    }

    public static String indentString(String sText, String sIndent) {
        return Formatting.indentString(sText, sIndent, true);
    }

    public static String indentString(String sText, String sIndent, boolean fFirstLine) {
        char[] ach = sText.toCharArray();
        int cch = ach.length;
        StringBuilder sb = new StringBuilder();
        int iLine = 0;
        int of = 0;
        int ofPrev = 0;
        while (of < cch) {
            if (ach[of++] != '\n' && of != cch) continue;
            if (iLine++ > 0 || fFirstLine) {
                sb.append(sIndent);
            }
            sb.append(sText, ofPrev, of);
            ofPrev = of;
        }
        return sb.toString();
    }

    public static String breakLines(String sText, int nWidth, String sIndent) {
        return Formatting.breakLines(sText, nWidth, sIndent, true);
    }

    public static String breakLines(String sText, int nWidth, String sIndent, boolean fFirstLine) {
        if (sIndent == null) {
            sIndent = "";
        }
        if ((nWidth -= sIndent.length()) <= 0) {
            throw new IllegalArgumentException("The width and indent are incompatible");
        }
        char[] ach = sText.toCharArray();
        int cch = ach.length;
        StringBuilder sb = new StringBuilder(cch);
        int ofPrev = 0;
        int of = 0;
        while (of < cch) {
            char c = ach[of++];
            boolean fBreak = false;
            int ofBreak = of;
            int ofNext = of;
            if (c == '\n') {
                fBreak = true;
                --ofBreak;
            } else if (of == cch) {
                fBreak = true;
            } else if (of == ofPrev + nWidth) {
                fBreak = true;
                while (!Character.isWhitespace(ach[--ofBreak]) && ofBreak > ofPrev) {
                }
                if (ofBreak == ofPrev) {
                    ofBreak = of;
                } else {
                    ofNext = ofBreak + 1;
                }
            }
            if (!fBreak) continue;
            if (ofPrev > 0) {
                sb.append('\n').append(sIndent);
            } else if (fFirstLine) {
                sb.append(sIndent);
            }
            sb.append(sText, ofPrev, ofBreak);
            ofPrev = ofNext;
        }
        return sb.toString();
    }

    public static String dup(char ch, int cch) {
        char[] ach = new char[cch];
        for (int of = 0; of < cch; ++of) {
            ach[of] = ch;
        }
        return new String(ach);
    }

    public static String dup(String s, int c) {
        if (c < 1) {
            return "";
        }
        if (c == 1) {
            return s;
        }
        char[] achPat = s.toCharArray();
        int cchPat = achPat.length;
        int cchBuf = cchPat * c;
        char[] achBuf = new char[cchBuf];
        int i = 0;
        int of = 0;
        while (i < c) {
            System.arraycopy(achPat, 0, achBuf, of, cchPat);
            ++i;
            of += cchPat;
        }
        return new String(achBuf);
    }

    public static String replace(String sText, String sFrom, String sTo) {
        if (sFrom.length() == 0) {
            return sText;
        }
        StringBuilder sbTextNew = new StringBuilder();
        int iTextLen = sText.length();
        int iStart = 0;
        while (iStart < iTextLen) {
            int iPos = sText.indexOf(sFrom, iStart);
            if (iPos != -1) {
                sbTextNew.append(sText, iStart, iPos);
                sbTextNew.append(sTo);
                iStart = iPos + sFrom.length();
                continue;
            }
            sbTextNew.append(sText.substring(iStart));
            break;
        }
        return sbTextNew.toString();
    }

    public static String[] parseDelimitedString(String s, char chDelim) {
        if (s == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        int ofPrev = -1;
        while (true) {
            int ofNext;
            if ((ofNext = s.indexOf(chDelim, ofPrev + 1)) < 0) break;
            list.add(s.substring(ofPrev + 1, ofNext));
            ofPrev = ofNext;
        }
        list.add(s.substring(ofPrev + 1));
        return list.toArray(new String[0]);
    }

    public static String toDelimitedString(int[] an, String sDelim) {
        int c = an.length;
        if (c > 0) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < c; ++i) {
                sb.append(sDelim).append(an[i]);
            }
            return sb.substring(sDelim.length());
        }
        return "";
    }

    public static String toDelimitedString(long[] al, String sDelim) {
        int c = al.length;
        if (c > 0) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < c; ++i) {
                sb.append(sDelim).append(al[i]);
            }
            return sb.substring(sDelim.length());
        }
        return "";
    }

    public static String toDelimitedString(Object[] ao, String sDelim) {
        int c = ao.length;
        if (c > 0) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < c; ++i) {
                sb.append(sDelim).append(ao[i]);
            }
            return sb.substring(sDelim.length());
        }
        return "";
    }

    public static String toDelimitedString(Iterator<?> iter, String sDelim) {
        StringBuilder sb = new StringBuilder();
        while (iter.hasNext()) {
            sb.append(sDelim).append(iter.next());
        }
        return sb.length() == 0 ? "" : sb.substring(sDelim.length());
    }

    public static String capitalize(String s) {
        return s.length() > 1 ? s.substring(0, 1).toUpperCase() + s.substring(1) : s.toUpperCase();
    }

    public static String truncateString(String s, int cLimit) {
        int cChar = s.length();
        return cChar > cLimit ? s.substring(0, cLimit) + "...(" + (cChar - cLimit) + " more)" : s;
    }

    public static String truncateString(Collection<?> coll, int cLimit) {
        StringBuilder sb = new StringBuilder(Classes.getSimpleName(coll.getClass())).append('[');
        cLimit += sb.length() + 1;
        int c = 1;
        Iterator<?> iter = coll.iterator();
        while (iter.hasNext() && sb.length() < cLimit) {
            if (c > 1) {
                sb.append(", ");
            }
            sb.append(iter.next());
            ++c;
        }
        if (c < coll.size() && sb.length() >= cLimit) {
            sb.append(", ...");
        }
        return sb.append(']').toString();
    }

    public static boolean isHex(char ch) {
        return ch >= '0' && ch <= '9' || ch >= 'A' && ch <= 'F' || ch >= 'a' && ch <= 'f';
    }

    public static int hexValue(char ch) {
        if (ch >= '0' && ch <= '9') {
            return ch - 48;
        }
        if (ch >= 'A' && ch <= 'F') {
            return ch - 65 + 10;
        }
        if (ch >= 'a' && ch <= 'f') {
            return ch - 97 + 10;
        }
        throw new IllegalArgumentException("Character \"" + ch + "\" is not a valid hexadecimal digit.");
    }

    public static int getMaxHexDigits(int n) {
        int cDigits = 0;
        do {
            ++cDigits;
        } while ((n >>>= 4) != 0);
        return cDigits;
    }

    public static String toHexString(int n, int cDigits) {
        char[] ach = new char[cDigits];
        while (cDigits > 0) {
            ach[--cDigits] = HEX[n & 0xF];
            n >>>= 4;
        }
        return new String(ach);
    }

    public static String toHex(int b) {
        int n = b & 0xFF;
        char[] ach = new char[]{HEX[n >> 4], HEX[n & 0xF]};
        return new String(ach);
    }

    public static String toHex(byte[] ab) {
        int cb = ab.length;
        char[] ach = new char[cb * 2];
        int ofch = 0;
        for (int ofb = 0; ofb < cb; ++ofb) {
            int n = ab[ofb] & 0xFF;
            ach[ofch++] = HEX[n >> 4];
            ach[ofch++] = HEX[n & 0xF];
        }
        return new String(ach);
    }

    public static String toHexEscape(byte b) {
        int n = b & 0xFF;
        char[] ach = new char[]{'0', 'x', HEX[n >> 4], HEX[n & 0xF]};
        return new String(ach);
    }

    public static String toHexEscape(byte[] ab) {
        return Formatting.toHexEscape(ab, 0, ab.length);
    }

    public static String toHexEscape(byte[] ab, int of, int cb) {
        char[] ach = new char[2 + cb * 2];
        ach[0] = 48;
        ach[1] = 120;
        int ofch = 2;
        int ofStop = of + cb;
        for (int ofb = of; ofb < ofStop; ++ofb) {
            int n = ab[ofb] & 0xFF;
            ach[ofch++] = HEX[n >> 4];
            ach[ofch++] = HEX[n & 0xF];
        }
        return new String(ach);
    }

    public static String toHexEscape(ByteSequence seq, int of, int cb) {
        if (cb > 0) {
            char[] ach = new char[2 + cb * 2];
            ach[0] = 48;
            ach[1] = 120;
            int ofch = 2;
            int ofStop = of + cb;
            for (int ofb = of; ofb < ofStop; ++ofb) {
                int n = seq.byteAt(ofb) & 0xFF;
                ach[ofch++] = HEX[n >> 4];
                ach[ofch++] = HEX[n & 0xF];
            }
            return new String(ach);
        }
        return "";
    }

    public static String toHexDump(byte[] ab, int cBytesPerLine) {
        int cb = ab.length;
        if (cb == 0) {
            return "";
        }
        int cDigits = 0;
        int cbTemp = cb - 1;
        do {
            cDigits += 2;
        } while ((cbTemp /= 256) > 0);
        int cLines = (cb + cBytesPerLine - 1) / cBytesPerLine;
        int cCharsPerLine = cDigits + 4 * cBytesPerLine + 5;
        int cch = cLines * cCharsPerLine;
        char[] ach = new char[cch];
        int ofColon = cDigits;
        int ofLF = cCharsPerLine - 1;
        int ofHexInLine = ofColon + 3;
        int ofCharInLine = ofLF - cBytesPerLine;
        int ofByte = 0;
        int ofLine = 0;
        for (int iLine = 0; iLine < cLines; ++iLine) {
            int nOffset = ofByte;
            int ofDigit = ofLine + cDigits;
            for (int i = 0; i < cDigits; ++i) {
                ach[--ofDigit] = HEX[nOffset & 0xF];
                nOffset >>= 4;
            }
            int ofFmt = ofLine + cDigits;
            ach[ofFmt++] = 58;
            ach[ofFmt++] = 32;
            ach[ofFmt] = 32;
            int ofHex = ofLine + ofHexInLine;
            int ofChar = ofLine + ofCharInLine;
            for (int i = 0; i < cBytesPerLine; ++i) {
                try {
                    int n = ab[ofByte++] & 0xFF;
                    ach[ofHex++] = HEX[(n & 0xF0) >> 4];
                    ach[ofHex++] = HEX[n & 0xF];
                    ach[ofHex++] = 32;
                    ach[ofChar++] = (char)(n < 32 ? 46 : (char)n);
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    ach[ofHex++] = 32;
                    ach[ofHex++] = 32;
                    ach[ofHex++] = 32;
                    ach[ofChar++] = 32;
                }
            }
            ach[ofHex] = 32;
            ach[ofChar] = 10;
            ofLine += cCharsPerLine;
        }
        return new String(ach, 0, cch - 1);
    }

    public static byte[] parseHex(String s) {
        char[] ach = s.toCharArray();
        int cch = ach.length;
        if (cch == 0) {
            return new byte[0];
        }
        if ((cch & 1) != 0) {
            throw new IllegalArgumentException("invalid length hex string");
        }
        int ofch = 0;
        if (ach[1] == 'x' || ach[1] == 'X') {
            ofch = 2;
        }
        int cb = (cch - ofch) / 2;
        byte[] ab = new byte[cb];
        for (int ofb = 0; ofb < cb; ++ofb) {
            ab[ofb] = (byte)(Formatting.parseHex(ach[ofch++]) << 4 | Formatting.parseHex(ach[ofch++]));
        }
        return ab;
    }

    public static int parseHex(char ch) {
        switch (ch) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return ch - 48;
            }
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': {
                return ch - 65 + 10;
            }
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': {
                return ch - 97 + 10;
            }
        }
        throw new IllegalArgumentException("illegal hex char: " + ch);
    }

    public static boolean isDecimal(char ch) {
        return ch >= '0' && ch <= '9';
    }

    public static int decimalValue(char ch) {
        if (ch >= '0' && ch <= '9') {
            return ch - 48;
        }
        throw new IllegalArgumentException("Character \"" + ch + "\" is not a valid decimal digit.");
    }

    public static int getMaxDecDigits(int n) {
        int cDigits = 0;
        do {
            ++cDigits;
        } while ((n /= 10) != 0);
        return cDigits;
    }

    public static String toDecString(int n, int cDigits) {
        char[] ach = new char[cDigits];
        while (cDigits > 0) {
            ach[--cDigits] = (char)(48 + n % 10);
            n /= 10;
        }
        return new String(ach);
    }

    public static long pad(long lMin, long lMultiple) {
        return (lMin + lMultiple - 1L) / lMultiple * lMultiple;
    }

    public static boolean isOctal(char ch) {
        return ch >= '0' && ch <= '7';
    }

    public static int octalValue(char ch) {
        if (ch >= '0' && ch <= '7') {
            return ch - 48;
        }
        throw new IllegalArgumentException("Character \"" + ch + "\" is not a valid octal digit.");
    }

    public static long parseBandwidth(String s) {
        return Formatting.parseBandwidth(s, 0);
    }

    public static long parseBandwidth(String s, int nDefaultPower) {
        char ch;
        if (s == null) {
            throw new IllegalArgumentException("passed String must not be null");
        }
        switch (nDefaultPower) {
            case 0: 
            case 10: 
            case 20: 
            case 30: 
            case 40: {
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal default power: " + nDefaultPower);
            }
        }
        int cch = s.length();
        if (cch >= 2 && ((ch = s.charAt(cch - 1)) == 'S' || ch == 's')) {
            ch = s.charAt(cch - 2);
            if (ch == 'P' || ch == 'p') {
                cch -= 2;
            } else {
                throw new IllegalArgumentException("invalid bandwidth: \"" + s + "\" (illegal bandwidth unit)");
            }
        }
        int cBitShift = -3;
        boolean fDefault = true;
        if (cch >= 1) {
            switch (s.charAt(cch - 1)) {
                case 'B': {
                    cBitShift = 0;
                }
                case 'b': {
                    --cch;
                    fDefault = false;
                }
            }
        }
        if (cch >= 1) {
            switch (s.charAt(--cch)) {
                case 'K': 
                case 'k': {
                    cBitShift += 10;
                    break;
                }
                case 'M': 
                case 'm': {
                    cBitShift += 20;
                    break;
                }
                case 'G': 
                case 'g': {
                    cBitShift += 30;
                    break;
                }
                case 'T': 
                case 't': {
                    cBitShift += 40;
                    break;
                }
                default: {
                    if (fDefault) {
                        cBitShift += nDefaultPower;
                    }
                    ++cch;
                }
            }
        }
        if (cch == 0) {
            throw new NumberFormatException("passed String (\"" + s + "\") must contain a number");
        }
        long cb = 0L;
        boolean fDecimal = false;
        int nDivisor = 1;
        block17: for (int of = 0; of < cch; ++of) {
            char ch2 = s.charAt(of);
            switch (ch2) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    cb = cb * 10L + (long)(ch2 - 48);
                    if (!fDecimal) continue block17;
                    nDivisor *= 10;
                    continue block17;
                }
                case '.': {
                    if (fDecimal) {
                        throw new NumberFormatException("invalid bandwidth: \"" + s + "\" (illegal second decimal point)");
                    }
                    fDecimal = true;
                    continue block17;
                }
                default: {
                    throw new NumberFormatException("invalid bandwidth: \"" + s + "\" (illegal digit: \"" + ch2 + "\")");
                }
            }
        }
        cb = cBitShift < 0 ? (cb >>>= -cBitShift) : (cb <<= cBitShift);
        if (fDecimal) {
            if (nDivisor == 1) {
                throw new NumberFormatException("invalid bandwidth: \"" + s + "\" (illegal trailing decimal point)");
            }
            cb /= (long)nDivisor;
        }
        return cb;
    }

    public static String toBandwidthString(long cbps) {
        return Formatting.toBandwidthString(cbps, true);
    }

    public static String toBandwidthString(long cbps, boolean fExact) {
        int ofLast;
        StringBuilder sb;
        boolean fBits;
        boolean bl = fBits = (cbps & 0xF00000000000000L) == 0L;
        if (fBits) {
            cbps <<= 3;
        }
        if ((sb = new StringBuilder(Formatting.toMemorySizeString(cbps, fExact))).charAt(ofLast = sb.length() - 1) == 'B') {
            if (fBits) {
                sb.setCharAt(ofLast, 'b');
            }
        } else {
            sb.append(fBits ? (char)'b' : 'B');
        }
        sb.append("ps");
        return sb.toString();
    }

    public static long parseMemorySize(String s) {
        return Formatting.parseMemorySize(s, 0);
    }

    public static long parseMemorySize(String s, int nDefaultPower) {
        if (s == null) {
            throw new IllegalArgumentException("passed String must not be null");
        }
        switch (nDefaultPower) {
            case 0: 
            case 10: 
            case 20: 
            case 30: 
            case 40: {
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal default power: " + nDefaultPower);
            }
        }
        int cBitShift = 0;
        int cch = s.length();
        if (cch > 0) {
            boolean fDefault;
            char ch = s.charAt(cch - 1);
            if (ch == 'B' || ch == 'b') {
                --cch;
                fDefault = false;
            } else {
                fDefault = true;
            }
            if (cch > 0) {
                switch (s.charAt(--cch)) {
                    case 'K': 
                    case 'k': {
                        cBitShift = 10;
                        break;
                    }
                    case 'M': 
                    case 'm': {
                        cBitShift = 20;
                        break;
                    }
                    case 'G': 
                    case 'g': {
                        cBitShift = 30;
                        break;
                    }
                    case 'T': 
                    case 't': {
                        cBitShift = 40;
                        break;
                    }
                    default: {
                        if (fDefault) {
                            cBitShift = nDefaultPower;
                        }
                        ++cch;
                    }
                }
            }
        }
        if (cch == 0) {
            throw new NumberFormatException("passed String (\"" + s + "\") must contain a number");
        }
        long cb = 0L;
        boolean fDecimal = false;
        int nDivisor = 1;
        block13: for (int of = 0; of < cch; ++of) {
            char ch = s.charAt(of);
            switch (ch) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    cb = cb * 10L + (long)(ch - 48);
                    if (!fDecimal) continue block13;
                    nDivisor *= 10;
                    continue block13;
                }
                case '.': {
                    if (fDecimal) {
                        throw new NumberFormatException("invalid memory size: \"" + s + "\" (illegal second decimal point)");
                    }
                    fDecimal = true;
                    continue block13;
                }
                default: {
                    throw new NumberFormatException("invalid memory size: \"" + s + "\" (illegal digit: \"" + ch + "\")");
                }
            }
        }
        cb <<= cBitShift;
        if (fDecimal) {
            if (nDivisor == 1) {
                throw new NumberFormatException("invalid memory size: \"" + s + "\" (illegal trailing decimal point)");
            }
            cb /= (long)nDivisor;
        }
        return cb;
    }

    public static String toMemorySizeString(long cb) {
        return Formatting.toMemorySizeString(cb, true);
    }

    public static String toMemorySizeString(long cb, boolean fExact) {
        int cDivs;
        if (cb < 0L) {
            throw new IllegalArgumentException("negative quantity: " + cb);
        }
        if (cb < 1024L) {
            return String.valueOf(cb);
        }
        int cMaxDivs = MEM_SUFFIX.length - 1;
        if (fExact) {
            for (cDivs = 0; ((int)cb & 0x3FF) == 0 && cDivs < cMaxDivs; ++cDivs) {
                cb >>>= 10;
            }
            return cb + MEM_SUFFIX[cDivs];
        }
        int cbRem = 0;
        while (cb >= 1024L && cDivs < cMaxDivs) {
            cbRem = (int)cb & 0x3FF;
            cb >>>= 10;
            ++cDivs;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(cb);
        int cch = sb.length();
        if (cch < 3 && cbRem != 0) {
            String sDec = String.valueOf((int)((double)cbRem / 10.24 + 100.0));
            sb.append('.').append(sDec, 1, 4 - cch);
        }
        sb.append(MEM_SUFFIX[cDivs]);
        return sb.toString();
    }

    public static long parseTime(String s) {
        return Formatting.parseTime(s, 1);
    }

    public static long parseTime(String s, int nDefaultUnit) {
        return Formatting.parseTimeNanos(s, nDefaultUnit) / 1000000L;
    }

    public static long parseTimeNanos(String s) {
        return Formatting.parseTimeNanos(s, -1000000);
    }

    public static long parseTimeNanos(String s, int nDefaultUnit) {
        if (s == null) {
            throw new IllegalArgumentException("passed String must not be null");
        }
        switch (nDefaultUnit) {
            case -1000000: 
            case -1000: 
            case 1: 
            case 1000: 
            case 60000: 
            case 3600000: 
            case 86400000: {
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal default unit: " + nDefaultUnit);
            }
        }
        long nMultiplier = nDefaultUnit;
        int cch = s.length();
        if (cch > 0) {
            switch (s.charAt(--cch)) {
                case 'S': 
                case 's': {
                    nMultiplier = 1000L;
                    if (cch <= 1) break;
                    char c = s.charAt(cch - 1);
                    switch (c) {
                        case 'N': 
                        case 'n': {
                            --cch;
                            nMultiplier = -1000000L;
                            break;
                        }
                        case 'U': 
                        case 'u': {
                            --cch;
                            nMultiplier = -1000L;
                            break;
                        }
                        case 'M': 
                        case 'm': {
                            --cch;
                            nMultiplier = 1L;
                        }
                    }
                    break;
                }
                case 'M': 
                case 'm': {
                    nMultiplier = 60000L;
                    break;
                }
                case 'H': 
                case 'h': {
                    nMultiplier = 3600000L;
                    break;
                }
                case 'D': 
                case 'd': {
                    nMultiplier = 86400000L;
                    break;
                }
                default: {
                    ++cch;
                }
            }
        }
        long l = nMultiplier = nMultiplier < 0L ? 1000000L / -nMultiplier : 1000000L * nMultiplier;
        if (cch == 0) {
            throw new NumberFormatException("passed String (\"" + s + "\") must contain a number");
        }
        long cNanos = 0L;
        boolean fDecimal = false;
        int nDivisor = 1;
        block18: for (int of = 0; of < cch; ++of) {
            char ch = s.charAt(of);
            switch (ch) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    cNanos = cNanos * 10L + (long)(ch - 48);
                    if (!fDecimal) continue block18;
                    nDivisor *= 10;
                    continue block18;
                }
                case '.': {
                    if (fDecimal) {
                        throw new NumberFormatException("invalid time: \"" + s + "\" (illegal second decimal point)");
                    }
                    fDecimal = true;
                    continue block18;
                }
                default: {
                    throw new NumberFormatException("invalid time: \"" + s + "\" (illegal digit: \"" + ch + "\")");
                }
            }
        }
        cNanos *= nMultiplier;
        if (fDecimal) {
            if (nDivisor == 1) {
                throw new NumberFormatException("invalid time: \"" + s + "\" (illegal trailing decimal point)");
            }
            cNanos /= (long)nDivisor;
        }
        return cNanos;
    }

    public static String formatDateTime(long ldt) {
        return ldt == 0L ? "none" : new Timestamp(ldt).toString();
    }

    public static float parsePercentage(String s) {
        int ofPct = s.indexOf(37);
        if (ofPct == -1) {
            throw new IllegalArgumentException("The parameter " + s + " does not contain a percentage value.");
        }
        int percent = Integer.parseInt(s.substring(0, ofPct));
        if (percent > 100 || percent < 0) {
            throw new IllegalArgumentException("Not a percentage value between 0 - 100:" + s);
        }
        return (float)percent / 100.0f;
    }

    public static int toCrc(byte[] ab) {
        return Formatting.toCrc(ab, 0, ab.length);
    }

    public static int toCrc(byte[] ab, int of, int cb) {
        return Formatting.toCrc(ab, of, cb, -1);
    }

    public static int toCrc(byte[] ab, int of, int cb, int nCrc) {
        while (cb > 0) {
            nCrc = nCrc >>> 8 ^ CRC32_TABLE[(nCrc ^ ab[of++]) & 0xFF];
            --cb;
        }
        return nCrc;
    }

    public static int toCrc(ByteSequence seq) {
        return Formatting.toCrc(seq, 0, seq.length(), -1);
    }

    public static int toCrc(ByteSequence seq, int of, int cb, int nCrc) {
        while (cb > 0) {
            nCrc = nCrc >>> 8 ^ CRC32_TABLE[(nCrc ^ seq.byteAt(of++)) & 0xFF];
            --cb;
        }
        return nCrc;
    }

    static {
        int c = CRC32_TABLE.length;
        for (int i = 0; i < c; ++i) {
            int nCrc = i;
            for (int n = 0; n < 8; ++n) {
                if ((nCrc & 1) == 1) {
                    nCrc = nCrc >>> 1 ^ 0xEDB88320;
                    continue;
                }
                nCrc >>>= 1;
            }
            Formatting.CRC32_TABLE[i] = nCrc;
        }
    }
}

