/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.base;

import com.oracle.coherence.common.base.TimeHelper;
import com.tangosol.util.Binary;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;

public abstract class Randoms {
    private static final int s_procRand = ThreadLocalRandom.current().nextInt();
    private static Random s_rnd;

    public static int getProcessRandom() {
        return s_procRand;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Random getRandom() {
        Random rnd = s_rnd;
        if (rnd != null) return rnd;
        Class<Random> clazz = Random.class;
        synchronized (Random.class) {
            rnd = s_rnd;
            if (rnd != null) return rnd;
            rnd = new Random();
            long lStop = TimeHelper.getSafeTimeMillis() + 31L + (long)rnd.nextInt(31);
            long cMin = 1021 + rnd.nextInt(Math.max(1, (int)(lStop % 1021L)));
            while (TimeHelper.getSafeTimeMillis() < lStop || --cMin > 0L) {
                cMin += rnd.nextBoolean() ? 1L : -1L;
                rnd.setSeed(rnd.nextLong());
            }
            long lStart = TimeHelper.getSafeTimeMillis();
            do {
                if (!rnd.nextBoolean() || (rnd.nextLong() & 1L) != (TimeHelper.getSafeTimeMillis() & 1L)) continue;
                rnd.nextBoolean();
            } while (TimeHelper.getSafeTimeMillis() == lStart);
            s_rnd = rnd;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return rnd;
        }
    }

    public static List randomize(Collection coll) {
        return Collections.unmodifiableList(Arrays.asList(Randoms.randomize(coll.toArray())));
    }

    public static Object[] randomize(Object[] a) {
        int c;
        if (a == null || (c = a.length) <= 1) {
            return a;
        }
        Random rnd = Randoms.getRandom();
        for (int i1 = 0; i1 < c; ++i1) {
            int i2 = rnd.nextInt(c);
            Object o = a[i2];
            a[i2] = a[i1];
            a[i1] = o;
        }
        return a;
    }

    public static int[] randomize(int[] a) {
        int c;
        if (a == null || (c = a.length) <= 1) {
            return a;
        }
        Random rnd = Randoms.getRandom();
        for (int i1 = 0; i1 < c; ++i1) {
            int i2 = rnd.nextInt(c);
            int n = a[i2];
            a[i2] = a[i1];
            a[i1] = n;
        }
        return a;
    }

    public static long[] randomize(long[] a) {
        int c;
        if (a == null || (c = a.length) <= 1) {
            return a;
        }
        Random rnd = Randoms.getRandom();
        for (int i1 = 0; i1 < c; ++i1) {
            int i2 = rnd.nextInt(c);
            long l = a[i2];
            a[i2] = a[i1];
            a[i1] = l;
        }
        return a;
    }

    public static Binary getRandomBinary(int cbMin, int cbMax) {
        return Randoms.getRandomBinary(cbMin, cbMax, (byte[])null);
    }

    public static Binary getRandomBinary(int cbMin, int cbMax, byte ... abHead) {
        assert (cbMin >= 0);
        assert (cbMax >= cbMin);
        Random rnd = Randoms.getRandom();
        int cbDif = cbMax - cbMin;
        int cbHead = abHead == null ? 0 : abHead.length;
        int cb = (cbDif <= 0 ? cbMax : cbMin + rnd.nextInt(cbDif)) + cbHead;
        byte[] ab = new byte[cb];
        rnd.nextBytes(ab);
        if (cbHead > 0) {
            System.arraycopy(abHead, 0, ab, 0, cbHead);
        }
        return new Binary(ab);
    }

    public static String getRandomString(int cchMin, int cchMax, boolean fAscii) {
        int cch;
        assert (cchMin >= 0);
        assert (cchMax >= cchMin);
        Random rnd = Randoms.getRandom();
        int cchDif = cchMax - cchMin;
        int n = cch = cchDif <= 0 ? cchMax : cchMin + rnd.nextInt(cchDif);
        if (fAscii) {
            byte[] ab = new byte[cch];
            rnd.nextBytes(ab);
            for (int of = 0; of < cch; ++of) {
                int b = ab[of] & 0x7F;
                if (b < 32) {
                    b = 32 + rnd.nextInt(95);
                }
                ab[of] = (byte)b;
            }
            return new String(ab, 0);
        }
        char[] ach = new char[cch];
        int nLimit = 65536;
        for (int of = 0; of < cch; ++of) {
            ach[of] = (char)rnd.nextInt(nLimit);
        }
        return new String(ach);
    }
}

