/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.coherence.common.collections;

import java.io.Externalizable;
import java.io.IOException;
import java.io.NotActiveException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;

public class InflatableMap<K, V>
extends AbstractMap<K, V>
implements Cloneable,
Externalizable {
    private static final Object[] NO_OBJECTS = new Object[0];
    protected static final int THRESHOLD = 8;
    private static final int I_EMPTY = 0;
    private static final int I_SINGLE = 1;
    private static final int I_ARRAY_1 = 2;
    private static final int I_ARRAY_2 = 3;
    private static final int I_ARRAY_3 = 4;
    private static final int I_ARRAY_4 = 5;
    private static final int I_ARRAY_5 = 6;
    private static final int I_ARRAY_6 = 7;
    private static final int I_ARRAY_7 = 8;
    private static final int I_ARRAY_8 = 9;
    protected static final int I_OTHER = 10;
    private static final Iterator NULL_ITERATOR = new Iterator(){

        @Override
        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }
    };
    protected byte m_nImpl;
    protected Object m_oContents;

    public InflatableMap() {
    }

    public InflatableMap(Map<? extends K, ? extends V> map) {
        this.putAll(map);
    }

    @Override
    public boolean isEmpty() {
        return this.m_nImpl == 0;
    }

    @Override
    public int size() {
        switch (this.m_nImpl) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return this.m_nImpl - 2 + 1;
            }
            case 10: {
                return ((Map)this.m_oContents).size();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean containsKey(Object oKey) {
        switch (this.m_nImpl) {
            case 0: {
                return false;
            }
            case 1: {
                Object oKeyEntry = ((Map.Entry)this.m_oContents).getKey();
                return Objects.equals(oKey, oKeyEntry);
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                Map.Entry[] aEntry = (Map.Entry[])this.m_oContents;
                int c = this.m_nImpl - 2 + 1;
                return this.indexOf(aEntry, c, oKey) >= 0;
            }
            case 10: {
                return ((Map)this.m_oContents).containsKey(oKey);
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public V get(Object oKey) {
        switch (this.m_nImpl) {
            case 0: {
                return null;
            }
            case 1: {
                Map.Entry entry = (Map.Entry)this.m_oContents;
                Object entryKey = entry.getKey();
                return Objects.equals(oKey, entryKey) ? (V)entry.getValue() : null;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                Map.Entry[] aEntry = (Map.Entry[])this.m_oContents;
                int c = this.m_nImpl - 2 + 1;
                int i = this.indexOf(aEntry, c, oKey);
                return i < 0 ? null : (V)aEntry[i].getValue();
            }
            case 10: {
                return ((Map)this.m_oContents).get(oKey);
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public V put(K key, V value) {
        switch (this.m_nImpl) {
            case 0: {
                this.m_nImpl = 1;
                this.m_oContents = this.instantiateEntry(key, value);
                return null;
            }
            case 1: {
                Map.Entry entry = (Map.Entry)this.m_oContents;
                Object entryKey = entry.getKey();
                V prevValue = null;
                if (Objects.equals(key, entryKey)) {
                    prevValue = entry.getValue();
                    entry.setValue(value);
                } else {
                    Map.Entry[] aEntry = new Map.Entry[8];
                    aEntry[0] = entry;
                    aEntry[1] = this.instantiateEntry(key, value);
                    this.m_nImpl = (byte)3;
                    this.m_oContents = aEntry;
                }
                return prevValue;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                byte nImpl = this.m_nImpl;
                Map.Entry[] aEntry = (Map.Entry[])this.m_oContents;
                int c = nImpl - 2 + 1;
                int i = this.indexOf(aEntry, c, key);
                if (i >= 0) {
                    Map.Entry entry = aEntry[i];
                    Object prevValue = entry.getValue();
                    entry.setValue(value);
                    return prevValue;
                }
                if (c >= 8) {
                    Map<K, V> map = this.instantiateMap();
                    for (i = 0; i < c; ++i) {
                        Map.Entry entry = aEntry[i];
                        map.put(entry.getKey(), entry.getValue());
                    }
                    map.put(key, value);
                    this.m_nImpl = (byte)10;
                    this.m_oContents = map;
                } else {
                    aEntry[c] = this.instantiateEntry(key, value);
                    this.m_nImpl = (byte)(nImpl + 1);
                }
                return null;
            }
            case 10: {
                return ((Map)this.m_oContents).put(key, value);
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public V remove(Object oKey) {
        switch (this.m_nImpl) {
            case 0: {
                return null;
            }
            case 1: {
                Map.Entry entry = (Map.Entry)this.m_oContents;
                Object entryKey = entry.getKey();
                V prevValue = null;
                if (Objects.equals(oKey, entryKey)) {
                    prevValue = entry.getValue();
                    this.m_nImpl = 0;
                    this.m_oContents = null;
                }
                return prevValue;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                int nImpl = this.m_nImpl;
                Map.Entry[] aEntry = (Map.Entry[])this.m_oContents;
                int c = nImpl - 2 + 1;
                int i = this.indexOf(aEntry, c, oKey);
                if (i < 0) {
                    return null;
                }
                Object prevValue = aEntry[i].getValue();
                if (c == 1) {
                    this.m_nImpl = 0;
                    this.m_oContents = null;
                } else {
                    System.arraycopy(aEntry, i + 1, aEntry, i, c - i - 1);
                    aEntry[c - 1] = null;
                    this.m_nImpl = (byte)(--nImpl);
                }
                return prevValue;
            }
            case 10: {
                Map map = (Map)this.m_oContents;
                Object prevValue = map.remove(oKey);
                this.checkShrinkFromOther();
                return prevValue;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public void clear() {
        this.m_nImpl = 0;
        this.m_oContents = null;
    }

    @Override
    public Object clone() {
        InflatableMap that;
        try {
            that = (InflatableMap)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw this.ensureRuntimeException(e);
        }
        switch (this.m_nImpl) {
            case 0: {
                break;
            }
            case 1: {
                Map.Entry entry = (Map.Entry)this.m_oContents;
                that.m_oContents = that.instantiateEntry(entry.getKey(), entry.getValue());
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                Map.Entry[] aEntryThis = (Map.Entry[])this.m_oContents;
                Map.Entry[] aEntryThat = new Map.Entry[8];
                int c = this.m_nImpl - 2 + 1;
                for (int i = 0; i < c; ++i) {
                    Map.Entry entryThis = aEntryThis[i];
                    aEntryThat[i] = that.instantiateEntry(entryThis.getKey(), entryThis.getValue());
                }
                that.m_oContents = aEntryThat;
                break;
            }
            case 10: {
                Map mapThis = (Map)this.m_oContents;
                Map<K, V> mapThat = that.instantiateMap();
                mapThat.putAll(mapThis);
                that.m_oContents = mapThat;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return that;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.instantiateEntrySet();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        if (!this.isEmpty()) {
            throw new NotActiveException();
        }
        int c = in.readInt();
        switch (c) {
            case 0: {
                break;
            }
            case 1: {
                this.m_nImpl = 1;
                this.m_oContents = this.instantiateEntry(in.readObject(), in.readObject());
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                Map.Entry[] aEntry = new Map.Entry[8];
                for (int i = 0; i < c; ++i) {
                    aEntry[i] = this.instantiateEntry(in.readObject(), in.readObject());
                }
                this.m_nImpl = (byte)(2 + c - 1);
                this.m_oContents = aEntry;
                break;
            }
            default: {
                Map<Object, Object> map = this.instantiateMap();
                for (int i = 0; i < c; ++i) {
                    map.put(in.readObject(), in.readObject());
                }
                this.m_nImpl = (byte)10;
                this.m_oContents = map;
            }
        }
    }

    @Override
    public synchronized void writeExternal(ObjectOutput out) throws IOException {
        byte nImpl = this.m_nImpl;
        switch (nImpl) {
            case 0: {
                out.writeInt(0);
                break;
            }
            case 1: {
                Map.Entry entry = (Map.Entry)this.m_oContents;
                out.writeInt(1);
                out.writeObject(entry.getKey());
                out.writeObject(entry.getValue());
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                Map.Entry[] aEntry = (Map.Entry[])this.m_oContents;
                int c = nImpl - 2 + 1;
                out.writeInt(c);
                for (int i = 0; i < c; ++i) {
                    Map.Entry entry = aEntry[i];
                    out.writeObject(entry.getKey());
                    out.writeObject(entry.getValue());
                }
                break;
            }
            case 10: {
                Map map = (Map)this.m_oContents;
                int c = map.size();
                Map.Entry[] aEntry = map.entrySet().toArray(new Map.Entry[c]);
                out.writeInt(c);
                for (int i = 0; i < c; ++i) {
                    Map.Entry entry = aEntry[i];
                    out.writeObject(entry.getKey());
                    out.writeObject(entry.getValue());
                }
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    protected Map.Entry<K, V> instantiateEntry(K key, V value) {
        return new AbstractMap.SimpleEntry<K, V>(key, value);
    }

    protected Set<Map.Entry<K, V>> instantiateEntrySet() {
        return new EntrySet();
    }

    protected Map<K, V> instantiateMap() {
        return new HashMap();
    }

    private int indexOf(Map.Entry<K, V>[] aEntry, int c, Object oKey) {
        int i;
        for (i = 0; i < c; ++i) {
            if (oKey != aEntry[i].getKey()) continue;
            return i;
        }
        if (oKey != null) {
            for (i = 0; i < c; ++i) {
                if (!oKey.equals(aEntry[i].getKey())) continue;
                return i;
            }
        }
        return -1;
    }

    protected RuntimeException ensureRuntimeException(Throwable t) {
        return t instanceof RuntimeException ? (RuntimeException)t : new RuntimeException(t);
    }

    protected void checkShrinkFromOther() {
        assert (this.m_nImpl == 10);
        Map map = (Map)this.m_oContents;
        int c = map.size();
        switch (c) {
            case 0: {
                this.m_nImpl = 0;
                this.m_oContents = null;
                break;
            }
            case 1: {
                Map.Entry entry = (Map.Entry)map.entrySet().toArray()[0];
                this.m_nImpl = 1;
                this.m_oContents = this.instantiateEntry(entry.getKey(), entry.getValue());
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                Map.Entry[] aEntry = new Map.Entry[8];
                int i = 0;
                for (Map.Entry entry : map.entrySet()) {
                    aEntry[i++] = this.instantiateEntry(entry.getKey(), entry.getValue());
                }
                assert (i == c);
                this.m_nImpl = (byte)(2 + i - 1);
                this.m_oContents = aEntry;
            }
        }
    }

    public static class EntryIterator<K, V>
    implements Iterator<Map.Entry<K, V>> {
        Map<K, V> m_map;
        Map.Entry<K, V>[] m_aEntry;
        int m_iPrev = -1;
        boolean m_fCanRemove = false;

        public EntryIterator(InflatableMap<K, V> map, Map.Entry<K, V>[] aEntry) {
            this.m_map = map;
            this.m_aEntry = aEntry;
        }

        @Override
        public boolean hasNext() {
            return this.m_iPrev + 1 < this.m_aEntry.length;
        }

        @Override
        public Map.Entry<K, V> next() {
            int iNext = this.m_iPrev + 1;
            if (iNext < this.m_aEntry.length) {
                this.m_iPrev = iNext;
                this.m_fCanRemove = true;
                return this.m_aEntry[iNext];
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (!this.m_fCanRemove) {
                throw new IllegalStateException();
            }
            this.m_fCanRemove = false;
            this.m_map.remove(this.m_aEntry[this.m_iPrev].getKey());
        }
    }

    protected class EntrySet
    extends AbstractSet<Map.Entry<K, V>>
    implements Serializable {
        protected EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            InflatableMap map = InflatableMap.this;
            int c = map.size();
            return c == 0 ? NULL_ITERATOR : new EntryIterator(map, (Map.Entry[])this.toArray(new Map.Entry[c]));
        }

        @Override
        public boolean isEmpty() {
            return InflatableMap.this.isEmpty();
        }

        @Override
        public int size() {
            return InflatableMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)o;
                Object oKey = entry.getKey();
                Object oValue = entry.getValue();
                InflatableMap map = InflatableMap.this;
                Object oActual = map.get(oKey);
                return oActual == null ? oValue == null && map.containsKey(oKey) : Objects.equals(oValue, oActual);
            }
            return false;
        }

        @Override
        public Object[] toArray() {
            return this.toArray((Object[])null);
        }

        @Override
        public Object[] toArray(Object[] ao) {
            InflatableMap map = InflatableMap.this;
            int c = map.size();
            if (ao == null) {
                ao = c == 0 ? NO_OBJECTS : new Object[c];
            } else if (ao.length < c) {
                ao = (Object[])Array.newInstance(ao.getClass().getComponentType(), c);
            } else if (ao.length > c) {
                ao[c] = null;
            }
            switch (map.m_nImpl) {
                case 0: {
                    break;
                }
                case 1: {
                    ao[0] = map.m_oContents;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    System.arraycopy((Map.Entry[])InflatableMap.this.m_oContents, 0, ao, 0, c);
                    break;
                }
                case 10: {
                    ao = ((Map)InflatableMap.this.m_oContents).entrySet().toArray(ao);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            return ao;
        }
    }
}

